/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.ZipArchiveDataNode;

public class ZipBranchDataNode
extends DefaultDataNode {
    private final ZipArchiveDataNode ziparchivenode;
    private final ZipEntry zipentry;
    private final String path;
    private String name;

    public ZipBranchDataNode(ZipArchiveDataNode ziparchivenode, ZipEntry entry) {
        this.ziparchivenode = ziparchivenode;
        this.zipentry = entry;
        this.path = entry.getName();
        this.name = this.path.substring(this.path.substring(0, this.path.length() - 1).lastIndexOf(47) + 1);
        if (this.name.endsWith("/")) {
            this.name = this.name.substring(0, this.name.length() - 1);
        }
        this.setLabel(this.name);
        this.setIconID((short)109);
    }

    public String getName() {
        return this.name;
    }

    public String getPathElement() {
        return this.name;
    }

    public String getPathSeparator() {
        return "/";
    }

    public String getNodeTLA() {
        return "ZPD";
    }

    public String getNodeType() {
        return "Directory in Zip archive";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        try {
            return this.ziparchivenode.getChildIteratorAtLevel(this.path, this);
        }
        catch (IOException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
    }

    public void configureDetail(DetailViewer dv) {
        try {
            int nent = this.ziparchivenode.getEntriesAtLevel(this.path).size();
            dv.addKeyedItem("Number of entries", nent);
        }
        catch (IOException e) {}
    }
}

