/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree.select;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.tree.select.NodeChain;

class NodeListCellRenderer
implements ListCellRenderer {
    private final ListCellRenderer baseRenderer_;

    public NodeListCellRenderer(ListCellRenderer base) {
        this.baseRenderer_ = base;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        Icon baseIcon;
        int depth;
        if (value instanceof DataNode) {
            DataNode node = (DataNode)value;
            value = node.getName();
            depth = new NodeChain(node).getDepth();
            baseIcon = node.getIcon();
        } else {
            depth = 0;
            baseIcon = null;
        }
        Component comp = this.baseRenderer_.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
        if (comp instanceof JLabel && baseIcon != null) {
            final int offset = 2 + (index >= 0 ? depth * 10 : 0);
            Icon icon = new Icon(){

                public int getIconHeight() {
                    return baseIcon.getIconHeight();
                }

                public int getIconWidth() {
                    return baseIcon.getIconWidth() + offset;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    baseIcon.paintIcon(c, g, x + offset, y);
                }
            };
            ((JLabel)comp).setIcon(icon);
        }
        return comp;
    }
}

