/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree.select;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.connect.ConnectorManager;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.tree.select.ConnectorDataNode;
import uk.ac.starlink.datanode.tree.select.NodeChain;
import uk.ac.starlink.datanode.tree.select.NodeListCellRenderer;
import uk.ac.starlink.datanode.tree.select.NodeRootModel;

public class NodeRootComboBox
extends JComboBox {
    private NodeRootModel model_;
    private final DataNodeFactory factory_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$tree$select$NodeRootComboBox;

    public NodeRootComboBox(DataNodeFactory factory) {
        super(new NodeRootModel(factory));
        this.factory_ = factory;
        if (!$assertionsDisabled && !(this.model_ instanceof NodeRootModel)) {
            throw new AssertionError();
        }
        this.setRenderer(new NodeListCellRenderer(this.getRenderer()));
    }

    public void setModel(ComboBoxModel model) {
        this.model_ = (NodeRootModel)model;
        super.setModel(model);
    }

    public ComboBoxModel getModel() {
        if (!$assertionsDisabled && this.model_ != super.getModel()) {
            throw new AssertionError();
        }
        return this.model_;
    }

    public DataNode getSelectedNode() {
        return this.model_.getSelectedNode();
    }

    public ConnectorAction getConnectorAction() {
        return this.model_.getConnectorAction();
    }

    public void addDefaultRoots() {
        File[] fileRoots = File.listRoots();
        int i = 0;
        while (i < fileRoots.length) {
            File dir = fileRoots[i];
            if (dir.isDirectory() && dir.canRead()) {
                try {
                    DataNode dirNode = this.factory_.makeDataNode(null, dir);
                    this.model_.addChain(new NodeChain(dirNode));
                }
                catch (NoSuchDataException e) {
                    logger_.warning("Can't read directory " + dir + ": " + e);
                }
            } else {
                logger_.warning("Local filesystem root " + dir + " is not a readable directory");
            }
            ++i;
        }
        ConnectorAction[] actions = ConnectorManager.getConnectorActions();
        int i2 = 0;
        while (i2 < actions.length) {
            ConnectorDataNode node = new ConnectorDataNode(actions[i2]);
            this.factory_.configureDataNode(node, null, actions[i2]);
            this.model_.addChain(new NodeChain(node));
            ++i2;
        }
        File dir = new File(".");
        try {
            dir = new File(System.getProperty("user.dir"));
        }
        catch (SecurityException e) {
            logger_.warning("Can't get current directory");
        }
        if (dir.isDirectory()) {
            try {
                DataNode node = this.factory_.makeDataNode(null, dir);
                this.factory_.fillInAncestors(node);
                this.model_.setSelectedItem(node);
            }
            catch (NoSuchDataException e) {
                logger_.warning("Can't create node from current directory: " + e);
            }
        } else {
            logger_.warning("Can't read current directory");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$datanode$tree$select$NodeRootComboBox == null ? (class$uk$ac$starlink$datanode$tree$select$NodeRootComboBox = NodeRootComboBox.class$("uk.ac.starlink.datanode.tree.select.NodeRootComboBox")) : class$uk$ac$starlink$datanode$tree$select$NodeRootComboBox).desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.datanode.tree.select");
    }
}

