/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.jaiutil;

import com.sun.media.jai.codec.ImageCodec;
import java.awt.geom.Rectangle2D;
import java.awt.image.SampleModel;
import javax.media.jai.PlanarImage;
import jsky.image.ImageProcessor;
import uk.ac.starlink.jaiutil.HDXCodec;
import uk.ac.starlink.jaiutil.HDXImage;

public class HDXImageProcessor
extends ImageProcessor {
    public HDXImageProcessor() {
    }

    public HDXImageProcessor(PlanarImage sourceImage, Rectangle2D.Double region) {
        this.setSourceImage(sourceImage, region);
    }

    public void setSourceImage(PlanarImage sourceImage, Rectangle2D.Double region) {
        super.setSourceImage(sourceImage, region);
        if (sourceImage == null) {
            return;
        }
        SampleModel sampleModel = sourceImage.getSampleModel();
        if (sampleModel == null) {
            return;
        }
        Object o = sourceImage.getProperty("#ndx_image");
        if (o instanceof HDXImage) {
            HDXImage hdxImage = (HDXImage)o;
            this._reverseY = true;
            if (sampleModel.getNumBands() == 1) {
                this.setBlank(hdxImage.getBadValue());
                if (!this.isUserSetCutLevels()) {
                    this.autoSetCutLevels(region);
                } else {
                    this.setRegionOfInterest(region);
                    this.setCutLevels(this.getLowCut(), this.getHighCut(), true);
                }
            }
        }
    }

    static {
        ImageCodec.registerCodec((ImageCodec)new HDXCodec());
    }
}

