/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.jaiutil;

import java.awt.Point;
import java.awt.image.Raster;
import java.util.Iterator;
import java.util.LinkedList;

public class MyTileCache {
    private int memoryCapacity;
    private int tileCapacity;
    private Raster[][] tiles;
    private int numXTiles;
    private int numYTiles;
    private LinkedList tileIndexes = new LinkedList();
    private int numTiles = 0;

    public MyTileCache(int imageWidth, int imageHeight, int tileWidth, int tileHeight, int bytesPerPixel, int memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
        this.tileCapacity = memoryCapacity / (tileWidth * tileHeight * bytesPerPixel);
        if (this.tileCapacity == 0) {
            this.tileCapacity = 1;
        }
        this.numXTiles = imageWidth / tileWidth + 1;
        this.numYTiles = imageHeight / tileHeight + 1;
        this.tiles = new Raster[this.numXTiles][this.numYTiles];
    }

    public MyTileCache(int imageWidth, int imageHeight, int tileWidth, int tileHeight, int bytesPerPixel) {
        this(imageWidth, imageHeight, tileWidth, tileHeight, bytesPerPixel, 0x1400000);
    }

    public void add(int tileX, int tileY, Raster tile) {
        if (this.numTiles >= this.tileCapacity) {
            Point p = (Point)this.tileIndexes.removeFirst();
            this.tiles[(int)p.getX()][(int)p.getY()] = null;
            --this.numTiles;
        }
        this.tiles[tileX][tileY] = tile;
        this.tileIndexes.add(new Point(tileX, tileY));
        ++this.numTiles;
    }

    public void remove(int tileX, int tileY) {
        this.tiles[tileX][tileY] = null;
        if (this.tileIndexes.remove(new Point(tileX, tileY))) {
            --this.numTiles;
        }
    }

    public void clear() {
        Iterator it = ((LinkedList)this.tileIndexes.clone()).iterator();
        while (it.hasNext()) {
            Point p = (Point)it.next();
            this.remove((int)p.getX(), (int)p.getY());
        }
        System.gc();
    }

    public Raster getTile(int tileX, int tileY) {
        return this.tiles[tileX][tileY];
    }

    public int getTileCapacity() {
        return this.tileCapacity;
    }

    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }
}

