/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndx;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayBuilder;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrayFactory;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.xml.XAstReader;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.ndx.BridgeNdx;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxHandler;
import uk.ac.starlink.ndx.NdxImpl;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.URLUtils;

public class XMLNdxHandler
implements NdxHandler {
    private static XMLNdxHandler instance;
    private static NDArrayFactory arrayfact;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ndx$XMLNdxHandler;

    private XMLNdxHandler() {
    }

    public static XMLNdxHandler getInstance() {
        return instance;
    }

    public Ndx makeNdx(URL url, AccessMode mode) throws IOException {
        StreamSource xsrc;
        if (url.toString().equals("file:-")) {
            xsrc = new StreamSource(System.in);
        } else if (this.isXmlUrl(url)) {
            xsrc = new StreamSource(url.toString());
        } else {
            return null;
        }
        return this.makeNdx(xsrc, mode);
    }

    public Ndx makeNdx(Source xsrc, AccessMode mode) throws IOException {
        Element ndxel;
        Element hdxel;
        Node ndxdom;
        String systemId = xsrc.getSystemId();
        try {
            ndxdom = new SourceReader().getDOM(xsrc);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        if (ndxdom instanceof Document) {
            hdxel = ((Document)ndxdom).getDocumentElement();
        } else if (ndxdom instanceof Element) {
            hdxel = (Element)ndxdom;
        } else {
            throw new IllegalArgumentException("Not a Document or Element");
        }
        if (!$assertionsDisabled && hdxel == null) {
            throw new AssertionError();
        }
        HdxResourceType ndxType = BridgeNdx.getHdxResourceType();
        if (HdxResourceType.match((Element)hdxel) == HdxResourceType.HDX) {
            Element kid = null;
            Node n = hdxel.getFirstChild();
            while (n != null) {
                if (n.getNodeType() != 1) {
                    if (logger.isLoggable(Level.INFO)) {
                        String nv = n.getNodeValue();
                        logger.info("Non-element node " + n.getNodeName() + "=" + (nv == null ? "<null>" : nv) + " ignored");
                    }
                } else if (HdxResourceType.match((Element)((Element)n)) == ndxType) {
                    if (kid != null) {
                        throw new IOException("Can't make Ndx from HDX with multiple Ndx children");
                    }
                    kid = (Element)n;
                }
                n = n.getNextSibling();
            }
            if (kid == null) {
                throw new IOException("Can't make Ndx from HDX with no Ndx children");
            }
            ndxel = kid;
        } else if (HdxResourceType.match((Element)hdxel) == ndxType) {
            ndxel = hdxel;
        } else {
            throw new IOException("XML element of type <" + hdxel.getTagName() + "> not <" + ndxType.xmlName() + ">");
        }
        if (!$assertionsDisabled && ndxel == null) {
            throw new AssertionError();
        }
        Document doc = ndxel.getOwnerDocument();
        NDArray image = null;
        NDArray variance = null;
        NDArray quality = null;
        String title = null;
        String label = null;
        String units = null;
        FrameSet wcs = null;
        int badbits = 0;
        Element etc = null;
        Node child = ndxel.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                Element cel = (Element)child;
                String tagname = cel.getTagName();
                if (tagname.equals("image")) {
                    image = this.makeNDArray(cel, mode, systemId);
                } else if (tagname.equals("variance")) {
                    variance = this.makeNDArray(cel, mode, systemId);
                } else if (tagname.equals("quality")) {
                    quality = this.makeNDArray(cel, mode, systemId);
                } else if (tagname.equals("title")) {
                    title = cel.getAttribute("value");
                    if (title.length() == 0) {
                        title = this.getTextContent(cel);
                    }
                } else if (tagname.equals("label")) {
                    label = cel.getAttribute("value");
                    if (label.length() == 0) {
                        label = this.getTextContent(cel);
                    }
                } else if (tagname.equals("units")) {
                    units = cel.getAttribute("value");
                    if (units.length() == 0) {
                        units = this.getTextContent(cel);
                    }
                } else if (tagname.equals("badbits")) {
                    String badbitsString = cel.getAttribute("value");
                    try {
                        if (badbitsString.length() == 0) {
                            badbitsString = this.getTextContent(cel);
                        }
                        badbits = Long.decode(badbitsString).intValue();
                    }
                    catch (NumberFormatException e) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("badbits element had bad content \"" + badbitsString + "\": ignored");
                        }
                        badbits = 0;
                    }
                } else if (tagname.equals("wcs") && AstPackage.isAvailable()) {
                    DOMSource wcssrc = null;
                    Node ch = cel.getFirstChild();
                    while (ch != null) {
                        String chname;
                        if (ch instanceof Element && (chname = ((Element)ch).getTagName()).equals("FrameSet")) {
                            wcssrc = new DOMSource(ch);
                            break;
                        }
                        ch = ch.getNextSibling();
                    }
                    try {
                        wcs = (FrameSet)new XAstReader().makeAst(wcssrc);
                    }
                    catch (IOException e) {
                        wcs = null;
                    }
                    if (wcs == null) {
                        logger.warning("Broken WCS element");
                    }
                } else if (tagname.equals("etc")) {
                    etc = doc.createElement("etc");
                    Node ext = cel.getFirstChild();
                    while (ext != null) {
                        etc.appendChild(doc.importNode(ext, true));
                        ext = ext.getNextSibling();
                    }
                }
            }
            child = child.getNextSibling();
        }
        return this.makeNdx(image, variance, quality, title, label, units, wcs, badbits, etc);
    }

    private NDArray makeNDArray(Element el, AccessMode mode, String systemId) throws IOException {
        String loc = el.hasAttribute("uri") ? el.getAttribute("uri") : (el.hasAttribute("url") ? el.getAttribute("url") : this.getTextContent(el));
        if (loc == null || loc.trim().length() == 0) {
            throw new IOException("No location supplied for <" + el.getTagName() + "> array");
        }
        URL url = URLUtils.makeURL((String)systemId, (String)loc);
        return arrayfact.makeNDArray(url, mode);
    }

    private String getTextContent(Element el) {
        String content = "";
        Node sub = el.getFirstChild();
        while (sub != null) {
            if (sub instanceof Text || sub instanceof CDATASection) {
                content = content + ((CharacterData)sub).getData();
            }
            sub = sub.getNextSibling();
        }
        return content;
    }

    private Ndx makeNdx(final NDArray image, final NDArray variance, final NDArray quality, final String title, final String label, final String units, final FrameSet wcs, final int badbits, final Node etc) throws IOException {
        if (image == null) {
            throw new IOException("No <image> component found");
        }
        NdxImpl impl = new NdxImpl(){

            public NDArray getImage() {
                return image;
            }

            public NDArray getVariance() {
                return variance;
            }

            public NDArray getQuality() {
                return quality;
            }

            public String getTitle() {
                return title;
            }

            public String getLabel() {
                return label;
            }

            public String getUnits() {
                return units;
            }

            public Object getWCS() {
                return wcs;
            }

            public int getBadBits() {
                return badbits;
            }

            public Source getEtc() {
                return new DOMSource(etc);
            }

            public boolean hasTitle() {
                return title != null;
            }

            public boolean hasLabel() {
                return label != null;
            }

            public boolean hasUnits() {
                return units != null;
            }

            public boolean hasVariance() {
                return variance != null;
            }

            public boolean hasQuality() {
                return quality != null;
            }

            public boolean hasWCS() {
                return wcs != null;
            }

            public boolean hasEtc() {
                return etc != null;
            }
        };
        return new BridgeNdx(impl);
    }

    public boolean outputNdx(URL xurl, Ndx ndx) throws IOException {
        Source xsrc;
        OutputStream xstrm;
        boolean writeArrays;
        URL aurl = null;
        ArrayBuilder fab = null;
        if (!ndx.isPersistent()) {
            aurl = XMLNdxHandler.getDataUrl(xurl);
            fab = XMLNdxHandler.getFitsArrayBuilder();
        }
        boolean bl = writeArrays = aurl != null;
        if (xurl.toString().equals("file:-")) {
            if (writeArrays) {
                throw new IOException("Cannot serialise non-persistent NDX to a stream");
            }
            xstrm = System.out;
        } else if (this.isXmlUrl(xurl)) {
            if (xurl.getProtocol().equals("file")) {
                xstrm = new FileOutputStream(xurl.getPath());
            } else {
                URLConnection xconn = xurl.openConnection();
                xconn.setDoInput(false);
                xconn.setDoOutput(true);
                xconn.connect();
                xstrm = xconn.getOutputStream();
            }
            xstrm = new BufferedOutputStream(xstrm);
        } else {
            return false;
        }
        try {
            if (!writeArrays) {
                xsrc = HdxFactory.getInstance().newHdxContainer(ndx.getHdxFacade()).getSource(null);
            } else {
                NDArray qnda2;
                NDArray vnda2;
                int hdu = 0;
                URL iurl = new URL(aurl, "#" + hdu++);
                NDArray inda1 = ndx.getImage();
                NDArray inda2 = fab.makeNewNDArray(iurl, inda1.getShape(), inda1.getType(), inda1.getBadHandler());
                NDArrays.copy(inda1, inda2);
                if (ndx.hasVariance()) {
                    URL vurl = new URL(aurl, "#" + hdu++);
                    NDArray vnda1 = ndx.getVariance();
                    vnda2 = fab.makeNewNDArray(vurl, vnda1.getShape(), vnda1.getType(), vnda1.getBadHandler());
                    NDArrays.copy(vnda1, vnda2);
                } else {
                    vnda2 = null;
                }
                if (ndx.hasQuality()) {
                    URL qurl = new URL(aurl, "#" + hdu++);
                    NDArray qnda1 = ndx.getQuality();
                    BadHandler qbh = BadHandler.getHandler(qnda1.getType(), null);
                    qnda2 = fab.makeNewNDArray(qurl, qnda1.getShape(), qnda1.getType(), qbh);
                    NDArrays.copy(qnda1, qnda2);
                } else {
                    qnda2 = null;
                }
                DefaultMutableNdx ndx2 = new DefaultMutableNdx(ndx);
                ndx2.setImage(inda2);
                ndx2.setVariance(vnda2);
                ndx2.setQuality(qnda2);
                xsrc = HdxFactory.getInstance().newHdxContainer(ndx2.getHdxFacade()).getSource(URLUtils.urlToUri((URL)xurl));
            }
        }
        catch (HdxException ex) {
            throw new IOException("Trouble constructing HdxContainer");
        }
        SourceReader sr = new SourceReader();
        sr.setIncludeDeclaration(true);
        sr.setIndent(2);
        try {
            sr.writeSource(xsrc, xstrm);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException("Trouble writing XML").initCause(e);
        }
        xstrm.close();
        return true;
    }

    public boolean makeBlankNdx(URL url, Ndx template) throws IOException {
        NDArray qnda2;
        if (!this.isXmlUrl(url)) {
            return false;
        }
        URL xurl = url;
        URL aurl = XMLNdxHandler.getDataUrl(xurl);
        ArrayBuilder fab = XMLNdxHandler.getFitsArrayBuilder();
        OutputStream xstrm = new FileOutputStream(xurl.getPath());
        xstrm = new BufferedOutputStream(xstrm);
        int hdu = 0;
        URL iurl = new URL(aurl, "#" + hdu++);
        NDArray inda1 = template.getImage();
        NDArray inda2 = fab.makeNewNDArray(iurl, inda1.getShape(), inda1.getType(), inda1.getBadHandler());
        if (template.hasVariance()) {
            URL vurl = new URL(aurl, "#" + hdu++);
            NDArray vnda1 = template.getVariance();
            NDArray vnda2 = fab.makeNewNDArray(vurl, vnda1.getShape(), vnda1.getType(), vnda1.getBadHandler());
        } else {
            Object vnda2 = null;
        }
        if (template.hasQuality()) {
            URL qurl = new URL(aurl, "#" + hdu++);
            NDArray qnda1 = template.getQuality();
            BadHandler qbh = BadHandler.getHandler(qnda1.getType(), null);
            qnda2 = fab.makeNewNDArray(qurl, qnda1.getShape(), qnda1.getType(), qbh);
        } else {
            qnda2 = null;
        }
        DefaultMutableNdx ndx = new DefaultMutableNdx(template);
        SourceReader sr = new SourceReader();
        sr.setIncludeDeclaration(true);
        sr.setIndent(2);
        try {
            sr.writeSource(ndx.getHdxFacade().getSource(URLUtils.urlToUri((URL)xurl)), xstrm);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException("Trouble writing XML").initCause(e);
        }
        catch (HdxException e) {
            throw (IOException)new IOException("Trouble with HDX").initCause(e);
        }
        xstrm.close();
        return true;
    }

    private boolean isXmlUrl(URL url) {
        return url.getPath().endsWith(".xml");
    }

    private static URL getDataUrl(URL baseUrl) throws IOException {
        if (baseUrl.toString().endsWith(".xml")) {
            String dloc = baseUrl.toString().replaceFirst(".xml$", "-data.fits");
            try {
                return new URL(dloc);
            }
            catch (MalformedURLException e) {
                throw new AssertionError();
            }
        }
        throw new IOException("Cannot write data for base URL <" + baseUrl + "> not ending in '.xml'");
    }

    private static ArrayBuilder getFitsArrayBuilder() throws IOException {
        Iterator it = arrayfact.getBuilders().iterator();
        while (it.hasNext()) {
            ArrayBuilder builder = (ArrayBuilder)it.next();
            if (!builder.getClass().getName().equals("uk.ac.starlink.fits.FitsArrayBuilder")) continue;
            return builder;
        }
        throw new IOException("Can't get FitsArrayBuilder - FITS package not installed");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ndx$XMLNdxHandler == null ? (class$uk$ac$starlink$ndx$XMLNdxHandler = XMLNdxHandler.class$("uk.ac.starlink.ndx.XMLNdxHandler")) : class$uk$ac$starlink$ndx$XMLNdxHandler).desiredAssertionStatus();
        instance = new XMLNdxHandler();
        arrayfact = new NDArrayFactory();
        logger = Logger.getLogger("uk.ac.starlink.ndx");
    }
}

