/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.DockBoundary;

class StackingDockBoundary
extends DockBoundary {
    private ArrayList ourDockSlivers = new ArrayList();

    public StackingDockBoundary(int edge) {
        super(edge);
    }

    public StackingDockBoundary(int edge, int spacing) {
        super(edge, spacing);
    }

    public int getDockIndex(Point p) {
        int i = 0;
        while (i < this.ourDockSlivers.size()) {
            DockSliver sliver = (DockSliver)this.ourDockSlivers.get(i);
            if (sliver.contains(p)) {
                return sliver.getDockIndex(p);
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public int getDockIndex(JToolBar toolbar) {
        DockSliver sliver = this.getDockSliver(toolbar);
        if (sliver == null) {
            return -1;
        }
        return sliver.getDockIndex(toolbar);
    }

    public int getRowIndex(Point p) {
        int i = 0;
        while (i < this.ourDockSlivers.size()) {
            DockSliver sliver = (DockSliver)this.ourDockSlivers.get(i);
            if (sliver.contains(p)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public int getRowIndex(JToolBar toolbar) {
        int i = 0;
        while (i < this.ourDockSlivers.size()) {
            DockSliver sliver = (DockSliver)this.ourDockSlivers.get(i);
            if (sliver.containsToolBar(toolbar)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void validate() {
        int spacing = this.getSpacing();
        int orientation = this.getOrientation();
        int edge = this.getEdge();
        int length = 0;
        length = orientation == 0 ? this.width : this.height;
        int totalDepth = 0;
        int i = 0;
        while (i < this.ourDockSlivers.size()) {
            DockSliver sliver = (DockSliver)this.ourDockSlivers.get(i);
            if (totalDepth != 0) {
                totalDepth += spacing;
            }
            if (orientation == 0) {
                sliver.setPosition(this.x, this.y + totalDepth, length);
            } else {
                sliver.setPosition(this.x + totalDepth, this.y, length);
            }
            if (edge == 3 || edge == 5) {
                Rectangle r = sliver.getBounds();
                if (orientation == 0) {
                    this.mirrorBounds(r, this.y);
                } else {
                    this.mirrorBounds(r, this.x);
                }
                sliver.setBounds(r);
                sliver.validate();
            }
            totalDepth += sliver.getDepth();
            ++i;
        }
        this.setDepth(totalDepth);
    }

    protected void toolBarAdded(JToolBar toolbar, int rowIndex, int index) {
        this.getDockSliver(rowIndex).addToolBar(toolbar, index);
    }

    protected void toolBarRemoved(JToolBar toolbar) {
        DockSliver sliver = this.getDockSliver(toolbar);
        if (sliver != null) {
            sliver.removeToolBar(toolbar);
            if (sliver.getToolBarCount() == 0) {
                ((AbstractCollection)this.ourDockSlivers).remove(sliver);
            }
        }
    }

    private DockSliver getDockSliver(int row) {
        if (row < 0) {
            DockSliver sliver = new DockSliver();
            this.ourDockSlivers.add(0, sliver);
            return sliver;
        }
        if (row >= this.ourDockSlivers.size()) {
            DockSliver sliver = new DockSliver();
            this.ourDockSlivers.add(sliver);
            return sliver;
        }
        return (DockSliver)this.ourDockSlivers.get(row);
    }

    private DockSliver getDockSliver(JToolBar toolbar) {
        int i = 0;
        while (i < this.ourDockSlivers.size()) {
            DockSliver sliver = (DockSliver)this.ourDockSlivers.get(i);
            if (sliver.containsToolBar(toolbar)) {
                return sliver;
            }
            ++i;
        }
        return null;
    }

    private class DockSliver
    extends Rectangle {
        private ArrayList myToolBars = new ArrayList();

        public void addToolBar(JToolBar toolbar) {
            this.myToolBars.add(toolbar);
        }

        public void addToolBar(JToolBar toolbar, int index) {
            if (index < 0) {
                this.myToolBars.add(0, toolbar);
            } else if (index >= this.myToolBars.size()) {
                this.myToolBars.add(toolbar);
            } else {
                this.myToolBars.add(index, toolbar);
            }
        }

        public void removeToolBar(JToolBar toolbar) {
            ((AbstractCollection)this.myToolBars).remove(toolbar);
        }

        public int getToolBarCount() {
            return this.myToolBars.size();
        }

        public boolean containsToolBar(JToolBar toolbar) {
            return this.myToolBars.contains(toolbar);
        }

        public void setPosition(int x, int y, int length) {
            this.setLocation(x, y);
            if (StackingDockBoundary.this.getOrientation() == 0) {
                this.width = length;
            } else {
                this.height = length;
            }
            this.validate();
        }

        public void validate() {
            int pos = 0;
            int base = 0;
            int orient = StackingDockBoundary.this.getOrientation();
            int space = StackingDockBoundary.this.getSpacing();
            int length = 0;
            if (orient == 0) {
                pos = this.x;
                base = this.x;
                length = this.width;
                this.height = this.getPreferredDepth();
            } else {
                pos = this.y;
                base = this.y;
                length = this.height;
                this.width = this.getPreferredDepth();
            }
            int i = 0;
            while (i < this.myToolBars.size()) {
                JToolBar toolbar = (JToolBar)this.myToolBars.get(i);
                int barLength = StackingDockBoundary.this.getPreferredToolBarLength(toolbar);
                if (pos + barLength > length + base) {
                    barLength = base + length - pos;
                }
                if (orient == 0) {
                    toolbar.setBounds(pos, this.y, barLength, this.height);
                } else {
                    toolbar.setBounds(this.x, pos, this.width, barLength);
                }
                pos += barLength + space;
                ++i;
            }
        }

        public int getPreferredDepth() {
            int depth = 0;
            int i = 0;
            while (i < this.myToolBars.size()) {
                JToolBar toolbar = (JToolBar)this.myToolBars.get(i);
                int barDepth = StackingDockBoundary.this.getPreferredToolBarDepth(toolbar);
                depth = Math.max(depth, barDepth);
                ++i;
            }
            return depth;
        }

        public int getDepth() {
            if (StackingDockBoundary.this.getOrientation() == 0) {
                return this.height;
            }
            return this.width;
        }

        public int getDockIndex(Point p) {
            int i = 0;
            while (i < this.myToolBars.size()) {
                JToolBar toolbar = (JToolBar)this.myToolBars.get(i);
                if (toolbar.getBounds().contains(p)) {
                    return i;
                }
                ++i;
            }
            return Integer.MAX_VALUE;
        }

        public int getDockIndex(JToolBar toolbar) {
            return this.myToolBars.indexOf(toolbar);
        }
    }
}

