/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.tigris.toolbar.toolbutton.AbstractButtonAction;
import org.tigris.toolbar.toolbutton.ToolButtonGroup;

public class ToolButton
extends JButton {
    protected ArrayList containedGroups = new ArrayList();
    protected JButton _button;
    protected boolean selected;
    private boolean _rollover;
    private static String javaVersion = System.getProperties().getProperty("java.specification.version");

    public ToolButton(Action a) {
        super(a);
        this.addMouseListener(new MyMouseListener());
        if ("1.3".equals(System.getProperties().getProperty("java.specification.version"))) {
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    void setInGroup(ToolButtonGroup group) {
        this.containedGroups.add(group);
    }

    public void setRolloverEnabled(boolean enabled) {
        super.setRolloverEnabled(enabled);
        this._rollover = enabled;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBackground(UIManager.getColor("controlShadow"));
            super.setRolloverEnabled(false);
            Iterator it = ((AbstractList)this.containedGroups).iterator();
            while (it.hasNext()) {
                ToolButtonGroup sbg = (ToolButtonGroup)it.next();
                sbg.buttonSelected(this);
            }
        } else {
            this.setBackground(UIManager.getColor("control"));
            super.setRolloverEnabled(this._rollover);
        }
    }

    public Action getRealAction() {
        return this._button.getAction();
    }

    protected void performAction(ActionEvent actionEvent) {
        this.setSelected(!this.selected);
        Action a = this._button.getAction();
        a.actionPerformed(actionEvent);
    }

    protected class ToolButtonAction
    extends AbstractButtonAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ToolButton.this.performAction(actionEvent);
        }
    }

    private class MyMouseListener
    implements MouseListener {
        MyMouseListener() {
        }

        public void mouseEntered(MouseEvent me) {
            if (ToolButton.this.getRealAction().isEnabled()) {
                ToolButton.this.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent me) {
            if (!ToolButton.this.selected) {
                ToolButton.this.setBorderPainted(false);
            }
        }

        public void mouseClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
        }

        public void mouseReleased(MouseEvent me) {
        }
    }
}

