/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;

public abstract class BintableStarTable
extends AbstractStarTable {
    private final int ncol;
    private final int nrow;
    private final ColumnInfo[] colInfos;
    private final ColumnReader[] colReaders;
    private final int rowLength;
    private final int[] colOffsets;
    private static final ValueInfo tnullInfo = new DefaultValueInfo(Tables.NULL_VALUE_INFO.getName(), Tables.NULL_VALUE_INFO.getContentClass(), "Bad value indicator (TNULLn card)");
    private static final ValueInfo tscalInfo = new DefaultValueInfo("Scale", class$java$lang$Double == null ? (class$java$lang$Double = BintableStarTable.class$("java.lang.Double")) : class$java$lang$Double, "Multiplier for values (TSCALn card)");
    private static final ValueInfo tzeroInfo = new DefaultValueInfo("Zero", class$java$lang$Double == null ? (class$java$lang$Double = BintableStarTable.class$("java.lang.Double")) : class$java$lang$Double, "Offset for values (TZEROn card)");
    private static final ValueInfo tdispInfo = new DefaultValueInfo("Format", class$java$lang$String == null ? (class$java$lang$String = BintableStarTable.class$("java.lang.String")) : class$java$lang$String, "Display format in FORTRAN notation (TDISPn card)");
    private static final ValueInfo tbcolInfo = new DefaultValueInfo("Start column", class$java$lang$Integer == null ? (class$java$lang$Integer = BintableStarTable.class$("java.lang.Integer")) : class$java$lang$Integer, "Start column for data (TBCOLn card)");
    private static final ValueInfo tformInfo = new DefaultValueInfo("Format code", class$java$lang$String == null ? (class$java$lang$String = BintableStarTable.class$("java.lang.String")) : class$java$lang$String, "Data type code (TFORMn card)");
    private static final List auxDataInfos = Arrays.asList(tnullInfo, tscalInfo, tzeroInfo, tdispInfo, tbcolInfo, tformInfo);
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static StarTable makeRandomStarTable(Header hdr, final RandomAccess rstream) throws FitsException {
        final long dataStart = rstream.getFilePointer();
        return new BintableStarTable(hdr){
            final long rowLength;
            final int[] colOffsets;
            final int ncol;
            {
                super(x0);
                this.rowLength = this.getRowLength();
                this.colOffsets = this.getColumnOffsets();
                this.ncol = this.getColumnCount();
            }

            public boolean isRandom() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getCell(long lrow, int icol) throws IOException {
                RandomAccess randomAccess = rstream;
                synchronized (randomAccess) {
                    long offset = dataStart + lrow * this.rowLength + (long)this.colOffsets[icol];
                    rstream.seek(offset);
                    return this.readCell(rstream, icol);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getRow(long lrow) throws IOException {
                Object[] row = new Object[this.ncol];
                RandomAccess randomAccess = rstream;
                synchronized (randomAccess) {
                    rstream.seek(dataStart + lrow * this.rowLength);
                    return this.readRow(rstream);
                }
            }

            public RowSequence getRowSequence() {
                return new RandomRowSequence((StarTable)this);
            }
        };
    }

    static StarTable makeSequentialStarTable(Header hdr, final DataSource datsrc, final long offset) throws FitsException {
        final Object[] BEFORE_START = new Object[]{};
        return new BintableStarTable(hdr){

            public RowSequence getRowSequence() throws IOException {
                InputStream istrm = datsrc.getInputStream();
                if (!(istrm instanceof BufferedInputStream)) {
                    istrm = new BufferedInputStream(istrm);
                }
                DataInputStream stream = new DataInputStream(istrm);
                IOUtils.skipBytes((DataInput)stream, (long)offset);
                return new RowSequence(this, stream){
                    final long nrow;
                    final int ncol;
                    final int rowLength;
                    long lrow;
                    Object[] row;
                    private final /* synthetic */ DataInputStream val$stream;
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$stream = val$stream;
                        this.nrow = this.this$0.getRowCount();
                        this.ncol = this.this$0.getColumnCount();
                        this.rowLength = this.this$0.getRowLength();
                        this.lrow = -1L;
                        this.row = 2.access$000(this.this$0);
                    }

                    public boolean next() throws IOException {
                        if (this.lrow < this.nrow - 1L) {
                            if (this.row == null) {
                                IOUtils.skipBytes((DataInput)this.val$stream, (long)this.rowLength);
                            }
                            this.row = null;
                            ++this.lrow;
                            return true;
                        }
                        return false;
                    }

                    public Object getCell(int icol) throws IOException {
                        return this.getRow()[icol];
                    }

                    public Object[] getRow() throws IOException {
                        if (this.row == 2.access$000(this.this$0)) {
                            throw new IllegalStateException("Attempted read before start of table");
                        }
                        if (this.row == null) {
                            this.row = this.this$0.readRow(this.val$stream);
                        }
                        return this.row;
                    }

                    public void close() throws IOException {
                        this.val$stream.close();
                    }
                };
            }

            static /* synthetic */ Object[] access$000(2 x0) {
                return x0.BEFORE_START;
            }
        };
    }

    public static void streamStarTable(Header hdr, DataInput stream, TableSink sink) throws FitsException, IOException {
        BintableStarTable meta = new BintableStarTable(hdr){

            public RowSequence getRowSequence() {
                throw new UnsupportedOperationException("Metadata only");
            }
        };
        sink.acceptMetadata((StarTable)meta);
        long nrow = meta.getRowCount();
        long i = 0L;
        while (i < nrow) {
            Object[] row = meta.readRow(stream);
            sink.acceptRow(row);
            ++i;
        }
        sink.endRows();
        long datasize = nrow * (long)meta.getRowLength();
        int over = (int)(datasize % 2880L);
        if (over > 0) {
            IOUtils.skipBytes((DataInput)stream, (long)(2880 - over));
        }
    }

    BintableStarTable(Header hdr) throws FitsException {
        if (!hdr.getStringValue("XTENSION").equals("BINTABLE")) {
            throw new IllegalArgumentException("Not a binary table header");
        }
        this.ncol = hdr.getIntValue("TFIELDS");
        this.nrow = hdr.getIntValue("NAXIS2");
        this.colInfos = new ColumnInfo[this.ncol];
        this.colReaders = new ColumnReader[this.ncol];
        int icol = 0;
        while (icol < this.ncol) {
            ColumnReader reader;
            Matcher fmatch;
            String tcomm;
            String tform;
            double zero;
            double scale;
            String[] sdims;
            boolean hasBlank;
            long blank;
            String blankKey;
            String tdisp;
            String tunit;
            int jcol = icol + 1;
            ColumnInfo cinfo = new ColumnInfo("col" + jcol);
            List auxdata = cinfo.getAuxData();
            this.colInfos[icol] = cinfo;
            String ttype = hdr.getStringValue("TTYPE" + jcol);
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = hdr.getStringValue("TUNIT" + jcol)) != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tdisp = hdr.getStringValue("TDISP" + jcol)) != null) {
                auxdata.add(new DescribedValue(tdispInfo, (Object)tdisp));
            }
            if (hdr.containsKey(blankKey = "TNULL" + jcol)) {
                blank = hdr.getLongValue(blankKey);
                hasBlank = true;
                auxdata.add(new DescribedValue(tnullInfo, (Object)new Long(blank)));
            } else {
                cinfo.setNullable(false);
                blank = 0L;
                hasBlank = false;
            }
            int[] dims = null;
            String tdim = hdr.getStringValue("TDIM" + jcol);
            if (tdim != null && (tdim = tdim.trim()).charAt(0) == '(' && tdim.charAt(tdim.length() - 1) == ')' && (sdims = (tdim = tdim.substring(1, tdim.length() - 1).trim()).split(",")).length > 0) {
                try {
                    dims = new int[sdims.length];
                    int i = 0;
                    while (i < sdims.length) {
                        dims[i] = Integer.parseInt(sdims[i]);
                        ++i;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (hdr.containsKey("TSCAL" + jcol)) {
                scale = hdr.getDoubleValue("TSCAL" + jcol);
                auxdata.add(new DescribedValue(tscalInfo, (Object)new Double(scale)));
            } else {
                scale = 1.0;
            }
            if (hdr.containsKey("TZERO" + jcol)) {
                zero = hdr.getDoubleValue("TZERO" + jcol);
                auxdata.add(new DescribedValue(tzeroInfo, (Object)new Double(zero)));
            } else {
                zero = 0.0;
            }
            String tbcol = hdr.getStringValue("TBCOL" + jcol);
            if (tbcol != null) {
                int bcolval = Integer.parseInt(tbcol);
                auxdata.add(new DescribedValue(tbcolInfo, (Object)new Integer(bcolval)));
            }
            if ((tform = hdr.getStringValue("TFORM" + jcol)) != null) {
                auxdata.add(new DescribedValue(tformInfo, (Object)tform));
            }
            if ((tcomm = hdr.getStringValue("TCOMM" + jcol)) != null) {
                cinfo.setDescription(tcomm);
            }
            if ((fmatch = Pattern.compile("([0-9]*)([LXBIJKAEDCMP])(.*)").matcher(tform)).lookingAt()) {
                String scount = fmatch.group(1);
                int count = scount.length() == 0 ? 1 : Integer.parseInt(scount);
                char type = fmatch.group(2).charAt(0);
                String matchA = fmatch.group(3).trim();
                if (count == 1) {
                    dims = null;
                } else if (dims == null) {
                    dims = new int[]{count};
                } else {
                    int nel = 1;
                    int i = 0;
                    while (i < dims.length) {
                        nel *= dims[i];
                        ++i;
                    }
                    if (nel != count) {
                        dims = new int[]{count};
                    }
                }
                this.colReaders[icol] = reader = BintableStarTable.makeColumnReader(type, count, scale, zero, hasBlank, blank, dims);
                if (reader.getContentClass().equals(class$java$lang$String == null ? BintableStarTable.class$("java.lang.String") : class$java$lang$String)) {
                    cinfo.setNullable(true);
                }
            } else {
                throw new FitsException("Error parsing header line TFORM" + jcol + " = " + tform);
            }
            cinfo.setContentClass(reader.getContentClass());
            cinfo.setShape(reader.getShape());
            cinfo.setElementSize(reader.getElementSize());
            ++icol;
        }
        int leng = 0;
        this.colOffsets = new int[this.ncol];
        int icol2 = 0;
        while (icol2 < this.ncol) {
            this.colOffsets[icol2] = leng;
            leng += this.colReaders[icol2].getLength();
            ++icol2;
        }
        this.rowLength = leng;
        int nax1 = hdr.getIntValue("NAXIS1");
        if (this.rowLength != nax1) {
            throw new FitsException("Got wrong row length: " + nax1 + " != " + this.rowLength);
        }
    }

    public long getRowCount() {
        return this.nrow;
    }

    public int getColumnCount() {
        return this.ncol;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos[icol];
    }

    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    public Object readCell(DataInput stream, int icol) throws IOException {
        return this.colReaders[icol].readValue(stream);
    }

    public Object[] readRow(DataInput stream) throws IOException {
        Object[] row = new Object[this.ncol];
        this.readRow(stream, row);
        return row;
    }

    public void readRow(DataInput stream, Object[] row) throws IOException {
        int icol = 0;
        while (icol < this.ncol) {
            row[icol] = this.colReaders[icol].readValue(stream);
            ++icol;
        }
    }

    protected int getRowLength() {
        return this.rowLength;
    }

    protected int[] getColumnOffsets() {
        return this.colOffsets;
    }

    private static ColumnReader makeColumnReader(char type, final int count, final double scale, final double zero, final boolean hasBlank, final long blank, int[] dims) {
        boolean single = count == 1;
        boolean isScaled = scale != 1.0 || zero != 0.0;
        boolean isOffset = scale == 1.0 && zero != 0.0;
        boolean intOffset = isOffset && (double)Math.round(zero) == zero;
        switch (type) {
            case 'L': {
                ColumnReader reader = single ? new ColumnReader(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BintableStarTable.class$("java.lang.Boolean")) : class$java$lang$Boolean, 1){

                    Object readValue(DataInput stream) throws IOException {
                        return stream.readByte() == 84;
                    }
                } : new ColumnReader(array$Z == null ? (array$Z = BintableStarTable.class$("[Z")) : array$Z, dims, count){

                    Object readValue(DataInput stream) throws IOException {
                        boolean[] value = new boolean[count];
                        int i = 0;
                        while (i < count) {
                            value[i] = stream.readByte() == 84;
                            ++i;
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'X': {
                int nbyte = (count + 7) / 8;
                ColumnReader reader = new ColumnReader(array$Z == null ? (array$Z = BintableStarTable.class$("[Z")) : array$Z, dims, nbyte){

                    Object readValue(DataInput stream) throws IOException {
                        boolean[] value = new boolean[count];
                        int ibit = 0;
                        int b = 0;
                        int i = 0;
                        while (i < count) {
                            if (ibit == 0) {
                                ibit = 8;
                                b = stream.readByte();
                            }
                            value[i] = (b & 1) != 0;
                            b >>>= 1;
                            --ibit;
                            ++i;
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'B': {
                int mask = 255;
                boolean shortable = intOffset && zero >= -32768.0 && zero < 32511.0;
                final short sZero = (short)zero;
                ColumnReader reader = single ? (shortable ? new ColumnReader(class$java$lang$Short == null ? (class$java$lang$Short = BintableStarTable.class$("java.lang.Short")) : class$java$lang$Short, 1){

                    Object readValue(DataInput stream) throws IOException {
                        byte val = stream.readByte();
                        return hasBlank && val == (byte)blank ? null : new Short((short)((val & 0xFF) + sZero));
                    }
                } : (isScaled ? new ColumnReader(class$java$lang$Float == null ? (class$java$lang$Float = BintableStarTable.class$("java.lang.Float")) : class$java$lang$Float, 1){

                    Object readValue(DataInput stream) throws IOException {
                        byte val = stream.readByte();
                        return hasBlank && val == (byte)blank ? null : new Float((double)(val & 0xFF) * scale + zero);
                    }
                } : new ColumnReader(class$java$lang$Short == null ? (class$java$lang$Short = BintableStarTable.class$("java.lang.Short")) : class$java$lang$Short, 1){

                    Object readValue(DataInput stream) throws IOException {
                        byte val = stream.readByte();
                        return hasBlank && val == (byte)blank ? null : new Short((short)(val & 0xFF));
                    }
                })) : (shortable ? new ColumnReader(array$S == null ? (array$S = BintableStarTable.class$("[S")) : array$S, dims, 1 * count){

                    Object readValue(DataInput stream) throws IOException {
                        short[] value = new short[count];
                        int i = 0;
                        while (i < count) {
                            byte val = stream.readByte();
                            value[i] = (short)((val & 0xFF) + sZero);
                            ++i;
                        }
                        return value;
                    }
                } : (isScaled ? new ColumnReader(array$F == null ? (array$F = BintableStarTable.class$("[F")) : array$F, dims, 1 * count){

                    Object readValue(DataInput stream) throws IOException {
                        double[] value = new double[count];
                        int i = 0;
                        while (i < count) {
                            byte val = stream.readByte();
                            value[i] = hasBlank && val == (byte)blank ? Double.NaN : (double)((float)((double)(val & 0xFF) * scale + zero));
                            ++i;
                        }
                        return value;
                    }
                } : new ColumnReader(array$S == null ? (array$S = BintableStarTable.class$("[S")) : array$S, dims, 1 * count){

                    Object readValue(DataInput stream) throws IOException {
                        short[] value = new short[count];
                        int i = 0;
                        while (i < count) {
                            byte val = stream.readByte();
                            value[i] = (short)(val & 0xFF);
                            ++i;
                        }
                        return value;
                    }
                }));
                return reader;
            }
            case 'I': {
                ColumnReader reader = single ? (isScaled ? new ColumnReader(class$java$lang$Float == null ? (class$java$lang$Float = BintableStarTable.class$("java.lang.Float")) : class$java$lang$Float, 2){

                    Object readValue(DataInput stream) throws IOException {
                        short val = stream.readShort();
                        return hasBlank && val == (short)blank ? null : new Float((float)((double)val * scale + zero));
                    }
                } : new ColumnReader(class$java$lang$Short == null ? (class$java$lang$Short = BintableStarTable.class$("java.lang.Short")) : class$java$lang$Short, 2){

                    Object readValue(DataInput stream) throws IOException {
                        short val = stream.readShort();
                        return hasBlank && val == (short)blank ? null : new Short(val);
                    }
                }) : (isScaled ? new ColumnReader(array$F == null ? (array$F = BintableStarTable.class$("[F")) : array$F, dims, 2 * count){

                    Object readValue(DataInput stream) throws IOException {
                        double[] value = new double[count];
                        int i = 0;
                        while (i < count) {
                            short val = stream.readShort();
                            value[i] = hasBlank && val == (short)blank ? Double.NaN : (double)((float)((double)val * scale + zero));
                            ++i;
                        }
                        return value;
                    }
                } : new ColumnReader(array$S == null ? (array$S = BintableStarTable.class$("[S")) : array$S, dims, 2 * count){

                    Object readValue(DataInput stream) throws IOException {
                        short[] value = new short[count];
                        int i = 0;
                        while (i < count) {
                            short val;
                            value[i] = val = stream.readShort();
                            ++i;
                        }
                        return value;
                    }
                });
                return reader;
            }
            case 'J': {
                ColumnReader reader = single ? (isScaled ? new ColumnReader(class$java$lang$Double == null ? (class$java$lang$Double = BintableStarTable.class$("java.lang.Double")) : class$java$lang$Double, 4){

                    Object readValue(DataInput stream) throws IOException {
                        int val = stream.readInt();
                        return hasBlank && val == (int)blank ? null : new Double((double)val * scale + zero);
                    }
                } : new ColumnReader(class$java$lang$Integer == null ? (class$java$lang$Integer = BintableStarTable.class$("java.lang.Integer")) : class$java$lang$Integer, 4){

                    Object readValue(DataInput stream) throws IOException {
                        int val = stream.readInt();
                        return hasBlank && val == (int)blank ? null : new Integer(val);
                    }
                }) : (isScaled ? new ColumnReader(array$D == null ? (array$D = BintableStarTable.class$("[D")) : array$D, dims, 4 * count){

                    Object readValue(DataInput stream) throws IOException {
                        double[] value = new double[count];
                        int i = 0;
                        while (i < count) {
                            int val = stream.readInt();
                            value[i] = hasBlank && val == (int)blank ? Double.NaN : (double)val * scale + zero;
                            ++i;
                        }
                        return value;
                    }
                } : new ColumnReader(array$I == null ? (array$I = BintableStarTable.class$("[I")) : array$I, dims, 4 * count){

                    Object readValue(DataInput stream) throws IOException {
                        int[] value = new int[count];
                        int i = 0;
                        while (i < count) {
                            int val;
                            value[i] = val = stream.readInt();
                            ++i;
                        }
                        return value;
                    }
                });
                return reader;
            }
            case 'K': {
                ColumnReader reader = single ? (isScaled ? new ColumnReader(class$java$lang$Double == null ? (class$java$lang$Double = BintableStarTable.class$("java.lang.Double")) : class$java$lang$Double, 8){

                    Object readValue(DataInput stream) throws IOException {
                        long val = stream.readLong();
                        return hasBlank && val == blank ? null : new Double((double)val * scale + zero);
                    }
                } : new ColumnReader(class$java$lang$Long == null ? (class$java$lang$Long = BintableStarTable.class$("java.lang.Long")) : class$java$lang$Long, 8){

                    Object readValue(DataInput stream) throws IOException {
                        long val = stream.readLong();
                        return hasBlank && val == blank ? null : new Long(val);
                    }
                }) : (isScaled ? new ColumnReader(array$D == null ? (array$D = BintableStarTable.class$("[D")) : array$D, dims, 8 * count){

                    Object readValue(DataInput stream) throws IOException {
                        double[] value = new double[count];
                        int i = 0;
                        while (i < count) {
                            long val = stream.readLong();
                            value[i] = hasBlank && val == blank ? Double.NaN : (double)val * scale + zero;
                            ++i;
                        }
                        return value;
                    }
                } : new ColumnReader(array$J == null ? (array$J = BintableStarTable.class$("[J")) : array$J, dims, 8 * count){

                    Object readValue(DataInput stream) throws IOException {
                        long[] value = new long[count];
                        int i = 0;
                        while (i < count) {
                            long val;
                            value[i] = val = stream.readLong();
                            ++i;
                        }
                        return value;
                    }
                });
                return reader;
            }
            case 'A': {
                ColumnReader reader;
                if (single) {
                    reader = new ColumnReader(class$java$lang$Character == null ? (class$java$lang$Character = BintableStarTable.class$("java.lang.Character")) : class$java$lang$Character, 1){

                        Object readValue(DataInput stream) throws IOException {
                            char c = (char)(stream.readByte() & 0xFF);
                            return new Character(c);
                        }
                    };
                } else if (dims.length == 1) {
                    reader = new ColumnReader(class$java$lang$String == null ? (class$java$lang$String = BintableStarTable.class$("java.lang.String")) : class$java$lang$String, count){

                        Object readValue(DataInput stream) throws IOException {
                            return BintableStarTable.readString(stream, count);
                        }

                        int getElementSize() {
                            return count;
                        }
                    };
                } else {
                    int nel = 1;
                    int i = 1;
                    while (i < dims.length) {
                        nel *= dims[i];
                        ++i;
                    }
                    final int stringLength = dims[0];
                    final int nString = nel;
                    int[] shape = new int[dims.length - 1];
                    System.arraycopy(dims, 1, shape, 0, dims.length - 1);
                    reader = new ColumnReader(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BintableStarTable.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, shape, count){

                        Object readValue(DataInput stream) throws IOException {
                            String[] value = new String[nString];
                            int i = 0;
                            while (i < nString) {
                                value[i] = BintableStarTable.readString(stream, stringLength);
                                ++i;
                            }
                            return value;
                        }

                        int getElementSize() {
                            return stringLength;
                        }
                    };
                }
                return reader;
            }
            case 'E': {
                ColumnReader reader = single ? (isScaled ? new ColumnReader(class$java$lang$Float == null ? (class$java$lang$Float = BintableStarTable.class$("java.lang.Float")) : class$java$lang$Float, 4){

                    Object readValue(DataInput stream) throws IOException {
                        float val = stream.readFloat();
                        return new Float((double)val * scale + zero);
                    }
                } : new ColumnReader(class$java$lang$Float == null ? (class$java$lang$Float = BintableStarTable.class$("java.lang.Float")) : class$java$lang$Float, 4){

                    Object readValue(DataInput stream) throws IOException {
                        float val = stream.readFloat();
                        return new Float(val);
                    }
                }) : BintableStarTable.makeFloatsColumnReader(count, dims, scale, zero);
                return reader;
            }
            case 'D': {
                ColumnReader reader = single ? (isScaled ? new ColumnReader(class$java$lang$Double == null ? (class$java$lang$Double = BintableStarTable.class$("java.lang.Double")) : class$java$lang$Double, 8){

                    Object readValue(DataInput stream) throws IOException {
                        double val = stream.readDouble();
                        return new Double(val);
                    }
                } : new ColumnReader(class$java$lang$Double == null ? (class$java$lang$Double = BintableStarTable.class$("java.lang.Double")) : class$java$lang$Double, 8){

                    Object readValue(DataInput stream) throws IOException {
                        double val = stream.readDouble();
                        return new Double(val * scale + zero);
                    }
                }) : BintableStarTable.makeDoublesColumnReader(count, dims, scale, zero);
                return reader;
            }
            case 'C': {
                return BintableStarTable.makeFloatsColumnReader(count * 2, BintableStarTable.complexShape(dims), scale, zero);
            }
            case 'M': {
                return BintableStarTable.makeDoublesColumnReader(count * 2, BintableStarTable.complexShape(dims), scale, zero);
            }
            case 'P': {
                return new ColumnReader(class$java$lang$String == null ? (class$java$lang$String = BintableStarTable.class$("java.lang.String")) : class$java$lang$String, count * 8){

                    Object readValue(DataInput stream) throws IOException {
                        int i = 0;
                        while (i < count * 8) {
                            stream.readByte();
                            ++i;
                        }
                        return "(Variable-length arrays not supported)";
                    }
                };
            }
        }
        throw new AssertionError((Object)("Unknown TFORM type " + type));
    }

    private static ColumnReader makeFloatsColumnReader(final int count, int[] shape, final double scale, final double zero) {
        boolean isScaled;
        boolean bl = isScaled = scale != 1.0 || zero != 0.0;
        if (isScaled) {
            return new ColumnReader(array$F == null ? (array$F = BintableStarTable.class$("[F")) : array$F, shape, 4 * count){

                Object readValue(DataInput stream) throws IOException {
                    float[] value = new float[count];
                    int i = 0;
                    while (i < count) {
                        float val = stream.readFloat();
                        value[i] = (float)((double)val * scale + zero);
                        ++i;
                    }
                    return value;
                }
            };
        }
        return new ColumnReader(array$F == null ? (array$F = BintableStarTable.class$("[F")) : array$F, shape, 4 * count){

            Object readValue(DataInput stream) throws IOException {
                float[] value = new float[count];
                int i = 0;
                while (i < count) {
                    value[i] = stream.readFloat();
                    ++i;
                }
                return value;
            }
        };
    }

    private static ColumnReader makeDoublesColumnReader(final int count, int[] shape, final double scale, final double zero) {
        boolean isScaled;
        boolean bl = isScaled = scale != 1.0 || zero != 0.0;
        if (isScaled) {
            return new ColumnReader(array$D == null ? (array$D = BintableStarTable.class$("[D")) : array$D, shape, 8 * count){

                Object readValue(DataInput stream) throws IOException {
                    double[] value = new double[count];
                    int i = 0;
                    while (i < count) {
                        double val = stream.readDouble();
                        value[i] = val * scale + zero;
                        ++i;
                    }
                    return value;
                }
            };
        }
        return new ColumnReader(array$D == null ? (array$D = BintableStarTable.class$("[D")) : array$D, shape, 8 * count){

            Object readValue(DataInput stream) throws IOException {
                double[] value = new double[count];
                int i = 0;
                while (i < count) {
                    value[i] = stream.readDouble();
                    ++i;
                }
                return value;
            }
        };
    }

    private static int[] complexShape(int[] dims) {
        if (dims == null) {
            return new int[]{2};
        }
        int[] shape = new int[dims.length + 1];
        shape[0] = 2;
        System.arraycopy(dims, 0, shape, 1, dims.length);
        return shape;
    }

    private static String readString(DataInput stream, int count) throws IOException {
        char[] letters = new char[count];
        int last = -1;
        boolean end = false;
        int i = 0;
        while (i < count) {
            char letter = (char)(stream.readByte() & 0xFF);
            if (letter == '\u0000') {
                end = true;
            }
            if (!end) {
                letters[i] = letter;
                if (letter != ' ') {
                    last = i;
                }
            }
            ++i;
        }
        int leng = last + 1;
        return leng == 0 ? null : new String(letters, 0, leng);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class ColumnReader {
        private final Class clazz;
        private final int[] shape;
        private final int length;

        ColumnReader(Class clazz, int[] shape, int length) {
            this.clazz = clazz;
            this.length = length;
            this.shape = shape;
        }

        ColumnReader(Class clazz, int length) {
            this(clazz, null, length);
        }

        abstract Object readValue(DataInput var1) throws IOException;

        Class getContentClass() {
            return this.clazz;
        }

        int[] getShape() {
            return this.shape;
        }

        int getElementSize() {
            return -1;
        }

        int getLength() {
            return this.length;
        }
    }
}

