/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;

public class FitsTableWriter
extends StreamStarTableWriter {
    public String getFormatName() {
        return "fits-basic";
    }

    public boolean looksLikeFile(String location) {
        String exten;
        int dotPos = location.lastIndexOf(46);
        return dotPos > 0 && ((exten = location.substring(dotPos + 1).toLowerCase()).startsWith("fit") || exten.equals("fts"));
    }

    public void writeStarTable(StarTable startab, OutputStream out) throws IOException {
        DataOutputStream strm = new DataOutputStream(out);
        FitsTableSerializer serializer = new FitsTableSerializer(startab);
        this.writePrimary(startab, strm);
        serializer.writeHeader(strm);
        serializer.writeData(strm);
        strm.flush();
    }

    protected void writePrimary(StarTable startab, DataOutputStream strm) throws IOException {
        FitsConstants.writeEmptyPrimary(strm);
    }
}

