/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;

public class MappedFile
implements ArrayDataInput,
ArrayDataOutput,
RandomAccess {
    private ByteBuffer niobuf;
    private int size;
    static /* synthetic */ Class class$java$lang$Object;

    public MappedFile(ByteBuffer buf) {
        this.niobuf = buf;
    }

    public MappedFile(String filename) throws IOException {
        this(filename, "r");
    }

    public MappedFile(String filename, String mode) throws IOException {
        this(MappedFile.getExistingFileBuffer(filename, mode));
    }

    public MappedFile(String filename, String mode, long start, int size) throws IOException {
        this(MappedFile.getNioBuffer(filename, mode, start, size));
    }

    public void seek(long offsetFromStart) throws IOException {
        if (offsetFromStart > (long)this.length()) {
            throw new IOException("Attempt to seek beyond end of file");
        }
        this.niobuf.position((int)offsetFromStart);
    }

    public long skip(long offset) {
        return this.skipBytes((int)Math.min(offset, Integer.MAX_VALUE));
    }

    public long getFilePointer() {
        return this.niobuf.position();
    }

    public int skipBytes(int toSkip) {
        int nskip = Math.max(toSkip, 0);
        nskip = Math.min(toSkip, this.niobuf.remaining());
        this.niobuf.position(this.niobuf.position() + nskip);
        return nskip;
    }

    public int length() {
        return this.niobuf.capacity();
    }

    public void close() {
    }

    public void flush() {
    }

    public boolean readBoolean() throws EOFException {
        try {
            return this.niobuf.get() == 1;
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    public byte readByte() throws EOFException {
        try {
            return this.niobuf.get();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    public short readShort() throws EOFException {
        try {
            return this.niobuf.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    public char readChar() throws EOFException {
        try {
            return this.niobuf.getChar();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    public int readInt() throws EOFException {
        try {
            return this.niobuf.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    public long readLong() throws EOFException {
        try {
            return this.niobuf.getLong();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    public float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readUnsignedByte() throws EOFException {
        return this.readByte() | 0xFF;
    }

    public int readUnsignedShort() throws EOFException {
        return this.readShort() | 0xFFFF;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFully(byte[] buf, int start, int len) throws EOFException {
        int nread = this.numAvailable(len, 1);
        this.niobuf.get(buf, start, nread);
        if (nread < len) {
            throw new EOFException();
        }
    }

    public int read(byte[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 1);
        if (nread == 0) {
            throw new EOFException();
        }
        this.niobuf.get(buf, start, nread);
        return nread;
    }

    public int read(boolean[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 1);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[i] = this.readBoolean();
            ++i;
        }
        return nread;
    }

    public int read(short[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 2);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[start++] = this.readShort();
            ++i;
        }
        return nread;
    }

    public int read(char[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 2);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[start++] = this.readChar();
            ++i;
        }
        return nread;
    }

    public int read(int[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 4);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[start++] = this.readInt();
            ++i;
        }
        return nread;
    }

    public int read(long[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 8);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[start++] = this.readLong();
            ++i;
        }
        return nread;
    }

    public int read(float[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 4);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[start++] = this.readFloat();
            ++i;
        }
        return nread;
    }

    public int read(double[] buf, int start, int length) throws EOFException {
        int nread = this.numAvailable(length, 8);
        if (nread == 0) {
            throw new EOFException();
        }
        int i = 0;
        while (i < nread) {
            buf[start++] = this.readDouble();
            ++i;
        }
        return nread;
    }

    public void readFully(byte[] buf) throws EOFException {
        this.readFully(buf, 0, buf.length);
    }

    public int read(byte[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(boolean[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(short[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(char[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(int[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(long[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(float[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int read(double[] buf) throws EOFException {
        return this.read(buf, 0, buf.length);
    }

    public int readArray(Object o) throws EOFException {
        int nread = 0;
        return this.primitiveArrayRecurse(o, nread);
    }

    private int primitiveArrayRecurse(Object o, int nread) throws EOFException {
        if (o == null) {
            return nread;
        }
        Class<?> elclass = o.getClass().getComponentType();
        if (elclass == null) {
            throw new IllegalArgumentException("Invalid object: " + o + " is not an array");
        }
        int nel = Array.getLength(o);
        if (elclass.isAssignableFrom(class$java$lang$Object == null ? (class$java$lang$Object = MappedFile.class$("java.lang.Object")) : class$java$lang$Object)) {
            int i = 0;
            while (i < nel) {
                this.primitiveArrayRecurse(((Object[])o)[i], nread);
                ++i;
            }
        } else if (elclass == Byte.TYPE) {
            nread += this.read((byte[])o, 0, nel);
        } else if (elclass == Boolean.TYPE) {
            nread += this.read((boolean[])o, 0, nel);
        } else if (elclass == Short.TYPE) {
            nread += this.read((short[])o, 0, nel);
        } else if (elclass == Character.TYPE) {
            nread += this.read((char[])o, 0, nel);
        } else if (elclass == Integer.TYPE) {
            nread += this.read((int[])o, 0, nel);
        } else if (elclass == Long.TYPE) {
            nread += this.read((long[])o, 0, nel);
        } else if (elclass == Float.TYPE) {
            nread += this.read((float[])o, 0, nel);
        } else if (elclass == Double.TYPE) {
            nread += this.read((double[])o, 0, nel);
        } else {
            throw new IllegalArgumentException("Invalid object: " + o + " is not a primitive array");
        }
        return nread;
    }

    public void writeBoolean(boolean val) throws IOException {
        try {
            this.niobuf.put(val ? (byte)1 : 0);
        }
        catch (BufferOverflowException e) {
            throw this.writeOverflowException();
        }
    }

    public void writeByte(int val) throws IOException {
        try {
            this.niobuf.put((byte)val);
        }
        catch (BufferOverflowException e) {
            throw this.writeOverflowException();
        }
    }

    public void writeShort(int val) throws IOException {
        try {
            this.niobuf.putShort((short)val);
        }
        catch (BufferOverflowException e) {
            throw this.writeOverflowException();
        }
    }

    public void writeChar(int val) throws IOException {
        try {
            this.niobuf.putChar((char)val);
        }
        catch (BufferOverflowException e) {
            throw this.writeOverflowException();
        }
    }

    public void writeInt(int val) throws IOException {
        try {
            this.niobuf.putInt(val);
        }
        catch (BufferOverflowException e) {
            throw this.writeOverflowException();
        }
    }

    public void writeLong(long val) throws IOException {
        try {
            this.niobuf.putLong(val);
        }
        catch (BufferOverflowException e) {
            throw this.writeOverflowException();
        }
    }

    public void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    public void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    public void write(byte[] buf, int start, int length) throws IOException {
        int nwrite = this.numAvailable(length, 1);
        this.niobuf.put(buf, start, nwrite);
        if (nwrite < length) {
            throw this.writeOverflowException();
        }
    }

    public void write(boolean[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeBoolean(buf[start++]);
        }
    }

    public void write(short[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeShort(buf[start++]);
        }
    }

    public void write(char[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeChar(buf[start++]);
        }
    }

    public void write(int[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeInt(buf[start++]);
        }
    }

    public void write(long[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeLong(buf[start++]);
        }
    }

    public void write(float[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeFloat(buf[start++]);
        }
    }

    public void write(double[] buf, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeDouble(buf[start++]);
        }
    }

    public void write(String[] strings, int start, int length) throws IOException {
        while (length-- > 0) {
            this.writeBytes(strings[start++]);
        }
    }

    public void write(int val) throws IOException {
        this.writeByte(val);
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.length());
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    public void writeUTF(String str) throws IOException {
        MappedFile.writeUTF(str, this);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(boolean[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(short[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(int[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(long[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(float[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(double[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String[] strings) throws IOException {
        this.write(strings, 0, strings.length);
    }

    public void writeArray(Object o) throws IOException {
        Class<?> elclass;
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            this.write(((String)o).getBytes());
        }
        if ((elclass = o.getClass().getComponentType()) == null) {
            throw new IllegalArgumentException("Invalid object: " + o + " is not an array");
        }
        int nel = Array.getLength(o);
        if (elclass.isAssignableFrom(class$java$lang$Object == null ? (class$java$lang$Object = MappedFile.class$("java.lang.Object")) : class$java$lang$Object)) {
            int i = 0;
            while (i < nel) {
                this.writeArray(((Object[])o)[i]);
                ++i;
            }
        } else if (elclass == Byte.TYPE) {
            this.write((byte[])o, 0, nel);
        } else if (elclass == Boolean.TYPE) {
            this.write((boolean[])o, 0, nel);
        } else if (elclass == Short.TYPE) {
            this.write((short[])o, 0, nel);
        } else if (elclass == Character.TYPE) {
            this.write((char[])o, 0, nel);
        } else if (elclass == Integer.TYPE) {
            this.write((int[])o, 0, nel);
        } else if (elclass == Long.TYPE) {
            this.write((long[])o, 0, nel);
        } else if (elclass == Float.TYPE) {
            this.write((float[])o, 0, nel);
        } else if (elclass == Double.TYPE) {
            this.write((double[])o, 0, nel);
        } else {
            throw new IllegalArgumentException("Invalid object: " + o + " is not a primitive array");
        }
    }

    private int numAvailable(int required, int size) {
        int nav = Math.min(required, this.niobuf.remaining() / size);
        return nav;
    }

    private static ByteBuffer getNioBuffer(String filename, String mode, long start, int size) throws IOException {
        FileChannel.MapMode mapmode;
        RandomAccessFile raf = new RandomAccessFile(filename, mode);
        FileChannel channel = raf.getChannel();
        if (mode.equals("r")) {
            mapmode = FileChannel.MapMode.READ_ONLY;
        } else if (mode.equals("rw")) {
            mapmode = FileChannel.MapMode.READ_WRITE;
        } else {
            throw new IllegalArgumentException("Invalid mode string \"" + mode + "\" - must be \"r\" or \"rw\"");
        }
        MappedByteBuffer buf = channel.map(mapmode, start, size);
        channel.close();
        return buf;
    }

    private static ByteBuffer getExistingFileBuffer(String filename, String mode) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException("No such file " + filename);
        }
        long size = file.length();
        if (size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("File too long for MappedFile (" + size + " > " + Integer.MAX_VALUE + ">");
        }
        return MappedFile.getNioBuffer(filename, mode, 0L, (int)size);
    }

    private IOException writeOverflowException() {
        return new IOException("Attempted write beyond buffer limit");
    }

    private static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        out.write(bytearr);
        return utflen + 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

