/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.lang.reflect.Array;
import java.util.Iterator;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.Type;

public class BufferIterator
implements Iterator {
    private ChunkStepper chunkIt;
    private Object buffer;
    private Type type;
    private long base = -1L;

    public BufferIterator(long length, Type type, int chunkSize) {
        this.chunkIt = new ChunkStepper(length, chunkSize);
        this.type = type;
        if (type == null) {
            throw new NullPointerException();
        }
    }

    public BufferIterator(long length) {
        this.chunkIt = new ChunkStepper(length);
        this.type = this.type;
        if (this.type == null) {
            throw new NullPointerException();
        }
    }

    public Object next() {
        int size = this.chunkIt.getSize();
        this.base = this.chunkIt.getBase();
        this.chunkIt.next();
        if (this.buffer == null || Array.getLength(this.buffer) != size) {
            this.buffer = this.type.newArray(size);
        }
        return this.buffer;
    }

    public boolean hasNext() {
        return this.chunkIt.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long getBase() {
        if (this.base >= 0L) {
            return this.base;
        }
        throw new IllegalStateException("getBase() called before next()");
    }
}

