/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.Combiner;
import uk.ac.starlink.array.Converter;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.TypeConverter;

public class CombineArrayImpl
implements ArrayImpl {
    private Combiner combi;
    private OrderedNDShape oshape;
    private Type type;
    private Type internalType = Type.DOUBLE;
    private BadHandler internalHandler = this.internalType.defaultBadHandler();
    private NDArray nda1;
    private NDArray nda2;
    private NDArray rnda1;
    private NDArray rnda2;
    private Requirements req;
    private BadHandler bh1;
    private BadHandler bh2;
    private BadHandler bh;
    private Converter tconv1;
    private Converter tconv2;
    private Converter tconv;
    private boolean isRandom;
    private boolean multipleAccess;
    private static final int BUFSIZE = ChunkStepper.defaultChunkSize;

    public CombineArrayImpl(NDArray nda1, NDArray nda2, Combiner combi, NDShape shape, Type type, BadHandler bh) {
        this.combi = combi;
        this.oshape = new OrderedNDShape(shape, nda1.getShape().getOrder());
        this.type = type;
        this.nda1 = nda1;
        this.nda2 = nda2;
        this.isRandom = nda1.isRandom() && nda2.isRandom();
        this.multipleAccess = nda1.isRandom() && nda2.multipleAccess();
        this.req = new Requirements(AccessMode.READ).setType(this.internalType).setWindow(shape);
        this.bh = bh != null ? bh : BadHandler.getHandler(type, type.defaultBadValue());
        this.tconv = new TypeConverter(this.internalType, this.internalHandler, type, this.bh);
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.bh.getBadValue();
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public boolean multipleAccess() {
        return this.multipleAccess;
    }

    public void open() throws IOException {
        this.rnda1 = NDArrays.toRequiredArray(this.nda1, this.req);
        this.rnda2 = NDArrays.toRequiredArray(this.nda2, this.req);
    }

    public boolean canMap() {
        return false;
    }

    public Object getMapped() {
        return null;
    }

    public AccessImpl getAccess() throws IOException {
        return new AccessImpl(){
            private ArrayAccess acc1;
            private ArrayAccess acc2;
            private Object standardBuffer1;
            private Object standardBuffer2;
            private Object standardBuffer3;
            {
                this.acc1 = CombineArrayImpl.this.rnda1.getAccess();
                this.acc2 = CombineArrayImpl.this.rnda2.getAccess();
                this.standardBuffer1 = CombineArrayImpl.this.internalType.newArray(BUFSIZE);
                this.standardBuffer2 = CombineArrayImpl.this.internalType.newArray(BUFSIZE);
                this.standardBuffer3 = CombineArrayImpl.this.internalType.newArray(BUFSIZE);
            }

            public void setOffset(long off) throws IOException {
                this.acc1.setOffset(off);
                this.acc2.setOffset(off);
            }

            public void read(Object buffer, int start, int size) throws IOException {
                double[] buf1 = (double[])this.getBuffer1(size);
                double[] buf2 = (double[])this.getBuffer2(size);
                double[] buf3 = (double[])this.getBuffer3(size);
                this.acc1.read(buf1, 0, size);
                this.acc2.read(buf2, 0, size);
                int i = 0;
                while (i < size) {
                    buf3[i] = CombineArrayImpl.this.combi.combination(buf1[i], buf2[i]);
                    ++i;
                }
                CombineArrayImpl.this.tconv.convert12(buf3, 0, buffer, start, size);
            }

            public void write(Object buffer, int start, int size) {
                throw new AssertionError();
            }

            public void close() throws IOException {
                this.acc1.close();
                this.acc2.close();
            }

            private Object getBuffer1(int size) {
                return size <= BUFSIZE ? this.standardBuffer1 : CombineArrayImpl.this.internalType.newArray(size);
            }

            private Object getBuffer2(int size) {
                return size <= BUFSIZE ? this.standardBuffer2 : CombineArrayImpl.this.internalType.newArray(size);
            }

            private Object getBuffer3(int size) {
                return size <= BUFSIZE ? this.standardBuffer3 : CombineArrayImpl.this.internalType.newArray(size);
            }
        };
    }

    public void close() throws IOException {
        if (this.rnda1 != null) {
            this.rnda1.close();
        }
        if (this.rnda1 != null) {
            this.rnda2.close();
        }
    }
}

