/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.ArrayDescription;
import uk.ac.starlink.array.DefaultArrayDescription;
import uk.ac.starlink.array.IntersectionRowIterator;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;

public class DefaultArrayAccess
extends DefaultArrayDescription
implements ArrayAccess {
    long offset = 0L;
    private boolean closed = false;
    private AccessImpl impl;
    private Object mappedArray;

    public DefaultArrayAccess(ArrayDescription adesc, AccessImpl impl, Object mappedArray) {
        super(adesc);
        this.impl = impl;
        this.mappedArray = mappedArray;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long off) throws IOException {
        this.checkOpen();
        if (off >= 0L && off < this.arrayNpix) {
            if (!this.arrayIsRandom && off < this.offset) {
                throw new UnsupportedOperationException("Random access attempted on non-random array");
            }
        } else {
            throw new IndexOutOfBoundsException("Index " + off + " is out of range 0 .. " + this.arrayNpix);
        }
        this.impl.setOffset(off);
        this.offset = off;
    }

    public long[] getPosition() {
        return this.arrayShape.offsetToPosition(this.offset);
    }

    public void setPosition(long[] pos) throws IOException {
        this.setOffset(this.arrayShape.positionToOffset(pos));
    }

    public void read(Object buffer, int start, int size) throws IOException {
        this.checkOpen();
        this.checkReadable();
        this.arrayType.checkArray(buffer, start + size);
        if ((long)size > this.arrayNpix - this.offset) {
            throw new IllegalStateException("Not enough pixels remaining to read " + (this.arrayNpix - this.offset) + " < " + size);
        }
        try {
            this.impl.read(buffer, start, size);
            this.offset += (long)size;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void readTile(Object buffer, NDShape tile) throws IOException {
        this.checkOpen();
        this.checkReadable();
        long tileNpix = tile.getNumPixels();
        if (tileNpix > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile " + tile + " too big" + " (" + tileNpix + " > " + Integer.MAX_VALUE + ")");
        }
        this.arrayType.checkArray(buffer, (int)tileNpix);
        IntersectionRowIterator rowIt = new IntersectionRowIterator(this.arrayShape, tile, this.arrayOrder);
        OrderedNDShape inter = rowIt.getIntersection();
        if (inter == null) {
            this.arrayHandler.putBad(buffer, 0, (int)tileNpix);
            return;
        }
        if (!this.arrayIsRandom && rowIt.getOffsetA() < this.offset) {
            throw new UnsupportedOperationException("Random access attempted on non-random array");
        }
        boolean allWithin = tile.equals(inter);
        if (!allWithin) {
            this.arrayHandler.putBad(buffer, 0, (int)tileNpix);
        }
        int rowLength = (int)rowIt.getRowLength();
        try {
            while (rowIt.hasNext()) {
                long off = rowIt.getOffsetA();
                this.impl.setOffset(off);
                this.impl.read(buffer, (int)rowIt.getOffsetB(), rowLength);
                this.offset = off + (long)rowLength;
                rowIt.next();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void write(Object buffer, int start, int size) throws IOException {
        this.checkOpen();
        this.checkWritable();
        this.arrayType.checkArray(buffer, start + size);
        if ((long)size > this.arrayNpix - this.offset) {
            throw new IllegalStateException("Not enough pixels remaining to write " + (this.arrayNpix - this.offset) + " < " + size);
        }
        try {
            this.impl.write(buffer, start, size);
            this.offset += (long)size;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void writeTile(Object buffer, NDShape tile) throws IOException {
        this.checkOpen();
        long tileNpix = tile.getNumPixels();
        if (tileNpix > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile " + tile + " too big" + " (" + tileNpix + " > " + Integer.MAX_VALUE + ")");
        }
        this.arrayType.checkArray(buffer, (int)tileNpix);
        IntersectionRowIterator rowIt = new IntersectionRowIterator(this.arrayShape, tile, this.arrayOrder);
        OrderedNDShape inter = rowIt.getIntersection();
        if (inter == null) {
            return;
        }
        if (this.arrayIsRandom && rowIt.getOffsetA() < this.offset) {
            throw new UnsupportedOperationException("Random access attempted on non-random array");
        }
        int rowLength = (int)rowIt.getRowLength();
        try {
            while (rowIt.hasNext()) {
                long off = rowIt.getOffsetA();
                this.impl.setOffset(off);
                this.impl.write(buffer, (int)rowIt.getOffsetB(), rowLength);
                this.offset = off + (long)rowLength;
                rowIt.next();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public boolean isMapped() {
        return this.mappedArray != null;
    }

    public Object getMapped() {
        this.checkOpen();
        if (this.mappedArray == null) {
            throw new UnsupportedOperationException("Accessor is not mappable");
        }
        return this.mappedArray;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.impl.close();
            this.doClose();
        }
    }

    protected void doClose() {
        this.closed = true;
        this.impl = null;
        this.mappedArray = null;
        this.offset = -1L;
    }

    protected void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Accessor has been closed");
        }
    }

    private void checkReadable() {
        if (!this.arrayIsReadable) {
            throw new UnsupportedOperationException("Accessor is not readable");
        }
    }

    private void checkWritable() {
        if (!this.arrayIsWritable) {
            throw new UnsupportedOperationException("Accessor is not writable");
        }
    }

    public String toString() {
        return super.toString() + " impl={ " + this.impl.toString() + " }";
    }
}

