/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import uk.ac.starlink.array.ArrayDescription;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;

public class DefaultArrayDescription
implements ArrayDescription {
    protected final OrderedNDShape arrayShape;
    protected final Type arrayType;
    protected final BadHandler arrayHandler;
    protected final boolean arrayIsRandom;
    protected final boolean arrayIsReadable;
    protected final boolean arrayIsWritable;
    protected final Order arrayOrder;
    protected final long arrayNpix;
    protected final long arrayNdim;
    protected final long[] arrayDims;
    protected final long[] arrayOrigin;

    public DefaultArrayDescription(OrderedNDShape oshape, Type type, BadHandler badHandler, boolean isRandom, boolean isReadable, boolean isWritable) {
        this.arrayShape = oshape;
        this.arrayType = type;
        this.arrayHandler = badHandler;
        this.arrayIsRandom = isRandom;
        this.arrayIsReadable = isReadable;
        this.arrayIsWritable = isWritable;
        this.arrayOrder = oshape.getOrder();
        this.arrayNpix = oshape.getNumPixels();
        this.arrayNdim = oshape.getNumDims();
        this.arrayDims = oshape.getDims();
        this.arrayOrigin = oshape.getOrigin();
    }

    public DefaultArrayDescription(ArrayDescription descrip) {
        this(descrip.getShape(), descrip.getType(), descrip.getBadHandler(), descrip.isRandom(), descrip.isReadable(), descrip.isWritable());
    }

    public DefaultArrayDescription(ArrayDescription desc, Requirements req) {
        this(new OrderedNDShape(req.getWindow() != null ? req.getWindow() : desc.getShape(), req.getOrder() != null ? req.getOrder() : desc.getShape().getOrder()), req.getType() != null ? req.getType() : desc.getType(), req.getBadHandler() != null ? req.getBadHandler() : desc.getBadHandler(), req.getRandom() && desc.isRandom(), desc.isReadable(), desc.isWritable());
    }

    public OrderedNDShape getShape() {
        return this.arrayShape;
    }

    public Type getType() {
        return this.arrayType;
    }

    public BadHandler getBadHandler() {
        return this.arrayHandler;
    }

    public boolean isRandom() {
        return this.arrayIsRandom;
    }

    public boolean isReadable() {
        return this.arrayIsReadable;
    }

    public boolean isWritable() {
        return this.arrayIsWritable;
    }
}

