/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.OffsetMapper;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.WrapperArrayImpl;

public class PixelMapArrayImpl
extends WrapperArrayImpl {
    private final NDArray nda;
    private final OrderedNDShape oshape;
    private final OffsetMapper mapper;
    private final boolean allWithin;

    public PixelMapArrayImpl(NDArray nda, OrderedNDShape oshape, OffsetMapper mapper) {
        super(nda);
        this.nda = nda;
        this.oshape = oshape;
        this.mapper = mapper;
        if (!nda.isRandom()) {
            throw new UnsupportedOperationException("Base NDArray " + nda + " does not support random access");
        }
        long[] range = new long[]{0L, oshape.getNumPixels() - 1L};
        long[] baseRange = mapper.mapRange(range);
        this.allWithin = baseRange != null && baseRange[0] >= 0L && baseRange[1] <= nda.getShape().getNumPixels() - 1L;
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public AccessImpl getAccess() throws IOException {
        if (this.allWithin) {
            return new AccessImpl(){
                private ArrayAccess baseAcc;
                private long offset;
                {
                    this.baseAcc = PixelMapArrayImpl.this.nda.getAccess();
                    this.offset = 0L;
                }

                public void setOffset(long off) throws IOException {
                    this.offset = off;
                }

                public void read(Object buffer, int start, int size) throws IOException {
                    while (size-- > 0) {
                        this.baseAcc.setOffset(PixelMapArrayImpl.this.mapper.mapOffset(this.offset++));
                        this.baseAcc.read(buffer, start++, 1);
                    }
                }

                public void write(Object buffer, int start, int size) throws IOException {
                    while (size-- > 0) {
                        this.baseAcc.setOffset(PixelMapArrayImpl.this.mapper.mapOffset(this.offset++));
                        this.baseAcc.write(buffer, start++, 1);
                    }
                }

                public void close() throws IOException {
                    this.baseAcc.close();
                }
            };
        }
        return new AccessImpl(){
            private ArrayAccess baseAcc;
            private BadHandler baseHandler;
            private long baseNpix;
            private long offset;
            {
                this.baseAcc = PixelMapArrayImpl.this.nda.getAccess();
                this.baseHandler = PixelMapArrayImpl.this.nda.getBadHandler();
                this.baseNpix = PixelMapArrayImpl.this.nda.getShape().getNumPixels();
                this.offset = 0L;
            }

            public void setOffset(long off) throws IOException {
                this.offset = off;
            }

            public void read(Object buffer, int start, int size) throws IOException {
                while (size-- > 0) {
                    long baseOff = PixelMapArrayImpl.this.mapper.mapOffset(this.offset++);
                    if (baseOff >= 0L && baseOff < this.baseNpix) {
                        this.baseAcc.setOffset(baseOff);
                        this.baseAcc.read(buffer, start, 1);
                    } else {
                        this.baseHandler.putBad(buffer, start);
                    }
                    ++start;
                }
            }

            public void write(Object buffer, int start, int size) throws IOException {
                while (size-- > 0) {
                    long baseOff = PixelMapArrayImpl.this.mapper.mapOffset(this.offset++);
                    if (baseOff >= 0L && baseOff < this.baseNpix) {
                        this.baseAcc.setOffset(baseOff);
                        this.baseAcc.write(buffer, start, 1);
                    }
                    ++start;
                }
            }

            public void close() throws IOException {
                this.baseAcc.close();
            }
        };
    }
}

