/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OffsetMapper;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;

public class ReorderingMapper
implements OffsetMapper {
    private final OrderedNDShape oshape1;
    private final OrderedNDShape oshape2;
    private final long npix;

    public ReorderingMapper(NDShape shape, Order order1, Order order2) {
        this.oshape1 = new OrderedNDShape(shape, order1);
        this.oshape2 = new OrderedNDShape(shape, order2);
        this.npix = shape.getNumPixels();
    }

    public long mapOffset(long off1) {
        return this.oshape2.positionToOffset(this.oshape1.offsetToPosition(off1));
    }

    public long[] mapRange(long[] range1) {
        if (range1[0] < 0L || range1[1] >= this.npix) {
            throw new IndexOutOfBoundsException("Values outside of 0.." + (this.npix - 1L) + " not supported");
        }
        return new long[]{0L, this.npix - 1L};
    }
}

