/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.starlink.array.BadHandler;

public class Type {
    private static List allTypes;
    public static final Type BYTE;
    public static final Type SHORT;
    public static final Type INT;
    public static final Type FLOAT;
    public static final Type DOUBLE;
    private final String name;
    private final Class clazz;
    private final int nBytes;
    private final Number defaultBadValue;
    private final boolean isFloating;
    private final double minval;
    private final double maxval;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$array$Type;

    private Type(String name) {
        this.name = name;
        if (name.equals("byte")) {
            this.clazz = Byte.TYPE;
            this.nBytes = 1;
            this.defaultBadValue = new Byte(-128);
            this.isFloating = false;
            this.minval = -128.0;
            this.maxval = 127.0;
        } else if (name.equals("short")) {
            this.clazz = Short.TYPE;
            this.nBytes = 2;
            this.defaultBadValue = new Short(Short.MIN_VALUE);
            this.isFloating = false;
            this.minval = -32768.0;
            this.maxval = 32767.0;
        } else if (name.equals("int")) {
            this.clazz = Integer.TYPE;
            this.nBytes = 4;
            this.defaultBadValue = new Integer(Integer.MIN_VALUE);
            this.isFloating = false;
            this.minval = -2.147483648E9;
            this.maxval = 2.147483647E9;
        } else if (name.equals("float")) {
            this.clazz = Float.TYPE;
            this.nBytes = 4;
            this.defaultBadValue = new Float(Float.NaN);
            this.isFloating = true;
            this.minval = -3.4028234663852886E38;
            this.maxval = 3.4028234663852886E38;
        } else if (name.equals("double")) {
            this.clazz = Double.TYPE;
            this.nBytes = 8;
            this.defaultBadValue = new Double(Double.NaN);
            this.isFloating = true;
            this.minval = -1.7976931348623157E308;
            this.maxval = Double.MAX_VALUE;
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new Error();
        }
        allTypes.add(this);
    }

    public String toString() {
        return this.name;
    }

    public int getNumBytes() {
        return this.nBytes;
    }

    public Class javaClass() {
        return this.clazz;
    }

    public Number defaultBadValue() {
        return this.defaultBadValue;
    }

    public BadHandler defaultBadHandler() {
        return this == BYTE ? BadHandler.getHandler(this, null) : BadHandler.getHandler(this, this.defaultBadValue);
    }

    public boolean isFloating() {
        return this.isFloating;
    }

    public double minimumValue() {
        return this.minval;
    }

    public double maximumValue() {
        return this.maxval;
    }

    public Object newArray(int size) {
        return Array.newInstance(this.clazz, size);
    }

    public void checkArray(Object array, int minsize) {
        if (array.getClass().getComponentType() != this.clazz) {
            throw new IllegalArgumentException("Object " + array + " is not of type " + this.clazz + "[]");
        }
        if (Array.getLength(array) < minsize) {
            throw new IllegalArgumentException("Primitive array too short: " + Array.getLength(array) + " < " + minsize);
        }
    }

    public static List allTypes() {
        return Collections.unmodifiableList(allTypes);
    }

    public static Type getType(Class cls) {
        if (Byte.TYPE.equals(cls)) {
            return BYTE;
        }
        if (Short.TYPE.equals(cls)) {
            return SHORT;
        }
        if (Integer.TYPE.equals(cls)) {
            return INT;
        }
        if (Float.TYPE.equals(cls)) {
            return FLOAT;
        }
        if (Double.TYPE.equals(cls)) {
            return DOUBLE;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$array$Type == null ? (class$uk$ac$starlink$array$Type = Type.class$("uk.ac.starlink.array.Type")) : class$uk$ac$starlink$array$Type).desiredAssertionStatus();
        allTypes = new ArrayList(5);
        BYTE = new Type("byte");
        SHORT = new Type("short");
        INT = new Type("int");
        FLOAT = new Type("float");
        DOUBLE = new Type("double");
    }
}

