/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.WrapperArrayImpl;

public class WindowArrayImpl
extends WrapperArrayImpl {
    private final NDArray nda;
    private final NDShape window;
    private final OrderedNDShape oshape;
    private final BadHandler badHandler;
    private final OrderedNDShape baseShape;
    private final OrderedNDShape inter;
    private final Order order;
    private final long firstIn;
    private final long lastIn;
    private final long npix;
    private final long baseNpix;

    public WindowArrayImpl(NDArray nda, NDShape window) {
        super(nda);
        this.nda = nda;
        this.window = window;
        if (nda.getShape().getNumDims() != window.getNumDims()) {
            throw new IllegalArgumentException("Dimensionality mismatch: window dims (" + window.getNumDims() + ") != " + "NDArray dims (" + nda.getShape().getNumDims() + ")");
        }
        this.baseShape = nda.getShape();
        this.order = this.baseShape.getOrder();
        this.oshape = new OrderedNDShape(window, this.order);
        this.npix = this.oshape.getNumPixels();
        this.baseNpix = this.baseShape.getNumPixels();
        this.badHandler = nda.getBadHandler();
        NDShape intersect = this.baseShape.intersection(this.oshape);
        if (intersect != null) {
            this.inter = new OrderedNDShape(intersect, this.order);
            long np1 = this.inter.getNumPixels() - 1L;
            this.firstIn = this.oshape.positionToOffset(this.inter.offsetToPosition(0L));
            this.lastIn = this.oshape.positionToOffset(this.inter.offsetToPosition(np1));
        } else {
            this.inter = null;
            this.firstIn = 0L;
            this.lastIn = 0L;
        }
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public BadHandler getBadHandler() {
        return this.badHandler;
    }

    public AccessImpl getAccess() throws IOException {
        if (this.inter != null) {
            return new AccessImpl(){
                private ArrayAccess acc;
                private long offset;
                {
                    this.acc = WindowArrayImpl.this.nda.getAccess();
                    this.offset = 0L;
                }

                public void setOffset(long off) {
                    this.offset = off;
                }

                public void read(Object buffer, int start, int size) throws IOException {
                    while (size > 0) {
                        int num;
                        if (WindowArrayImpl.this.inCommon(this.offset)) {
                            num = WindowArrayImpl.this.numCommon(this.offset, size);
                            this.acc.setOffset(WindowArrayImpl.this.baseOff(this.offset));
                            this.acc.read(buffer, start, num);
                            size -= num;
                            start += num;
                            this.offset += (long)num;
                            continue;
                        }
                        num = WindowArrayImpl.this.numNotCommon(this.offset, size);
                        WindowArrayImpl.this.badHandler.putBad(buffer, start, num);
                        size -= num;
                        start += num;
                        this.offset += (long)num;
                    }
                }

                public void write(Object buffer, int start, int size) throws IOException {
                    while (size > 0) {
                        int num;
                        if (WindowArrayImpl.this.inCommon(start)) {
                            num = WindowArrayImpl.this.numCommon(this.offset, size);
                            this.acc.setOffset(WindowArrayImpl.this.baseOff(this.offset));
                            this.acc.write(buffer, start, num);
                            size -= num;
                            start += num;
                            this.offset += (long)num;
                            continue;
                        }
                        num = WindowArrayImpl.this.numNotCommon(this.offset, size);
                        size -= num;
                        start += num;
                        this.offset += (long)num;
                    }
                }

                public void close() throws IOException {
                    this.acc.close();
                }
            };
        }
        return new AccessImpl(){

            public void setOffset(long off) {
            }

            public void read(Object buffer, int start, int size) {
                WindowArrayImpl.this.badHandler.putBad(buffer, start, size);
            }

            public void write(Object buffer, int start, int size) {
            }

            public void close() {
            }
        };
    }

    private long baseOff(long off) {
        return this.baseShape.positionToOffset(this.oshape.offsetToPosition(off));
    }

    private boolean inCommon(long off) {
        return this.baseShape.within(this.oshape.offsetToPosition(off));
    }

    private int numCommon(long off, int max) {
        long boff = this.baseOff(off);
        Iterator iw = this.oshape.pixelIterator(off, this.npix - off);
        Iterator ib = this.baseShape.pixelIterator(boff, this.baseNpix - boff);
        iw.next();
        ib.next();
        int ncomm = 1;
        while (iw.hasNext() && ib.hasNext() && Arrays.equals((long[])iw.next(), (long[])ib.next()) && --max > 0) {
            ++ncomm;
        }
        return ncomm;
    }

    private int numNotCommon(long off, int max) {
        if (off < this.firstIn) {
            return (int)Math.min(this.firstIn - off, (long)max);
        }
        if (off > this.lastIn) {
            return (int)Math.min(this.npix - off, (long)max);
        }
        Iterator iw = this.oshape.pixelIterator(off, this.npix - off);
        int nncomm = 1;
        iw.next();
        while (iw.hasNext() && !this.baseShape.within((long[])iw.next()) && --max > 0) {
            ++nncomm;
        }
        return nncomm;
    }
}

