/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ArrayMath;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;

public class DoubleTridiagonalMatrix
extends DoubleSquareMatrix {
    protected static final int TRIDIAGONAL = 3;
    protected double[] ldiag;
    protected double[] diag;
    protected double[] udiag;

    protected DoubleTridiagonalMatrix(int n, int n2) {
        super(n, n2);
    }

    public DoubleTridiagonalMatrix(int n) {
        this(n, 3);
        this.matrix = new double[3][n];
        this.ldiag = this.matrix[0];
        this.diag = this.matrix[1];
        this.udiag = this.matrix[2];
    }

    public DoubleTridiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        int n;
        if (dArray.length == dArray[0].length) {
            this.diag[0] = dArray[0][0];
            this.udiag[0] = dArray[0][1];
            n = 1;
            while (n < dArray.length - 1) {
                this.ldiag[n] = dArray[n][n - 1];
                this.diag[n] = dArray[n][n];
                this.udiag[n] = dArray[n][n + 1];
                ++n;
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
        this.ldiag[n] = dArray[n][n - 1];
        this.diag[n] = dArray[n][n];
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleTridiagonalMatrix && this.numRows == ((DoubleTridiagonalMatrix)object).rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = (DoubleTridiagonalMatrix)object;
            if (Math.abs(this.diag[0] - doubleTridiagonalMatrix.getElement(0, 0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            if (Math.abs(this.udiag[0] - doubleTridiagonalMatrix.getElement(0, 1)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.numRows - 1) {
                if (Math.abs(this.ldiag[n] - doubleTridiagonalMatrix.getElement(n, n - 1)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.diag[n] - doubleTridiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.udiag[n] - doubleTridiagonalMatrix.getElement(n, n + 1)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            if (Math.abs(this.ldiag[n] - doubleTridiagonalMatrix.getElement(n, n - 1)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            return !(Math.abs(this.diag[n] - doubleTridiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.rows() * this.columns());
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public IntegerMatrix toIntegerMatrix() {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.numRows);
        integerTridiagonalMatrix.diag[0] = Math.round((float)this.diag[0]);
        integerTridiagonalMatrix.udiag[0] = Math.round((float)this.udiag[0]);
        int n = 1;
        while (n < this.numRows - 1) {
            integerTridiagonalMatrix.ldiag[n] = Math.round((float)this.ldiag[n]);
            integerTridiagonalMatrix.diag[n] = Math.round((float)this.diag[n]);
            integerTridiagonalMatrix.udiag[n] = Math.round((float)this.udiag[n]);
            ++n;
        }
        integerTridiagonalMatrix.ldiag[n] = Math.round((float)this.ldiag[n]);
        integerTridiagonalMatrix.diag[n] = Math.round((float)this.diag[n]);
        return integerTridiagonalMatrix;
    }

    public ComplexMatrix toComplexMatrix() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
        complexTridiagonalMatrix.matrixRe[1][0] = this.diag[0];
        complexTridiagonalMatrix.matrixRe[2][0] = this.udiag[0];
        int n = 1;
        while (n < this.numRows - 1) {
            complexTridiagonalMatrix.matrixRe[0][n] = this.ldiag[n];
            complexTridiagonalMatrix.matrixRe[1][n] = this.diag[n];
            complexTridiagonalMatrix.matrixRe[2][n] = this.udiag[n];
            ++n;
        }
        complexTridiagonalMatrix.matrixRe[0][n] = this.ldiag[n];
        complexTridiagonalMatrix.matrixRe[1][n] = this.diag[n];
        return complexTridiagonalMatrix;
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 >= n - 1 && n2 <= n + 1) {
                return this.matrix[n2 - n + 1][n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 < n - 1 || n2 > n + 1) {
                throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n2 - n + 1][n] = d;
    }

    public boolean isSymmetric() {
        if (this.ldiag[1] != this.udiag[0]) {
            return false;
        }
        int n = 1;
        while (n < this.numRows - 1) {
            if (this.ldiag[n + 1] != this.udiag[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double trace() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diag[n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d;
        double d2 = Math.abs(this.diag[0]) + Math.abs(this.udiag[0]);
        int n = 1;
        while (n < this.numRows - 1) {
            d = Math.abs(this.ldiag[n]) + Math.abs(this.diag[n]) + Math.abs(this.udiag[n]);
            if (d > d2) {
                d2 = d;
            }
            ++n;
        }
        d = Math.abs(this.ldiag[n]) + Math.abs(this.diag[n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        double d = this.diag[0] * this.diag[0] + this.udiag[0] * this.udiag[0];
        int n = 1;
        while (n < this.numRows - 1) {
            d += this.ldiag[n] * this.ldiag[n] + this.diag[n] * this.diag[n] + this.udiag[n] * this.udiag[n];
            ++n;
        }
        return Math.sqrt(d += this.ldiag[n] * this.ldiag[n] + this.diag[n] * this.diag[n]);
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((DoubleTridiagonalMatrix)this.transpose().multiply(this))));
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(doubleMatrix.matrix[n], 0, dArray[n], 0, this.numRows);
                ++n;
            }
            double[] dArray2 = dArray[0];
            dArray2[0] = dArray2[0] + this.diag[0];
            double[] dArray3 = dArray[0];
            dArray3[1] = dArray3[1] + this.udiag[0];
            int n2 = this.numRows - 1;
            int n3 = 1;
            while (n3 < n2) {
                double[] dArray4 = dArray[n3];
                int n4 = n3 - 1;
                dArray4[n4] = dArray4[n4] + this.ldiag[n3];
                double[] dArray5 = dArray[n3];
                int n5 = n3;
                dArray5[n5] = dArray5[n5] + this.diag[n3];
                double[] dArray6 = dArray[n3];
                int n6 = n3 + 1;
                dArray6[n6] = dArray6[n6] + this.udiag[n3];
                ++n3;
            }
            double[] dArray7 = dArray[n2];
            int n7 = n2 - 1;
            dArray7[n7] = dArray7[n7] + this.ldiag[n2];
            double[] dArray8 = dArray[n2];
            int n8 = n2;
            dArray8[n8] = dArray8[n8] + this.diag[n2];
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] + doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.udiag[0] = this.udiag[0] + doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = this.ldiag[n2] + doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] + doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.udiag[n2] = this.udiag[n2] + doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.ldiag[n] + doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] + doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawAddTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (n == doubleMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] + doubleMatrix.matrix[1][0];
            doubleTridiagonalMatrix.udiag[0] = this.udiag[0] + doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] + doubleMatrix.matrix[0][n2];
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] + doubleMatrix.matrix[1][n2];
                doubleTridiagonalMatrix.udiag[n2] = this.udiag[n2] + doubleMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n] + doubleMatrix.matrix[0][n];
            doubleTridiagonalMatrix.diag[n] = this.diag[n] + doubleMatrix.matrix[1][n];
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] - doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.udiag[0] = this.udiag[0] - doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = this.ldiag[n2] - doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] - doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.udiag[n2] = this.udiag[n2] - doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.ldiag[n] - doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] - doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawSubtractTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (n == doubleMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] - doubleMatrix.matrix[1][0];
            doubleTridiagonalMatrix.udiag[0] = this.udiag[0] - doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] - doubleMatrix.matrix[0][n2];
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] - doubleMatrix.matrix[1][n2];
                doubleTridiagonalMatrix.udiag[n2] = this.udiag[n2] - doubleMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n] - doubleMatrix.matrix[0][n];
            doubleTridiagonalMatrix.diag[n] = this.diag[n] - doubleMatrix.matrix[1][n];
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        int n = this.numRows;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.diag[0] = d * this.diag[0];
        doubleTridiagonalMatrix.udiag[0] = d * this.udiag[0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.ldiag[n2] = d * this.ldiag[n2];
            doubleTridiagonalMatrix.diag[n2] = d * this.diag[n2];
            doubleTridiagonalMatrix.udiag[n2] = d * this.udiag[n2];
            ++n2;
        }
        doubleTridiagonalMatrix.ldiag[n] = d * this.ldiag[n];
        doubleTridiagonalMatrix.diag[n] = d * this.diag[n];
        return doubleTridiagonalMatrix;
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
            case 3: {
                return this.rawScalarProductTridiagonal(doubleMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleMatrix.rows() && n == doubleMatrix.columns()) {
            double d = 0.0;
            d += this.diag[0] * doubleMatrix.getElement(0, 0);
            d += this.udiag[0] * doubleMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleMatrix.getElement(n2, n2 - 1);
                d += this.diag[n2] * doubleMatrix.getElement(n2, n2);
                d += this.udiag[n2] * doubleMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            d += this.ldiag[n] * doubleMatrix.getElement(n, n - 1);
            return d += this.diag[n] * doubleMatrix.getElement(n, n);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (n == doubleMatrix.numRows && n == doubleMatrix.numCols) {
            double d = 0.0;
            d += this.diag[0] * doubleMatrix.matrix[0][0];
            d += this.udiag[0] * doubleMatrix.matrix[0][1];
            --n;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleMatrix.matrix[n2][n2 - 1];
                d += this.diag[n2] * doubleMatrix.matrix[n2][n2];
                d += this.udiag[n2] * doubleMatrix.matrix[n2][n2 + 1];
                ++n2;
            }
            d += this.ldiag[n] * doubleMatrix.matrix[n][n - 1];
            return d += this.diag[n] * doubleMatrix.matrix[n][n];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleSquareMatrix);
            }
            case 3: {
                return this.rawScalarProductTridiagonal(doubleSquareMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleSquareMatrix.rows()) {
            double d = 0.0;
            d += this.diag[0] * doubleSquareMatrix.getElement(0, 0);
            d += this.udiag[0] * doubleSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleSquareMatrix.getElement(n2, n2 - 1);
                d += this.diag[n2] * doubleSquareMatrix.getElement(n2, n2);
                d += this.udiag[n2] * doubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            d += this.ldiag[n] * doubleSquareMatrix.getElement(n, n - 1);
            return d += this.diag[n] * doubleSquareMatrix.getElement(n, n);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawScalarProductTridiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.rows()) {
            double d = 0.0;
            d += this.diag[0] * doubleTridiagonalMatrix.getElement(0, 0);
            d += this.udiag[0] * doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                d += this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2);
                d += this.udiag[n2] * doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            d += this.ldiag[n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            return d += this.diag[n] * doubleTridiagonalMatrix.getElement(n, n);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProductTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (n == doubleMatrix.numRows) {
            double d = 0.0;
            d += this.diag[0] * doubleMatrix.matrix[1][0];
            d += this.udiag[0] * doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleMatrix.matrix[0][n2];
                d += this.diag[n2] * doubleMatrix.matrix[1][n2];
                d += this.udiag[n2] * doubleMatrix.matrix[2][n2];
                ++n2;
            }
            d += this.ldiag[n] * doubleMatrix.matrix[0][n];
            return d += this.diag[n] * doubleMatrix.matrix[1][n];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        int n = this.numRows;
        if (this.numCols == doubleVector.dimension()) {
            double[] dArray = new double[n];
            dArray[0] = this.diag[0] * doubleVector.getComponent(0) + this.udiag[0] * doubleVector.getComponent(1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                dArray[n2] = this.ldiag[n2] * doubleVector.getComponent(n2 - 1) + this.diag[n2] * doubleVector.getComponent(n2) + this.udiag[n2] * doubleVector.getComponent(n2 + 1);
                ++n2;
            }
            dArray[n] = this.ldiag[n] * doubleVector.getComponent(n - 1) + this.diag[n] * doubleVector.getComponent(n);
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(doubleMatrix);
            }
        }
        if (this.numCols == doubleMatrix.rows()) {
            double[][] dArray = new double[this.numRows][doubleMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.columns()) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.numCols) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(doubleSquareMatrix);
            }
        }
        if (this.numCols == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (this.numCols == doubleTridiagonalMatrix.rows()) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.diag[0] * doubleTridiagonalMatrix.getElement(0, 0) + this.udiag[0] * doubleTridiagonalMatrix.getElement(1, 0);
            dArray[0][1] = this.diag[0] * doubleTridiagonalMatrix.getElement(0, 1) + this.udiag[0] * doubleTridiagonalMatrix.getElement(1, 1);
            dArray[0][2] = this.udiag[0] * doubleTridiagonalMatrix.getElement(1, 2);
            if (n > 3) {
                dArray[1][0] = this.ldiag[1] * doubleTridiagonalMatrix.getElement(0, 0) + this.diag[1] * doubleTridiagonalMatrix.getElement(1, 0);
                dArray[1][1] = this.ldiag[1] * doubleTridiagonalMatrix.getElement(0, 1) + this.diag[1] * doubleTridiagonalMatrix.getElement(1, 1) + this.udiag[1] * doubleTridiagonalMatrix.getElement(2, 1);
                dArray[1][2] = this.diag[1] * doubleTridiagonalMatrix.getElement(1, 2) + this.udiag[1] * doubleTridiagonalMatrix.getElement(2, 2);
                dArray[1][3] = this.udiag[1] * doubleTridiagonalMatrix.getElement(2, 3);
            }
            if (n == 3) {
                dArray[1][0] = this.ldiag[1] * doubleTridiagonalMatrix.getElement(0, 0) + this.diag[1] * doubleTridiagonalMatrix.getElement(1, 0);
                dArray[1][1] = this.ldiag[1] * doubleTridiagonalMatrix.getElement(0, 1) + this.diag[1] * doubleTridiagonalMatrix.getElement(1, 1) + this.udiag[1] * doubleTridiagonalMatrix.getElement(2, 1);
                dArray[1][2] = this.diag[1] * doubleTridiagonalMatrix.getElement(1, 2) + this.udiag[1] * doubleTridiagonalMatrix.getElement(2, 2);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.ldiag[n2] * doubleTridiagonalMatrix.getElement(n2 - 1, n2 - 2);
                    dArray[n2][n2 - 1] = this.ldiag[n2] * doubleTridiagonalMatrix.getElement(n2 - 1, n2 - 1) + this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                    dArray[n2][n2] = this.ldiag[n2] * doubleTridiagonalMatrix.getElement(n2 - 1, n2) + this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2) + this.udiag[n2] * doubleTridiagonalMatrix.getElement(n2 + 1, n2);
                    dArray[n2][n2 + 1] = this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2 + 1) + this.udiag[n2] * doubleTridiagonalMatrix.getElement(n2 + 1, n2 + 1);
                    dArray[n2][n2 + 2] = this.udiag[n2] * doubleTridiagonalMatrix.getElement(n2 + 1, n2 + 2);
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.ldiag[n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 3] = this.ldiag[n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 3) + this.diag[n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 2] = this.ldiag[n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 2) + this.diag[n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 2) + this.udiag[n - 2] * doubleTridiagonalMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 1] = this.diag[n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 1) + this.udiag[n - 2] * doubleTridiagonalMatrix.getElement(n - 1, n - 1);
            }
            dArray[n][--n - 2] = this.ldiag[n] * doubleTridiagonalMatrix.getElement(n - 1, n - 2);
            dArray[n][n - 1] = this.ldiag[n] * doubleTridiagonalMatrix.getElement(n - 1, n - 1) + this.diag[n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            dArray[n][n] = this.ldiag[n] * doubleTridiagonalMatrix.getElement(n - 1, n) + this.diag[n] * doubleTridiagonalMatrix.getElement(n, n);
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiplyTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.diag[0] * doubleMatrix.matrix[1][0] + this.udiag[0] * doubleMatrix.matrix[0][1];
            dArray[0][1] = this.diag[0] * doubleMatrix.matrix[2][0] + this.udiag[0] * doubleMatrix.matrix[1][1];
            dArray[0][2] = this.udiag[0] * doubleMatrix.matrix[2][1];
            if (n > 3) {
                dArray[1][0] = this.ldiag[1] * doubleMatrix.matrix[1][0] + this.diag[1] * doubleMatrix.matrix[0][1];
                dArray[1][1] = this.ldiag[1] * doubleMatrix.matrix[2][0] + this.diag[1] * doubleMatrix.matrix[1][1] + this.udiag[1] * doubleMatrix.matrix[0][2];
                dArray[1][2] = this.diag[1] * doubleMatrix.matrix[2][1] + this.udiag[1] * doubleMatrix.matrix[1][2];
                dArray[1][3] = this.udiag[1] * doubleMatrix.matrix[2][2];
            }
            if (n == 3) {
                dArray[1][0] = this.ldiag[1] * doubleMatrix.matrix[1][0] + this.diag[1] * doubleMatrix.matrix[0][1];
                dArray[1][1] = this.ldiag[1] * doubleMatrix.matrix[2][0] + this.diag[1] * doubleMatrix.matrix[1][1] + this.udiag[1] * doubleMatrix.matrix[0][2];
                dArray[1][2] = this.diag[1] * doubleMatrix.matrix[2][1] + this.udiag[1] * doubleMatrix.matrix[1][2];
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.ldiag[n2] * doubleMatrix.matrix[0][n2 - 1];
                    dArray[n2][n2 - 1] = this.ldiag[n2] * doubleMatrix.matrix[1][n2 - 1] + this.diag[n2] * doubleMatrix.matrix[0][n2];
                    dArray[n2][n2] = this.ldiag[n2] * doubleMatrix.matrix[2][n2 - 1] + this.diag[n2] * doubleMatrix.matrix[1][n2] + this.udiag[n2] * doubleMatrix.matrix[0][n2 + 1];
                    dArray[n2][n2 + 1] = this.diag[n2] * doubleMatrix.matrix[2][n2] + this.udiag[n2] * doubleMatrix.matrix[1][n2 + 1];
                    dArray[n2][n2 + 2] = this.udiag[n2] * doubleMatrix.matrix[2][n2 + 1];
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.ldiag[n - 2] * doubleMatrix.matrix[0][n - 3];
                dArray[n - 2][n - 3] = this.ldiag[n - 2] * doubleMatrix.matrix[1][n - 3] + this.diag[n - 2] * doubleMatrix.matrix[0][n - 2];
                dArray[n - 2][n - 2] = this.ldiag[n - 2] * doubleMatrix.matrix[2][n - 3] + this.diag[n - 2] * doubleMatrix.matrix[1][n - 2] + this.udiag[n - 2] * doubleMatrix.matrix[0][n - 1];
                dArray[n - 2][n - 1] = this.diag[n - 2] * doubleMatrix.matrix[2][n - 2] + this.udiag[n - 2] * doubleMatrix.matrix[1][n - 1];
            }
            dArray[n][--n - 2] = this.ldiag[n] * doubleMatrix.matrix[0][n - 1];
            dArray[n][n - 1] = this.ldiag[n] * doubleMatrix.matrix[1][n - 1] + this.diag[n] * doubleMatrix.matrix[0][n];
            dArray[n][n] = this.ldiag[n] * doubleMatrix.matrix[2][n - 1] + this.diag[n] * doubleMatrix.matrix[1][n];
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiag, 1, doubleTridiagonalMatrix.udiag, 0, this.ldiag.length - 1);
        System.arraycopy(this.diag, 0, doubleTridiagonalMatrix.diag, 0, this.diag.length);
        System.arraycopy(this.udiag, 0, doubleTridiagonalMatrix.ldiag, 1, this.udiag.length - 1);
        return doubleTridiagonalMatrix;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double[] dArray3 = new double[n];
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[n] = 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            double d;
            n2 = 0;
            while (n2 < n3) {
                d = this.getElement(nArray[n2], n3);
                n4 = 0;
                while (n4 < n2) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                ++n2;
            }
            double d2 = 0.0;
            int n5 = n3;
            n2 = n3;
            while (n2 < n) {
                d = this.getElement(nArray[n2], n3);
                n4 = 0;
                while (n4 < n3) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n5 = n2;
                }
                ++n2;
            }
            if (n5 != n3) {
                System.arraycopy(dArray2[n3], 0, dArray3, 0, n3 + 1);
                System.arraycopy(dArray2[n5], 0, dArray2[n3], 0, n3 + 1);
                System.arraycopy(dArray3, 0, dArray2[n5], 0, n3 + 1);
                n4 = nArray[n3];
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                nArray[n] = -nArray[n];
            }
            d = dArray2[n3][n3];
            n2 = n3 + 1;
            while (n2 < n) {
                double[] dArray4 = dArray2[n2];
                int n6 = n3;
                dArray4[n6] = dArray4[n6] / d;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3][n3] = 1.0;
            n2 = n3 + 1;
            while (n2 < n) {
                dArray[n2][n3] = dArray2[n2][n3];
                dArray2[n2][n3] = 0.0;
                ++n2;
            }
            ++n3;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double d;
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d2 = d = Math.sqrt(this.diag[0]);
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        double d3 = this.ldiag[1] / d;
        dArray2[0][1] = d3;
        dArray[1][0] = d3;
        int n2 = 1;
        while (n2 < n) {
            d = this.diag[n2];
            int n3 = 0;
            while (n3 < n2) {
                d -= dArray[n2][n3] * dArray[n2][n3];
                ++n3;
            }
            double d4 = Math.sqrt(d);
            dArray2[n2][n2] = d4;
            dArray[n2][n2] = d4;
            if (n2 + 1 < n) {
                d = this.ldiag[n2 + 1];
                int n4 = 0;
                while (n4 < n2 + 1) {
                    d -= dArray[n2][n4] * dArray2[n4][n2 + 1];
                    ++n4;
                }
                double d5 = d / dArray2[n2][n2];
                dArray2[n2][n2 + 1] = d5;
                dArray[n2 + 1][n2] = d5;
                n3 = n2 + 2;
                while (n3 < n) {
                    d = 0.0;
                    n4 = 0;
                    while (n4 < n3) {
                        d -= dArray[n2][n4] * dArray2[n4][n3];
                        ++n4;
                    }
                    double d6 = d / dArray2[n2][n2];
                    dArray2[n2][n3] = d6;
                    dArray[n3][n2] = d6;
                    ++n3;
                }
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] singularValueDecompose() {
        double d;
        int n;
        int n2 = this.numRows;
        int n3 = n2 - 1;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[] dArray3 = new double[n2];
        double[][] dArray4 = new double[n2][n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        dArray[0][0] = this.diag[0];
        dArray[0][1] = this.udiag[0];
        int n4 = 1;
        while (n4 < n3) {
            dArray[n4][n4 - 1] = this.ldiag[n4];
            dArray[n4][n4] = this.diag[n4];
            dArray[n4][n4 + 1] = this.udiag[n4];
            ++n4;
        }
        dArray[n3][n3 - 1] = this.ldiag[n3];
        dArray[n3][n3] = this.diag[n3];
        int n5 = 0;
        while (n5 < n3) {
            double d2;
            dArray3[n5] = dArray[n5][n5];
            n4 = n5 + 1;
            while (n4 < n2) {
                dArray3[n5] = ExtraMath.hypot(dArray3[n5], dArray[n4][n5]);
                ++n4;
            }
            if (dArray3[n5] != 0.0) {
                if (dArray[n5][n5] < 0.0) {
                    dArray3[n5] = -dArray3[n5];
                }
                n4 = n5;
                while (n4 < n2) {
                    double[] dArray7 = dArray[n4];
                    int n6 = n5;
                    dArray7[n6] = dArray7[n6] / dArray3[n5];
                    ++n4;
                }
                double[] dArray8 = dArray[n5];
                int n7 = n5;
                dArray8[n7] = dArray8[n7] + 1.0;
            }
            dArray3[n5] = -dArray3[n5];
            n = n5 + 1;
            while (n < n2) {
                if (dArray3[n5] != 0.0) {
                    d2 = 0.0;
                    n4 = n5;
                    while (n4 < n2) {
                        d2 += dArray[n4][n5] * dArray[n4][n];
                        ++n4;
                    }
                    d2 /= -dArray[n5][n5];
                    n4 = n5;
                    while (n4 < n2) {
                        double[] dArray9 = dArray[n4];
                        int n8 = n;
                        dArray9[n8] = dArray9[n8] + d2 * dArray[n4][n5];
                        ++n4;
                    }
                }
                dArray5[n] = dArray[n5][n];
                ++n;
            }
            n4 = n5;
            while (n4 < n2) {
                dArray2[n4][n5] = dArray[n4][n5];
                ++n4;
            }
            if (n5 < n2 - 2) {
                dArray5[n5] = dArray5[n5 + 1];
                n4 = n5 + 2;
                while (n4 < n2) {
                    dArray5[n5] = ExtraMath.hypot(dArray5[n5], dArray5[n4]);
                    ++n4;
                }
                if (dArray5[n5] != 0.0) {
                    if (dArray5[n5 + 1] < 0.0) {
                        dArray5[n5] = -dArray5[n5];
                    }
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        int n9 = n4++;
                        dArray5[n9] = dArray5[n9] / dArray5[n5];
                    }
                    int n10 = n5 + 1;
                    dArray5[n10] = dArray5[n10] + 1.0;
                }
                dArray5[n5] = -dArray5[n5];
                if (dArray5[n5] != 0.0) {
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        dArray6[n4] = 0.0;
                        n = n5 + 1;
                        while (n < n2) {
                            int n11 = n4;
                            dArray6[n11] = dArray6[n11] + dArray5[n] * dArray[n4][n];
                            ++n;
                        }
                        ++n4;
                    }
                    n = n5 + 1;
                    while (n < n2) {
                        d2 = -dArray5[n] / dArray5[n5 + 1];
                        n4 = n5 + 1;
                        while (n4 < n2) {
                            double[] dArray10 = dArray[n4];
                            int n12 = n;
                            dArray10[n12] = dArray10[n12] + d2 * dArray6[n4];
                            ++n4;
                        }
                        ++n;
                    }
                }
                n4 = n5 + 1;
                while (n4 < n2) {
                    dArray4[n4][n5] = dArray5[n4];
                    ++n4;
                }
            }
            ++n5;
        }
        int n13 = n2;
        dArray3[n3] = dArray[n3][n3];
        dArray5[n2 - 2] = dArray[n2 - 2][n3];
        dArray5[n3] = 0.0;
        n4 = 0;
        while (n4 < n2) {
            dArray2[n4][n3] = 0.0;
            ++n4;
        }
        dArray2[n3][n3] = 1.0;
        n5 = n2 - 2;
        while (n5 >= 0) {
            if (dArray3[n5] != 0.0) {
                n = n5 + 1;
                while (n < n2) {
                    d = dArray2[n5][n5] * dArray2[n5][n];
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        d += dArray2[n4][n5] * dArray2[n4][n];
                        ++n4;
                    }
                    d /= -dArray2[n5][n5];
                    n4 = n5;
                    while (n4 < n2) {
                        double[] dArray11 = dArray2[n4];
                        int n14 = n;
                        dArray11[n14] = dArray11[n14] + d * dArray2[n4][n5];
                        ++n4;
                    }
                    ++n;
                }
                n4 = n5;
                while (n4 < n2) {
                    dArray2[n4][n5] = -dArray2[n4][n5];
                    ++n4;
                }
                double[] dArray12 = dArray2[n5];
                int n15 = n5;
                dArray12[n15] = dArray12[n15] + 1.0;
                n4 = 0;
                while (n4 < n5 - 1) {
                    dArray2[n4][n5] = 0.0;
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 < n2) {
                    dArray2[n4][n5] = 0.0;
                    ++n4;
                }
                dArray2[n5][n5] = 1.0;
            }
            --n5;
        }
        n5 = n3;
        while (n5 >= 0) {
            if (n5 < n2 - 2 && dArray5[n5] != 0.0) {
                n = n5 + 1;
                while (n < n2) {
                    d = dArray4[n5 + 1][n5] * dArray4[n5 + 1][n];
                    n4 = n5 + 2;
                    while (n4 < n2) {
                        d += dArray4[n4][n5] * dArray4[n4][n];
                        ++n4;
                    }
                    d /= -dArray4[n5 + 1][n5];
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        double[] dArray13 = dArray4[n4];
                        int n16 = n;
                        dArray13[n16] = dArray13[n16] + d * dArray4[n4][n5];
                        ++n4;
                    }
                    ++n;
                }
            }
            n4 = 0;
            while (n4 < n2) {
                dArray4[n4][n5] = 0.0;
                ++n4;
            }
            dArray4[n5][n5] = 1.0;
            --n5;
        }
        d = Math.pow(2.0, -52.0);
        int n17 = 0;
        block34: while (n13 > 0) {
            int n18;
            n5 = n13 - 2;
            while (n5 >= -1) {
                if (n5 == -1) break;
                if (Math.abs(dArray5[n5]) <= d * (Math.abs(dArray3[n5]) + Math.abs(dArray3[n5 + 1]))) {
                    dArray5[n5] = 0.0;
                    break;
                }
                --n5;
            }
            if (n5 == n13 - 2) {
                n18 = 4;
            } else {
                int n19 = n13 - 1;
                while (n19 >= n5) {
                    if (n19 == n5) break;
                    double d3 = (n19 != n13 ? Math.abs(dArray5[n19]) : 0.0) + (n19 != n5 + 1 ? Math.abs(dArray5[n19 - 1]) : 0.0);
                    if (Math.abs(dArray3[n19]) <= d * d3) {
                        dArray3[n19] = 0.0;
                        break;
                    }
                    --n19;
                }
                if (n19 == n5) {
                    n18 = 3;
                } else if (n19 == n13 - 1) {
                    n18 = 1;
                } else {
                    n18 = 2;
                    n5 = n19;
                }
            }
            ++n5;
            switch (n18) {
                case 1: {
                    double d4;
                    double d5;
                    double d6;
                    double d7 = dArray5[n13 - 2];
                    dArray5[n13 - 2] = 0.0;
                    n = n13 - 2;
                    while (n >= n5) {
                        d6 = ExtraMath.hypot(dArray3[n], d7);
                        d5 = dArray3[n] / d6;
                        d4 = d7 / d6;
                        dArray3[n] = d6;
                        if (n != n5) {
                            d7 = -d4 * dArray5[n - 1];
                            int n20 = n - 1;
                            dArray5[n20] = dArray5[n20] * d5;
                        }
                        n4 = 0;
                        while (n4 < n2) {
                            d6 = d5 * dArray4[n4][n] + d4 * dArray4[n4][n13 - 1];
                            dArray4[n4][n13 - 1] = -d4 * dArray4[n4][n] + d5 * dArray4[n4][n13 - 1];
                            dArray4[n4][n] = d6;
                            ++n4;
                        }
                        --n;
                    }
                    continue block34;
                }
                case 2: {
                    double d4;
                    double d5;
                    double d6;
                    double d8 = dArray5[n5 - 1];
                    dArray5[n5 - 1] = 0.0;
                    n = n5;
                    while (n < n13) {
                        d6 = ExtraMath.hypot(dArray3[n], d8);
                        d5 = dArray3[n] / d6;
                        d4 = d8 / d6;
                        dArray3[n] = d6;
                        d8 = -d4 * dArray5[n];
                        int n21 = n;
                        dArray5[n21] = dArray5[n21] * d5;
                        n4 = 0;
                        while (n4 < n2) {
                            d6 = d5 * dArray2[n4][n] + d4 * dArray2[n4][n5 - 1];
                            dArray2[n4][n5 - 1] = -d4 * dArray2[n4][n] + d5 * dArray2[n4][n5 - 1];
                            dArray2[n4][n] = d6;
                            ++n4;
                        }
                        ++n;
                    }
                    continue block34;
                }
                case 3: {
                    double d9 = Math.max(Math.max(Math.max(Math.max(Math.abs(dArray3[n13 - 1]), Math.abs(dArray3[n13 - 2])), Math.abs(dArray5[n13 - 2])), Math.abs(dArray3[n5])), Math.abs(dArray5[n5]));
                    double d6 = dArray3[n13 - 1] / d9;
                    double d5 = dArray3[n13 - 2] / d9;
                    double d4 = dArray5[n13 - 2] / d9;
                    double d10 = dArray3[n5] / d9;
                    double d11 = dArray5[n5] / d9;
                    double d12 = ((d5 + d6) * (d5 - d6) + d4 * d4) / 2.0;
                    double d13 = d6 * d4 * (d6 * d4);
                    double d14 = 0.0;
                    if (d12 != 0.0 || d13 != 0.0) {
                        d14 = Math.sqrt(d12 * d12 + d13);
                        if (d12 < 0.0) {
                            d14 = -d14;
                        }
                        d14 = d13 / (d12 + d14);
                    }
                    double d15 = (d10 + d6) * (d10 - d6) + d14;
                    double d16 = d10 * d11;
                    n = n5;
                    while (n < n13 - 1) {
                        double d17 = ExtraMath.hypot(d15, d16);
                        double d18 = d15 / d17;
                        double d19 = d16 / d17;
                        if (n != n5) {
                            dArray5[n - 1] = d17;
                        }
                        d15 = d18 * dArray3[n] + d19 * dArray5[n];
                        dArray5[n] = d18 * dArray5[n] - d19 * dArray3[n];
                        d16 = d19 * dArray3[n + 1];
                        int n22 = n + 1;
                        dArray3[n22] = dArray3[n22] * d18;
                        n4 = 0;
                        while (n4 < n2) {
                            d17 = d18 * dArray4[n4][n] + d19 * dArray4[n4][n + 1];
                            dArray4[n4][n + 1] = -d19 * dArray4[n4][n] + d18 * dArray4[n4][n + 1];
                            dArray4[n4][n] = d17;
                            ++n4;
                        }
                        d17 = ExtraMath.hypot(d15, d16);
                        d18 = d15 / d17;
                        d19 = d16 / d17;
                        dArray3[n] = d17;
                        d15 = d18 * dArray5[n] + d19 * dArray3[n + 1];
                        dArray3[n + 1] = -d19 * dArray5[n] + d18 * dArray3[n + 1];
                        d16 = d19 * dArray5[n + 1];
                        int n23 = n + 1;
                        dArray5[n23] = dArray5[n23] * d18;
                        if (n < n3) {
                            n4 = 0;
                            while (n4 < n2) {
                                d17 = d18 * dArray2[n4][n] + d19 * dArray2[n4][n + 1];
                                dArray2[n4][n + 1] = -d19 * dArray2[n4][n] + d18 * dArray2[n4][n + 1];
                                dArray2[n4][n] = d17;
                                ++n4;
                            }
                        }
                        ++n;
                    }
                    dArray5[n13 - 2] = d15;
                    ++n17;
                    break;
                }
                case 4: {
                    if (dArray3[n5] <= 0.0) {
                        dArray3[n5] = -dArray3[n5];
                        n4 = 0;
                        while (n4 < n13) {
                            dArray4[n4][n5] = -dArray4[n4][n5];
                            ++n4;
                        }
                    }
                    while (n5 < n13 - 1) {
                        if (dArray3[n5] >= dArray3[n5 + 1]) break;
                        double d20 = dArray3[n5];
                        dArray3[n5] = dArray3[n5 + 1];
                        dArray3[n5 + 1] = d20;
                        if (n5 < n3) {
                            n4 = 0;
                            while (n4 < n2) {
                                d20 = dArray2[n4][n5 + 1];
                                dArray2[n4][n5 + 1] = dArray2[n4][n5];
                                dArray2[n4][n5] = d20;
                                d20 = dArray4[n4][n5 + 1];
                                dArray4[n4][n5 + 1] = dArray4[n4][n5];
                                dArray4[n4][n5] = d20;
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    n17 = 0;
                    --n13;
                }
            }
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleDiagonalMatrix(dArray3), new DoubleSquareMatrix(dArray4)};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        int n = this.numRows;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.diag[0] = mapping.map(this.diag[0]);
        doubleTridiagonalMatrix.udiag[0] = mapping.map(this.udiag[0]);
        --n;
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.ldiag[n2] = mapping.map(this.ldiag[n2]);
            doubleTridiagonalMatrix.diag[n2] = mapping.map(this.diag[n2]);
            doubleTridiagonalMatrix.udiag[n2] = mapping.map(this.udiag[n2]);
            ++n2;
        }
        doubleTridiagonalMatrix.ldiag[n] = mapping.map(this.ldiag[n]);
        doubleTridiagonalMatrix.diag[n] = mapping.map(this.diag[n]);
        return doubleTridiagonalMatrix;
    }
}

