/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.rv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import uk.ac.starlink.pal.Observatory;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.pal.palError;
import uk.ac.starlink.rv.RadialVelocity;

public class RVPanel
extends JPanel
implements ActionListener {
    private Pal pal;
    private final boolean TRACE = false;
    private final boolean DEBUG = false;
    private final String HELP = "Help";
    private final String RUN = "Run";
    private final String EXIT = "Exit";
    private final String SELECT = "Select File";
    private final Color FOREGROUND = Color.blue;
    private final Color BACKGROUND = Color.lightGray;
    private final Color WHITE = Color.white;
    private String task = null;
    private String text = null;
    private File output = null;
    private boolean applet = false;
    private boolean fileoutput = true;
    private static String[] Equinox = new String[]{"J2000", "B1975", "B1950", "B1900", "B1875", "B1855"};
    private static String[] Days = new String[]{"1", "2", "3", "4", "5", "6", "7", "14"};
    private String observatory;
    private String observatoryName;
    private String day = "1";
    private static String equinox_def = Equinox[2];
    private String equinox = equinox_def;
    private String outputname = "rv.lis";
    private final int XSIZE = 660;
    private final int YSIZE = 580;
    private final int TXSIZE = 600;
    private final int TYSIZE = 300;
    private Container Pane;
    private GridBagConstraints dateConstraint;
    private GridBagConstraints dayConstraint;
    private GridBagConstraints raConstraint;
    private GridBagConstraints decConstraint;
    private JComboBox observatoryBox;
    private JFileChooser outputFileBox;
    private JTextField observatoryField;
    private JTextField outputFile;
    private JTextField dateField;
    private JTextField raField;
    private JTextField dayField;
    private JTextField decField;
    private JTextArea textarea;
    private JScrollPane scrollpane;
    private JComboBox equinoxBox;
    private JComboBox dayBox;
    private JButton button;
    private GridBagConstraints result_constraints;

    RVPanel(Container pane) {
        this.pal = new Pal();
        this.Pane = pane;
    }

    public void paintComponent(Graphics gc) {
        super.paintComponent(gc);
        gc.setColor(this.BACKGROUND);
        gc.fillRect(0, 0, 800, 600);
    }

    public void setup(String task) {
        if (task == null) {
            this.applet = true;
            this.fileoutput = false;
            task = "Applet";
        }
        this.trace(this.getToday());
        this.trace("Setup: " + task);
        this.Pane.setBackground(this.BACKGROUND);
        this.Pane.setForeground(this.FOREGROUND);
        this.initPanel(this.Pane);
        this.Pane.setVisible(true);
    }

    private void initPanel(Container pane) {
        Font label_font = new Font("SansSerif", 1, 12);
        this.trace("initPanel: " + this.task);
        pane.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.weightx = 0.0;
        constraint.weighty = 0.0;
        constraint.gridwidth = 1;
        constraint.gridheight = 2;
        constraint.gridx = 0;
        constraint.gridy = 0;
        constraint.anchor = 17;
        constraint.fill = 2;
        JLabel label = new JLabel("Observatory: ");
        label.setFont(label_font);
        pane.add((Component)label, constraint);
        this.observatoryBox = new JComboBox();
        this.observatoryBox.setBackground(this.WHITE);
        this.observatoryBox.setEditable(false);
        int i = 1;
        while (true) {
            Observatory obs = this.pal.Obs(i);
            if (i == 1) {
                this.observatoryName = obs.getName();
                this.observatory = obs.getId();
            }
            if (obs.getName() == null) break;
            String id = obs.getId();
            this.observatoryBox.addItem(id);
            ++i;
        }
        this.observatoryBox.addActionListener(this);
        ++constraint.gridx;
        constraint.gridwidth = 2;
        pane.add((Component)this.observatoryBox, constraint);
        constraint.gridx += 2;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("    "), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 2;
        this.observatoryField = new JTextField(this.observatoryName);
        this.observatoryField.setEditable(false);
        this.observatoryField.setBackground(this.WHITE);
        pane.add((Component)this.observatoryField, constraint);
        constraint.gridy += 2;
        constraint.gridx = 1;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("            "), constraint);
        if (this.fileoutput) {
            constraint.gridy += 2;
            constraint.gridx = 0;
            pane.add((Component)new JLabel("Output File:"), constraint);
            ++constraint.gridx;
            this.outputFile = new JTextField(this.outputname);
            constraint.gridwidth = 2;
            pane.add((Component)this.outputFile, constraint);
            constraint.gridx += 3;
            constraint.gridwidth = 1;
            this.button = new JButton("Select File");
            this.button.addActionListener(this);
            pane.add((Component)this.button, constraint);
            constraint.gridy += 2;
            constraint.gridx = 0;
            constraint.gridwidth = 1;
            pane.add((Component)new JLabel(" "), constraint);
        }
        constraint.gridy += 2;
        constraint.gridx = 0;
        pane.add((Component)new JLabel("Date:"), constraint);
        ++constraint.gridx;
        this.dateField = new JTextField(this.getToday());
        constraint.gridwidth = 2;
        this.dateConstraint = (GridBagConstraints)constraint.clone();
        pane.add((Component)this.dateField, constraint);
        constraint.gridx += 3;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("Day (n): "), constraint);
        ++constraint.gridx;
        this.dayBox = new JComboBox();
        this.dayBox.setEditable(true);
        int i2 = 0;
        while (i2 < Days.length) {
            this.dayBox.addItem(Days[i2]);
            ++i2;
        }
        this.dayBox.addActionListener(this);
        this.dayConstraint = (GridBagConstraints)constraint.clone();
        pane.add((Component)this.dayBox, constraint);
        constraint.gridy += 2;
        constraint.gridx = 0;
        pane.add((Component)new JLabel(" "), constraint);
        constraint.gridy += 2;
        pane.add((Component)new JLabel("R.A. (h m s): "), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 2;
        this.raField = new JTextField("");
        this.raConstraint = (GridBagConstraints)constraint.clone();
        pane.add((Component)this.raField, constraint);
        constraint.gridx += 3;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("Dec. (d m s): "), constraint);
        ++constraint.gridx;
        this.decField = new JTextField("");
        this.decConstraint = (GridBagConstraints)constraint.clone();
        pane.add((Component)this.decField, constraint);
        ++constraint.gridy;
        constraint.gridx = 0;
        pane.add((Component)new JLabel(" "), constraint);
        ++constraint.gridy;
        constraint.gridx = 4;
        pane.add((Component)new JLabel("Equinox:"), constraint);
        this.equinoxBox = new JComboBox();
        this.equinoxBox.setEditable(true);
        int i3 = 0;
        while (i3 < Equinox.length) {
            this.equinoxBox.addItem(Equinox[i3]);
            ++i3;
        }
        this.equinoxBox.setSelectedItem(equinox_def);
        this.equinoxBox.addActionListener(this);
        ++constraint.gridx;
        pane.add((Component)this.equinoxBox, constraint);
        constraint.gridy += 2;
        constraint.gridx = 0;
        pane.add((Component)new JLabel(" "), constraint);
        ButtonPanel buttons = new ButtonPanel();
        buttons.setBackground(this.Pane.getBackground());
        JButton button = new JButton("Help");
        button.addActionListener(this);
        buttons.add(button, "West");
        button = new JButton("Run");
        button.addActionListener(this);
        buttons.add(button, "Center");
        if (!this.applet) {
            button.addActionListener(this);
            button = new JButton("Exit");
            button.addActionListener(this);
            buttons.add(button, "East");
        }
        constraint.gridy += 2;
        constraint.gridx = 0;
        constraint.gridwidth = 0;
        pane.add((Component)buttons, constraint);
        constraint.gridy += 2;
        pane.add(new JLabel("Radial Velocity Results"));
        this.textarea = new JTextArea(80, 40);
        this.scrollpane = new JScrollPane(this.textarea);
        this.textarea.setBackground(this.Pane.getBackground());
        this.scrollpane.setPreferredSize(new Dimension(600, 300));
        constraint.gridy += 2;
        constraint.gridx = 0;
        constraint.gridwidth = 0;
        this.result_constraints = (GridBagConstraints)constraint.clone();
        pane.add((Component)this.scrollpane, constraint);
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String arg = evt.getActionCommand();
        if (source instanceof JComboBox) {
            boolean index = false;
            this.trace("Combo Box Event: " + arg);
            JComboBox box = (JComboBox)source;
            String selection = (String)box.getSelectedItem();
            this.trace(selection + " selected");
            if (box == this.observatoryBox) {
                Observatory obs = this.pal.Obs(selection);
                if (obs != null) {
                    this.observatory = selection;
                    this.observatoryName = obs.getName();
                    this.observatoryField.setText(this.observatoryName);
                }
                this.trace("Telescope: " + this.observatoryName);
            } else if (box == this.equinoxBox) {
                this.equinox = selection;
            } else if (box == this.dayBox) {
                this.day = selection;
            }
            this.Pane.validate();
        }
        if (source instanceof JButton) {
            this.trace("Button Event: " + arg);
            if (arg.equals("Select File")) {
                this.trace("Get Output File");
                JFileChooser outputFileBox = new JFileChooser(new File("."));
                outputFileBox.showOpenDialog(null);
                this.output = outputFileBox.getSelectedFile();
                this.outputname = this.output.getName();
                this.outputFile.setText(this.outputname);
                this.trace("File " + this.outputname + " selected");
            } else if (arg.equals("Run")) {
                this.trace("Run");
                if (this.output == null) {
                    this.output = new File(this.outputname);
                }
                try {
                    this.calculate();
                }
                catch (palError e) {
                    this.trace("ERROR: " + e);
                    JOptionPane errPane = new JOptionPane(e, 0);
                    JDialog dialog = errPane.createDialog(this.button, "Error");
                    dialog.show();
                }
            } else if (arg.equals("Help")) {
                this.trace("Help");
                System.out.println("No Help Available yet");
                JOptionPane helpPane = new JOptionPane("No Help Available yet", 1);
                JDialog dialog = helpPane.createDialog(this.button, "Help");
                dialog.show();
            } else if (arg.equals("Exit")) {
                this.trace(this.task + " killed");
                if (!this.applet) {
                    System.exit(0);
                }
            }
            this.Pane.validate();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calculate() throws palError {
        block9: {
            out = null;
            if (this.observatoryName == null) {
                throw new palError("No Observatory specified");
            }
            try {
                rv = new RadialVelocity();
                rv.setObservatory(this.observatory);
                rv.setDate(this.dateField.getText());
                rv.setDays(this.day);
                rv.setEquinox(this.equinox);
                out = rv.calculateRV(this.raField.getText(), this.decField.getText());
            }
            catch (palError e) {
                throw e;
            }
            catch (Exception e) {
                throw new palError(e.toString());
            }
            this.trace("Text Area Size: " + out.size());
            this.textarea = new JTextArea(120, out.size());
            this.textarea.setFont(new Font("Monospaced", 0, 12));
            i = out.iterator();
            ofile = null;
            if (!this.fileoutput) ** GOTO lbl38
            try {
                ofile = new FileWriter(this.outputname);
                while (i.hasNext()) {
                    str = (String)i.next() + "\n";
                    this.textarea.append(str);
                    if (!this.fileoutput) continue;
                    ofile.write(str);
                }
                if (this.fileoutput) {
                    ofile.close();
                }
                break block9;
            }
            catch (IOException e) {}
            break block9;
lbl-1000:
            // 1 sources

            {
                str = (String)i.next() + "\n";
                this.textarea.append(str);
lbl38:
                // 2 sources

                ** while (i.hasNext())
            }
        }
        this.Pane.remove(this.scrollpane);
        this.scrollpane = new JScrollPane(this.textarea);
        this.scrollpane.setPreferredSize(new Dimension(600, 300));
        this.Pane.add((Component)this.scrollpane, this.result_constraints);
        this.Pane.validate();
    }

    private void trace(String message) {
    }

    private String getToday() {
        DateFormat currentDateFormat = DateFormat.getDateInstance(3, Locale.UK);
        Calendar today = Calendar.getInstance();
        int day = today.get(5);
        int month = today.get(2) + 1;
        int year = today.get(1);
        int days = today.get(6);
        return year + " " + month + " " + day;
    }

    class ButtonPanel
    extends JPanel {
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();

        public ButtonPanel() {
            this.buttonPanel.setLayout(new BorderLayout(50, 5));
            this.buttonPanel.setBackground(RVPanel.this.Pane.getBackground());
            this.add((Component)this.separator, (Object)"North");
            this.add((Component)this.buttonPanel, (Object)"Center");
        }

        public void add(JButton button, String pos) {
            this.buttonPanel.add((Component)button, pos);
        }

        public void add(JButton button) {
            this.buttonPanel.add(button);
        }
    }
}

