/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.rv;

import java.text.NumberFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Galactic;
import uk.ac.starlink.pal.Observatory;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.pal.Stardata;
import uk.ac.starlink.pal.mjDate;
import uk.ac.starlink.pal.palError;
import uk.ac.starlink.pal.palTime;

public class RadialVelocity {
    private final String version = "Version 1.00";
    private final boolean DEBUG = false;
    private final boolean DEBUG_FULL = false;
    private Observatory obs = null;
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int days = 0;
    private char jorb = (char)66;
    private double equinox;
    private double jdate = 0.0;
    private double mid = 0.0;
    private Pal pal;
    private Vector Output = null;

    public RadialVelocity() {
        this.setup();
    }

    public RadialVelocity(String observ) {
        this.setObservatory(observ);
        this.setup();
    }

    public void start(String observ) {
        this.setup();
        this.obs = this.pal.Obs(observ);
        System.out.println("Observatory: " + observ);
        System.out.println("Observatory: " + this.obs.getName());
    }

    private void setup() {
        this.printDebug("Radial Velocity Components - Version 1.00");
        System.out.println("Radial Velocity Components - Version 1.00");
        this.pal = new Pal();
    }

    public void setObservatory(String observatory) {
        this.obs = this.pal.Obs(observatory);
    }

    public void setObservatory(int id) {
        this.obs = this.pal.Obs(id);
    }

    public void setDate(String date) throws palError {
        StringTokenizer st = new StringTokenizer(date);
        if (st.countTokens() != 3) {
            throw new palError("Needs 3 Integers in Date");
        }
        try {
            this.year = Integer.parseInt(st.nextToken());
            this.month = Integer.parseInt(st.nextToken());
            this.day = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            throw new palError("Illegal Number in Date: " + date);
        }
        try {
            this.jdate = this.pal.Caldj(this.year, this.month, this.day);
        }
        catch (palError e) {
            throw new palError("Illegal Date: " + date);
        }
    }

    public void setDays(String day) throws palError {
        try {
            this.days = Integer.parseInt(day);
        }
        catch (NumberFormatException e) {
            throw new palError("Illegal Number in Days: " + day);
        }
    }

    public void setEquinox(String Equinox) throws palError {
        int pos = 0;
        int jb = 0;
        this.jorb = Equinox.charAt(0);
        try {
            if (this.jorb == 'B') {
                jb = 1;
            }
            if (this.jorb == 'J') {
                jb = 2;
            }
            if (jb > 0) {
                pos = 1;
            } else {
                this.jorb = (char)66;
            }
            this.equinox = Double.parseDouble(Equinox.substring(pos));
        }
        catch (NumberFormatException e) {
            throw new palError("Illegal Equinox: " + Equinox);
        }
        if (this.equinox < 1900.0 || this.equinox > 2100.0) {
            throw new palError("Equinox " + this.equinox + " out of range");
        }
    }

    public String[] calculate(String hms, String dms) throws palError {
        Vector v = this.calculateRV(hms, dms);
        int len = v.size();
        String[] s = new String[len];
        int i = 0;
        while (i < len) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public Vector calculateRV(String hms, String dms) throws palError {
        AngleDR r;
        double date = 0.0;
        double s = 0.0;
        double ss = 0.0;
        boolean p1 = false;
        this.Output = new Vector(10);
        String data = hms;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(4);
        nf.setGroupingUsed(false);
        try {
            StringTokenizer stok = new StringTokenizer(hms);
            if (stok.countTokens() != 3) {
                throw new palError("Not enough values in R.A., needs 3: ");
            }
            String str = stok.nextToken();
            boolean negr = str.indexOf(45) >= 0;
            int h = Integer.parseInt(str);
            int m = Integer.parseInt(stok.nextToken());
            s = Double.parseDouble(stok.nextToken());
            double rr = this.pal.Dtf2r(h, m, s);
            stok = new StringTokenizer(dms);
            data = dms;
            if (stok.countTokens() != 3) {
                throw new palError("Not enough values in Dec, needs 3: ");
            }
            str = stok.nextToken();
            boolean negd = str.indexOf(45) >= 0;
            int d = Integer.parseInt(str);
            int mm = Integer.parseInt(stok.nextToken());
            ss = Double.parseDouble(stok.nextToken());
            double dd = this.pal.Daf2r(Math.abs(d), mm, ss);
            if (negr) {
                rr = -rr;
            }
            if (negd) {
                dd = -dd;
            }
            r = new AngleDR(rr, dd);
        }
        catch (NumberFormatException e) {
            throw new palError("Illegal Number in: " + data);
        }
        catch (palError e) {
            throw new palError("Illegal value in data (" + e + ")");
        }
        double deltat = this.pal.Dtt(this.jdate) / 86400.0;
        double mid = this.jdate + deltat + (double)this.days / 2.0;
        AngleDR r2 = r;
        if (this.jorb == 'J') {
            r2 = this.pal.Preces("FK5", this.equinox, 2000.0, r2);
        } else {
            AngleDR rw = this.pal.Preces("FK4", this.equinox, 1950.0, r2);
            r2 = this.pal.Fk45z(rw, this.pal.Epj(mid));
        }
        double[] v2 = this.pal.Dcs2c(r2);
        double[] pm = new double[]{0.0, 0.0};
        Stardata sd = new Stardata(r2, pm, 0.0, 0.0);
        AngleDR ra = this.pal.Map(sd, 2000.0, mid);
        double da = ra.getDelta();
        double sind = Math.sin(da);
        double cosd = Math.cos(da);
        Galactic gl = this.pal.Eqgal(r2);
        AngleDR el = this.pal.Eqecl(r2, mid);
        double vclsrd = this.pal.Drvlsrd(r2);
        double vclsrk = this.pal.Drvlsrk(r2);
        double vcgalc = this.pal.Drvgalc(r2);
        double vclg = this.pal.Drvlg(r2);
        this.print(" Radial Component of observer's velocity\n");
        this.print(" Observatory:   " + this.obs);
        this.print(this.spaces(16) + this.obs.printPosition(1) + "\n");
        double jd = this.jdate + 2400000.5;
        this.print(" Starting UTC date:   " + this.year + "/" + nf.format(this.month) + "/" + nf.format(this.day) + "  =  JD " + jd + "\n");
        palTime sr = this.pal.Dr2tf(r.getAlpha());
        palTime srd = this.pal.Dr2af(r.getDelta());
        this.print(" Equatorial coordinates:   " + sr.toString(2) + "  " + srd.printSign() + srd.toString(1) + "   " + this.jorb + this.equinox);
        if (this.jorb != 'J' || this.equinox != 2000.0) {
            palTime sr2 = this.pal.Dr2tf(r2.getAlpha());
            palTime sd2 = this.pal.Dr2af(r2.getDelta());
            this.print(this.spaces(27) + sr2.toString(2) + "  " + sd2.printSign() + sd2.toString(1) + "   J2000.0");
        }
        palTime sra = this.pal.Dr2tf(ra.getAlpha());
        palTime sda = this.pal.Dr2af(ra.getDelta());
        this.print(this.spaces(27) + sra.toString(2) + "  " + sda.printSign() + sda.toString(1) + "   geocentric apparent\n");
        this.print(" Galactic coordinates:   L2 = " + this.format(gl.getLongitude() * 57.29577951308232, 8, 4) + "  B2 = " + this.formats(gl.getLatitude() * 57.29577951308232, 8, 4) + "\n");
        this.print(" Ecliptic coordinates:   L  = " + this.format(el.getAlpha() * 57.29577951308232, 8, 4) + "  B  = " + this.formats(el.getDelta() * 57.29577951308232, 8, 4) + "  (mean equinox of date)\n\n");
        this.print(this.spaces(7) + "UTC" + this.spaces(12) + "ZD     EARTH" + this.spaces(9) + "SUN" + this.spaces(12) + "LSR (K)   LSR (D)" + this.spaces(5) + "GALAXY    LOCAL GROUP\n");
        int i = 0;
        while (i < this.days) {
            mjDate iymdf;
            double djm1 = this.jdate + (double)i;
            try {
                iymdf = this.pal.Djcal(djm1);
            }
            catch (palError e) {
                this.printError("Date Error");
                return null;
            }
            int j = 0;
            while (j < 48) {
                double ut = djm1 + (double)j / 48.0;
                double w = this.obs.getLong();
                double p = this.obs.getLat();
                double st = this.pal.Gmst(ut) - w;
                double ha = st - ra.getAlpha();
                double cosp = Math.cos(p);
                double sinp = Math.sin(p);
                double cosz = sinp * sind + cosp * cosd * Math.cos(ha);
                double zd = 57.29577951308232 * Math.atan2(Math.sqrt(1.0 - Math.min(1.0, Math.pow(cosz, 2.0))), cosz);
                if (zd < 90.0) {
                    int nuth = j / 2;
                    int nutm = j != 2 * nuth ? 30 : 0;
                    double tdb = ut + deltat;
                    double[] dvb = new double[3];
                    double[] dpb = new double[3];
                    double[] dvh = new double[3];
                    double[] dph = new double[3];
                    this.pal.Evp(tdb, 2000.0, dvb, dpb, dvh, dph);
                    double vcrot = this.pal.Drverot(p, ra, st);
                    double vcorb = -this.pal.Dvdv(v2, dvh) * 1.4959787E8;
                    double rvtot2 = vcrot + vcorb;
                    double rvtot3 = rvtot2 + vclsrd;
                    double rvtot4 = rvtot3 + vcgalc;
                    double rvtot5 = rvtot2 + vclg;
                    double tl = -this.pal.Dvdv(v2, dph) * 499.004782;
                    this.print(" " + nf.format(iymdf.getYear()) + " " + nf.format(iymdf.getMonth()) + " " + nf.format(iymdf.getDay()) + " " + nf.format(nuth) + ":" + nf.format(nutm) + this.format(zd, 8, 1) + this.formats(vcrot, 9, 2) + this.formats(rvtot2, 10, 2) + " (" + this.formats(tl, 6, 1) + ") " + this.formats(rvtot2 + vclsrk, 10, 2) + this.formats(rvtot3, 10, 2) + this.formats(rvtot4, 12, 2) + this.formats(rvtot5, 13, 2));
                }
                ++j;
            }
            ++i;
        }
        this.Output.trimToSize();
        return this.Output;
    }

    private void print(String message) {
        this.Output.add(message);
    }

    private void printError(String message) {
        System.err.println(message);
    }

    private String format(double number, int fieldsize, int ndp) {
        return this.format(number, fieldsize, ndp, false);
    }

    private String formats(double number, int fieldsize, int ndp) {
        return this.format(number, fieldsize, ndp, true);
    }

    private String format(double number, int fieldsize, int ndp, boolean sign) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(ndp);
        nf.setMinimumFractionDigits(ndp);
        String num = nf.format(number);
        if (sign && number >= 0.0) {
            num = "+" + num;
        }
        if (num.length() < fieldsize) {
            num = this.spaces(fieldsize - num.length()).concat(num);
        }
        return num;
    }

    private String spaces(int num) {
        char[] sp = new char[num];
        int i = 0;
        while (i < num) {
            sp[i] = 32;
            ++i;
        }
        return new String(sp);
    }

    private void printDebug(String message) {
    }
}

