/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.pha.sdss.fits.imageio;

import edu.jhu.pha.sdss.fits.FITSImage;
import edu.jhu.pha.sdss.fits.SlowFITSImage;
import edu.jhu.pha.sdss.fits.imageio.ImageInputStreamInputStream;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import nom.tam.fits.Fits;

public class FITSReader
extends ImageReader {
    protected FITSImage _image;
    protected boolean _doneReading = false;
    protected final List _imageTypeSpecifiers = new ArrayList();

    public FITSReader(ImageReaderSpi originatingProvider, Object extensionObject) {
        super(originatingProvider);
    }

    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public Iterator getImageTypes(int imageIndex) {
        this.read(imageIndex, null);
        return this._imageTypeSpecifiers.iterator();
    }

    public int getNumImages(boolean allowSearch) {
        return this.read(0, null) == null ? 0 : 1;
    }

    public int getHeight(int imageIndex) {
        int result = 0;
        BufferedImage image = this.read(imageIndex, null);
        if (image != null) {
            result = image.getHeight();
        }
        return result;
    }

    public int getWidth(int imageIndex) {
        int result = 0;
        BufferedImage image = this.read(imageIndex, null);
        if (image != null) {
            result = image.getWidth();
        }
        return result;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) {
        FITSImage result = this.getImage();
        if (result == null && !this.doneReading()) {
            try {
                InputStream in = FITSReader.gunzipIfNecessary(new ImageInputStreamInputStream((ImageInputStream)this.getInput()));
                result = new SlowFITSImage(new Fits(in));
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
            this.setImage(result);
            this.setDoneReading(true);
            this._imageTypeSpecifiers.add(new ImageTypeSpecifier(this.getImage()));
        }
        return result;
    }

    public static InputStream gunzipIfNecessary(InputStream in) throws IOException {
        byte[] buf = new byte[2];
        in.mark(0);
        in.read(buf, 0, 2);
        in.reset();
        if (buf[0] == 31 && buf[1] == -117) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static String revision() {
        return "$Revision: 1.7 $";
    }

    protected FITSImage getImage() {
        return this._image;
    }

    protected void setImage(FITSImage image) {
        this._image = image;
    }

    protected boolean doneReading() {
        return this._doneReading;
    }

    protected void setDoneReading(boolean done) {
        this._doneReading = done;
    }
}

