/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import java.awt.Graphics2D;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.gui.BasicImageDisplay;
import jsky.image.gui.ImageGraphicsHandler;
import org.w3c.dom.Element;
import uk.ac.starlink.soap.AppHttpSOAPServer;
import uk.ac.starlink.soap.util.RemoteUtilities;
import uk.ac.starlink.sog.SOG;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;

public class SOGRemoteControl
implements ImageGraphicsHandler,
ChangeListener {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.sog.SOGRemoteControl");
    private AppHttpSOAPServer _server = null;
    private SOGNavigatorImageDisplay _imageDisplay = (SOGNavigatorImageDisplay)SOG.getInstance().getImageDisplay();
    private boolean _waitForImageDisplay = false;
    private int portNumber = 8082;
    private static SOGRemoteControl _instance = null;
    private String cookie = null;

    public static SOGRemoteControl getInstance() {
        if (_instance == null) {
            try {
                _instance = new SOGRemoteControl();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                _instance = null;
            }
        }
        return _instance;
    }

    private SOGRemoteControl() throws IOException {
        this._imageDisplay.addImageGraphicsHandler(this);
        this._imageDisplay.getImageProcessor().addChangeListener(this);
    }

    public void setPortNumber(int portNum) {
        this.portNumber = portNum;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void stateChanged(ChangeEvent e) {
        ImageChangeEvent ice = (ImageChangeEvent)e;
        if (ice.isNewCutLevels()) {
            this._imageDisplay.getImageProcessor().setUserSetCutLevels(true);
        }
    }

    public void drawImageGraphics(BasicImageDisplay imageDisplay, Graphics2D g) {
        this._waitForImageDisplay = false;
    }

    public void start() {
        URL deployURL = SOGRemoteControl.class.getResource("deploy.wsdd");
        try {
            this._server = new AppHttpSOAPServer(this.portNumber);
            this._server.start();
            this._server.addSOAPService(deployURL);
            this.portNumber = this._server.getPort();
            logger.warning("Remote services port '" + this.portNumber + "' opened");
            this.cookie = RemoteUtilities.writeContactFile((int)this.portNumber, (String)"sog");
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage(), e);
            throw new RuntimeException("Failed to start SoG SOAP services");
        }
    }

    public void stop() {
        if (this._server != null) {
            try {
                this._server.stop();
            }
            catch (Exception e) {
                logger.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    public String updateImage() {
        this._imageDisplay.updateImageData();
        this._waitForImageDisplay = true;
        return "";
    }

    public String updateImage(String cookie) {
        if (cookie != null && cookie.equals(this.cookie)) {
            this._imageDisplay.updateImageData();
            this._waitForImageDisplay = true;
        }
        logger.severe("Non-secure updateImage called");
        return "";
    }

    public String showImage(String fileOrURL) throws Exception {
        this._imageDisplay.setFilename(fileOrURL, false);
        this._waitForImageDisplay = true;
        return "";
    }

    public String showImage(String cookie, String fileOrURL) throws Exception {
        if (cookie != null && cookie.equals(this.cookie)) {
            this._imageDisplay.setFilename(fileOrURL, false);
            this._waitForImageDisplay = true;
        }
        logger.severe("Non-secure showImage called");
        return "";
    }

    public String showNDX(Element element) throws IOException {
        this._imageDisplay.setRemoteNDX(element);
        this._waitForImageDisplay = true;
        return "";
    }

    public String showNDX(String cookie, Element element) throws IOException {
        if (cookie != null && cookie.equals(this.cookie)) {
            this._imageDisplay.setRemoteNDX(element);
            this._waitForImageDisplay = true;
        }
        logger.severe("Non-secure showNDX called");
        return "";
    }

    public String wcsCenter() {
        if (!this._imageDisplay.isWCS()) {
            throw new IllegalArgumentException("Image does not support WCS");
        }
        WorldCoordinateConverter wcc = this._imageDisplay.getWCS();
        WorldCoords pos = new WorldCoords(wcc.getWCSCenter(), wcc.getEquinox());
        return pos.toString();
    }

    public String wcsCenter(String cookie) {
        if (cookie != null && cookie.equals(this.cookie)) {
            if (!this._imageDisplay.isWCS()) {
                throw new IllegalArgumentException("Image does not support WCS");
            }
            WorldCoordinateConverter wcc = this._imageDisplay.getWCS();
            WorldCoords pos = new WorldCoords(wcc.getWCSCenter(), wcc.getEquinox());
            return pos.toString();
        }
        logger.severe("Non-secure showNDX called");
        return "";
    }
}

