/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import uk.ac.starlink.jaiutil.HDXImage;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;

public class SOGTransferHandler
extends TransferHandler {
    public static final DataFlavor[] flavors = new DataFlavor[]{new DataFlavor("application/xml;class=java.io.InputStream", "NDX stream"), new DataFlavor("application/x-java-serialized-object;class=java.net.URL", "URL")};
    protected SOGNavigatorImageDisplay imageDisplay = null;

    public SOGTransferHandler(SOGNavigatorImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            int m = flavors.length;
            for (int j = 0; j < m; ++j) {
                if (!flavor[i].equals(flavors[j])) continue;
                return true;
            }
        }
        return false;
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor[] importFlavors = t.getTransferDataFlavors();
        for (int j = 0; j < importFlavors.length; ++j) {
            if (flavors[0].match(importFlavors[j])) {
                return this.importNDXStream(comp, t);
            }
            if (!flavors[1].match(importFlavors[j])) continue;
            return this.importURL(comp, t);
        }
        return false;
    }

    protected boolean importNDXStream(JComponent comp, Transferable t) {
        boolean added = false;
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)t.getTransferData(flavors[0]);
            StreamSource streamSource = new StreamSource(inputStream);
            HDXImage hdxImage = new HDXImage((Source)streamSource);
            this.imageDisplay.setHDXImage(hdxImage);
            added = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            inputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return added;
    }

    protected boolean importFITSStream(JComponent comp, Transferable t) {
        System.out.println("No Support for FITS streams");
        return false;
    }

    protected boolean importURL(JComponent comp, Transferable t) {
        boolean added = false;
        try {
            URL url = (URL)t.getTransferData(flavors[1]);
            this.imageDisplay.setFilename(url.toString());
            added = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return added;
    }
}

