/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import jsky.util.ProxyServerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.NdfMaker;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.XMLNdxHandler;
import uk.ac.starlink.soap.AppHttpSOAPServer;
import uk.ac.starlink.sog.photom.PhotomList;
import uk.ac.starlink.sog.photom.PhotometryGlobals;

public class PhotomWS {
    private AppHttpSOAPServer server = null;
    private int defaultPortNumber;
    private int portNumber = this.defaultPortNumber = 8083;
    private static PhotomWS instance = null;
    private static JLabel displayLabel = null;
    private static String idleString = "<html><h2><font color=red><strike>PHOTOM Web Service</strike></font></h2>";
    private static String busyString = "<html><h2><font color=green><u>PHOTOM Web Service</u></font></h2>";

    public static PhotomWS getInstance() {
        if (instance == null) {
            try {
                instance = new PhotomWS();
            }
            catch (IOException e) {
                e.printStackTrace();
                instance = null;
            }
        }
        ProxyServerUtil.init();
        return instance;
    }

    private PhotomWS() throws IOException {
        this.establishPortNumber();
    }

    protected void establishPortNumber() {
        String portString = System.getProperty("port.number");
        if (portString != null) {
            try {
                this.portNumber = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.portNumber = this.defaultPortNumber;
            }
        } else {
            this.portNumber = this.defaultPortNumber;
        }
    }

    public void setPortNumber(int value) {
        this.portNumber = value;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void start() {
        URL deployURL = PhotomWS.class.getResource("deploy.wsdd");
        System.out.println(deployURL);
        try {
            this.server = new AppHttpSOAPServer(this.portNumber);
            this.server.start();
            this.server.addSOAPService(deployURL);
            System.out.println("port = " + this.portNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to start SOAP services");
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element autophotom(Element ndxElement, Element photomListElement, Element globalsElement) throws IOException {
        System.out.println("Autophotom:" + ndxElement.getTagName() + ", " + photomListElement.getTagName());
        if (displayLabel != null) {
            displayLabel.setText(busyString);
        }
        try {
            Ndx ndx = XMLNdxHandler.getInstance().makeNdx(new DOMSource(ndxElement), AccessMode.READ);
            NdfMaker maker = new NdfMaker();
            HDSReference tmpNdf = maker.makeTempNDF(ndx);
            PhotomList photomList = new PhotomList();
            photomList.decode(photomListElement);
            File positionsFile = File.createTempFile("photom_in", ".lis");
            photomList.write(positionsFile);
            File resultsFile = File.createTempFile("photom_out", ".lis");
            PhotometryGlobals globals = new PhotometryGlobals();
            globals.decode(globalsElement);
            String extras = globals.toApplicationString();
            StringBuffer cmd = new StringBuffer();
            cmd.append("/stardev/bin/photom/autophotom");
            cmd.append(" in=" + tmpNdf.getContainerName());
            cmd.append(" infile=" + positionsFile.getPath());
            cmd.append(" outfile=" + resultsFile.getPath());
            cmd.append(" " + extras);
            cmd.append(" accept");
            Process process = Runtime.getRuntime().exec(cmd.toString());
            System.out.println("Starting wait...");
            int exitValue = 0;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
            positionsFile.delete();
            tmpNdf.getContainerFile().delete();
            if (exitValue != 0) {
                resultsFile.delete();
                throw new IOException("Process exited with non-zero status: " + exitValue);
            }
            System.out.println("Completed wait...");
            photomList.read(resultsFile);
            resultsFile.delete();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (Exception e) {
                throw new IOException("Error converting PhotomList to XML");
            }
            Document document = builder.newDocument();
            Element newPhotomListElement = document.createElement(photomList.getTagName());
            photomList.encode(newPhotomListElement);
            if (displayLabel != null) {
                displayLabel.setText(idleString);
            }
            Element element = newPhotomListElement;
            Object var21_22 = null;
            if (displayLabel != null) {
                displayLabel.setText(idleString);
            }
            return element;
        }
        catch (Throwable throwable) {
            block10: {
                Object var21_23 = null;
                if (displayLabel == null) break block10;
                displayLabel.setText(idleString);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autophotom(Element element, String positionsFile, String resultsFile) throws IOException {
        if (displayLabel != null) {
            displayLabel.setText(busyString);
        }
        try {
            System.out.println("Autophotom:" + element.getTagName());
            System.out.println("positions file: " + positionsFile);
            System.out.println("results file: " + resultsFile);
            Ndx ndx = XMLNdxHandler.getInstance().makeNdx(new DOMSource(element), AccessMode.READ);
            NdfMaker maker = new NdfMaker();
            HDSReference tmpNdf = maker.makeTempNDF(ndx);
            StringBuffer cmd = new StringBuffer();
            cmd.append("/stardev/bin/photom/autophotom");
            cmd.append(" in=" + tmpNdf.getContainerName());
            cmd.append(" infile=" + positionsFile);
            cmd.append(" outfile=" + resultsFile);
            cmd.append(" accept");
            Process process = Runtime.getRuntime().exec(cmd.toString());
            System.out.println("Starting wait...");
            int exitValue = 0;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
            tmpNdf.getContainerFile().delete();
            if (exitValue != 0) {
                throw new IOException("Process exited with non-zero status: " + exitValue);
            }
            System.out.println("Completed wait...");
            Object var12_11 = null;
            if (displayLabel != null) {
                displayLabel.setText(idleString);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (displayLabel != null) {
                displayLabel.setText(idleString);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("PHOTOM Web Service (Test)");
        PhotomWS soapServer = PhotomWS.getInstance();
        soapServer.start();
        displayLabel = new JLabel(idleString);
        frame.getContentPane().add(displayLabel);
        frame.pack();
        frame.setVisible(true);
    }
}

