/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.interactor.CircleManipulator;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.graphics.CanvasFigure;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.gui.DivaMainImageDisplay;
import uk.ac.starlink.sog.photom.AnnulusFigure;

public class SOGCanvasDraw
extends CanvasDraw {
    protected EventListenerList finishedList = new EventListenerList();
    public static final int ANNULAR_CIRCLE = NUM_DRAWING_MODES;

    public SOGCanvasDraw(DivaMainImageDisplay imageDisplay) {
        super(imageDisplay);
    }

    public void addFinishedListener(ChangeListener l) {
        this.finishedList.add(ChangeListener.class, l);
    }

    public void removeFinishedListener(ChangeListener l) {
        this.finishedList.remove(ChangeListener.class, l);
    }

    protected void fireFinished(ChangeEvent e) {
        Object[] listeners = this.finishedList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? SOGCanvasDraw.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    protected void finishFigure() {
        if (this.figure != null) {
            this.fireFinished(new ChangeEvent(this.figure));
        }
        super.finishFigure();
    }

    public AbstractAction getDrawingModeAction(int drawingMode) {
        if (drawingMode < this.drawingModeActions.length) {
            return super.getDrawingModeAction(drawingMode);
        }
        return new SOGDrawingModeAction(ANNULAR_CIRCLE);
    }

    public void mousePressed(MouseEvent e) {
        if (this.drawingMode == ANNULAR_CIRCLE) {
            this.startX = e.getX();
            this.startY = e.getY();
            SelectionInteractor interactor = this.graphics.getSelectionInteractor();
            CircleManipulator manipulator = new CircleManipulator();
            manipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(){

                public void mouseReleased(LayerEvent e) {
                    Figure fig = e.getFigureSource();
                    if (fig instanceof GrabHandle) {
                        fig = ((GrabHandle)fig).getSite().getFigure();
                        if ((fig = ((CircleManipulator)fig).getDecoratedFigure()) instanceof CanvasFigure) {
                            ((CanvasFigure)fig).fireCanvasFigureEvent(2);
                        }
                    }
                }
            });
            interactor.setPrototypeDecorator((FigureDecorator)manipulator);
            AnnulusFigure afigure = new AnnulusFigure(10.0, this.fill, this.outline, (float)this.lineWidth, (Interactor)interactor);
            afigure.setPosition(new Point2D.Double(this.startX, this.startY));
            this.figure = afigure;
            this.graphics.add((CanvasFigure)this.figure);
            this.figureList.add(this.figure);
        } else {
            super.mousePressed(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.drawingMode == ANNULAR_CIRCLE) {
            if (this.figure != null) {
                int radius = e.getX() - this.startX;
                ((AnnulusFigure)this.figure).setRadius(radius);
            }
        } else {
            super.mouseDragged(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.drawingMode == ANNULAR_CIRCLE) {
            this.finishFigure();
        } else {
            super.mouseReleased(e);
        }
    }

    public void removeFigure(CanvasFigure figure) {
        if (this.figureList.contains(figure)) {
            this.graphics.remove(figure);
            this.figureList.remove(figure);
        }
    }

    class SOGDrawingModeAction
    extends AbstractAction {
        int drawingMode;

        public SOGDrawingModeAction(int drawingMode) {
            super("annularcircle");
            this.drawingMode = drawingMode;
        }

        public void actionPerformed(ActionEvent evt) {
            SOGCanvasDraw.this.setDrawingMode(this.drawingMode);
        }
    }
}

