/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerDiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleDiagonalMatrix
extends DoubleTridiagonalMatrix {
    protected static final int DIAGONAL = 4;

    protected DoubleDiagonalMatrix(int n, int n2) {
        super(n, n2);
    }

    public DoubleDiagonalMatrix(int n) {
        this(n, 4);
        this.matrix = new double[1][n];
        this.diag = this.matrix[0];
    }

    public DoubleDiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        if (dArray.length == dArray[0].length) {
            int n = 0;
            while (n < this.numRows) {
                this.diag[n] = dArray[n][n];
                ++n;
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public DoubleDiagonalMatrix(double[] dArray) {
        this(dArray.length, 4);
        this.matrix = new double[1][];
        this.matrix[0] = dArray;
        this.diag = this.matrix[0];
    }

    public static DoubleDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            ++n2;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleDiagonalMatrix && this.numRows == ((DoubleDiagonalMatrix)object).rows()) {
            DoubleDiagonalMatrix doubleDiagonalMatrix = (DoubleDiagonalMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                if (Math.abs(this.diag[n] - doubleDiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public IntegerMatrix toIntegerMatrix() {
        int[] nArray = new int[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = Math.round((float)this.diag[n]);
            ++n;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        return new ComplexDiagonalMatrix(this.diag, new double[this.numRows]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diag[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diag[n] = d;
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(DoubleDiagonalMatrix.identity(this.numRows));
    }

    public double det() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d *= this.diag[n];
            ++n;
        }
        return d;
    }

    public double trace() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diag[n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            double d2 = Math.abs(this.diag[n]);
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d = ExtraMath.hypot(d, this.diag[n]);
            ++n;
        }
        return d;
    }

    public double operatorNorm() {
        return this.infNorm();
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(doubleMatrix.matrix[n], 0, dArray[n], 0, this.numRows);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numRows) {
                double[] dArray2 = dArray[n2];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + this.diag[n2];
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] + doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.udiag[0] = doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] + doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.udiag[n2] = doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] + doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawAddTridiagonal(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
            System.arraycopy(doubleMatrix.matrix[0], 0, doubleTridiagonalMatrix.ldiag, 0, doubleMatrix.matrix[0].length);
            System.arraycopy(doubleMatrix.matrix[2], 0, doubleTridiagonalMatrix.udiag, 0, doubleMatrix.matrix[2].length);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] + doubleMatrix.matrix[1][0];
            int n = 1;
            while (n < this.numRows) {
                doubleTridiagonalMatrix.diag[n] = this.diag[n] + doubleMatrix.matrix[1][n];
                ++n;
            }
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawAddDiagonal(doubleDiagonalMatrix);
    }

    private DoubleDiagonalMatrix rawAddDiagonal(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] + doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] + doubleMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = -doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = -doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = -doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = -doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = -doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = -doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.diag[n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] - doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.udiag[0] = -doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = -doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] - doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.udiag[n2] = -doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = -doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] - doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawSubtractTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (n == doubleMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] - doubleMatrix.matrix[1][0];
            doubleTridiagonalMatrix.udiag[0] = -doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = -doubleMatrix.matrix[0][n2];
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] - doubleMatrix.matrix[1][n2];
                doubleTridiagonalMatrix.udiag[n2] = -doubleMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = -doubleMatrix.matrix[0][n];
            doubleTridiagonalMatrix.diag[n] = this.diag[n] - doubleMatrix.matrix[1][n];
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawSubtractDiagonal(doubleDiagonalMatrix);
    }

    private DoubleDiagonalMatrix rawSubtractDiagonal(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] - doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] - doubleMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.numRows];
        dArray[0] = d * this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = d * this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
            case 3: {
                return this.rawScalarProductTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawScalarProductDiagonal(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double d = this.diag[0] * doubleMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = this.diag[0] * doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleMatrix.matrix[n][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleSquareMatrix);
            }
            case 3: {
                return this.rawScalarProductTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawScalarProductDiagonal(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double d = this.diag[0] * doubleSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleSquareMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawScalarProductTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawScalarProductDiagonal(doubleTridiagonalMatrix);
            }
        }
        if (this.numRows == doubleTridiagonalMatrix.rows()) {
            double d = this.diag[0] * doubleTridiagonalMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleTridiagonalMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProductTridiagonal(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows) {
            double d = this.diag[0] * doubleMatrix.matrix[1][0];
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleMatrix.matrix[1][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawScalarProductDiagonal(doubleDiagonalMatrix);
    }

    private double rawScalarProductDiagonal(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows) {
            double d = this.diag[0] * doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                d += this.diag[n] * doubleMatrix.matrix[0][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.numCols == doubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * doubleVector.getComponent(0);
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] * doubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(doubleMatrix);
            }
        }
        if (this.numCols == doubleMatrix.rows()) {
            double[][] dArray = new double[this.numRows][doubleMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diag[n] * doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < doubleMatrix.columns()) {
                    dArray[n][n2] = this.diag[n] * doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diag[n] * doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.diag[n] * doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(doubleSquareMatrix);
            }
        }
        if (this.numCols == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diag[n] * doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.diag[n] * doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diag[n] * doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.diag[n] * doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] * doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.udiag[0] = this.diag[0] * doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.udiag[n2] = this.diag[n2] * doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.diag[n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] * doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiplyTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.numRows;
        if (n == doubleMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] * doubleMatrix.matrix[1][0];
            doubleTridiagonalMatrix.udiag[0] = this.diag[0] * doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = this.diag[n2] * doubleMatrix.matrix[0][n2];
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] * doubleMatrix.matrix[1][n2];
                doubleTridiagonalMatrix.udiag[n2] = this.diag[n2] * doubleMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = this.diag[n] * doubleMatrix.matrix[0][n];
            doubleTridiagonalMatrix.diag[n] = this.diag[n] * doubleMatrix.matrix[1][n];
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawMultiplyDiagonal(doubleDiagonalMatrix);
    }

    private DoubleDiagonalMatrix rawMultiplyDiagonal(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diag[n] * doubleMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        dArray[0] = 1.0 / this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = 1.0 / this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public Matrix transpose() {
        return this;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        this.LU = new DoubleDiagonalMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.numRows];
        dArray[0] = Math.sqrt(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = Math.sqrt(this.diag[n]);
            ++n;
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] singularValueDecompose() {
        int n = this.numRows;
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = -1.0;
            dArray2[n3] = Math.abs(this.diag[n3]);
            dArray3[n3] = this.diag[n3] < 0.0 ? 1.0 : -1.0;
            ++n3;
        }
        dArray[n2] = 1.0;
        dArray2[n2] = Math.abs(this.diag[n2]);
        dArray3[n2] = this.diag[n2] < 0.0 ? -1.0 : 1.0;
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleDiagonalMatrix(dArray), new DoubleDiagonalMatrix(dArray2), new DoubleDiagonalMatrix(dArray3)};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[] dArray = new double[this.numRows];
        dArray[0] = mapping.map(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = mapping.map(this.diag[n]);
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }
}

