/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.MathDouble;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialMath;
import JSci.maths.polynomials.RealPolynomialRing;

public class RealPolynomial
implements Polynomial {
    private double[] _c;

    public RealPolynomial(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        this._c = dArray.length == 0 ? new double[]{0.0} : dArray;
    }

    public RealPolynomial(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        if (memberArray.length == 0) {
            this._c = new double[]{0.0};
        } else {
            this._c = new double[memberArray.length];
            int n = 0;
            while (n < this._c.length) {
                if (!(memberArray[n] instanceof MathDouble)) {
                    throw new IllegalArgumentException("Different fields. Argument was " + memberArray[n]);
                }
                this._c[n] = ((MathDouble)memberArray[n]).value();
                ++n;
            }
        }
    }

    public Field.Member getCoefficient(int n) {
        return new MathDouble(this.getCoefficientAsDouble(n));
    }

    public double getCoefficientAsDouble(int n) {
        if (n >= this._c.length) {
            return 0.0;
        }
        return this._c[n];
    }

    public Field.Member[] getCoefficients() {
        return RealPolynomialRing.toMathDouble(this.getCoefficientsAsDoubles());
    }

    public double[] getCoefficientsAsDoubles() {
        return this._c;
    }

    public int degree() {
        return this._c.length;
    }

    public boolean isNull() {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.degree()) {
            if (Math.abs(this.getCoefficientAsDouble(n)) > 1.0E-15) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isOne() {
        boolean bl = Math.abs(this.getCoefficientAsDouble(0) - 1.0) <= 1.0E-15;
        int n = 1;
        while (bl && n < this.degree()) {
            if (Math.abs(this.getCoefficientAsDouble(n)) > 1.0E-15) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        double[] dArray;
        RealPolynomial realPolynomial = null;
        if (member instanceof RealPolynomial) {
            RealPolynomial realPolynomial2 = (RealPolynomial)member;
            int n = PolynomialMath.maxDegree(this, realPolynomial2);
            dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = this.getCoefficientAsDouble(n2) + realPolynomial2.getCoefficientAsDouble(n2);
                ++n2;
            }
        } else {
            throw new UnsupportedOperationException();
        }
        realPolynomial = new RealPolynomial(dArray);
        return realPolynomial;
    }

    public RealPolynomial differentiate() {
        if (this.degree() == 1) {
            return (RealPolynomial)RealPolynomialRing.getInstance().zero();
        }
        double[] dArray = new double[this.degree() - 1];
        int n = 1;
        while (n < this.degree()) {
            dArray[n - 1] = this.getCoefficientAsDouble(n) * (double)n;
            ++n;
        }
        return new RealPolynomial(dArray);
    }

    public Polynomial divide(Field.Member member) {
        if (member instanceof MathDouble) {
            double d = ((MathDouble)member).value();
            return this.divide(d);
        }
        throw new UnsupportedOperationException();
    }

    public RealPolynomial divide(double d) {
        double[] dArray = new double[this._c.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this._c[n] / d;
            ++n;
        }
        return new RealPolynomial(dArray);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == this) {
            bl = true;
        } else if (object instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)object;
            return ((RealPolynomial)this.subtract(realPolynomial)).isNull();
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.degree()) {
            n += (int)(this.getCoefficientAsDouble(n2) * 10.0);
            ++n2;
        }
        return n;
    }

    public RealPolynomial integrate() {
        double[] dArray = new double[this.degree() + 1];
        int n = 0;
        while (n < this.degree()) {
            dArray[n + 1] = this.getCoefficientAsDouble(n) / (double)(n + 1);
            ++n;
        }
        return new RealPolynomial(dArray);
    }

    public Polynomial multiply(Field.Member member) {
        if (member instanceof MathDouble) {
            double d = ((MathDouble)member).value();
            return this.multiply(d);
        }
        throw new UnsupportedOperationException();
    }

    public RealPolynomial multiply(double d) {
        double[] dArray = new double[this._c.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this._c[n] * d;
            ++n;
        }
        return new RealPolynomial(dArray);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)member;
            int n = PolynomialMath.maxDegree(this, realPolynomial);
            int n2 = PolynomialMath.minDegree(this, realPolynomial);
            int n3 = n + n2 - 1;
            double[] dArray = new double[n3];
            int n4 = 0;
            while (n4 < this.degree()) {
                double d = this.getCoefficientAsDouble(n4);
                int n5 = 0;
                while (n5 < realPolynomial.degree()) {
                    double d2 = realPolynomial.getCoefficientAsDouble(n5);
                    int n6 = n4 + n5;
                    dArray[n6] = dArray[n6] + d * d2;
                    ++n5;
                }
                ++n4;
            }
            return new RealPolynomial(dArray);
        }
        throw new UnsupportedOperationException();
    }

    public AbelianGroup.Member negate() {
        double[] dArray = new double[this._c.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = -this._c[n];
            ++n;
        }
        return new RealPolynomial(dArray);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        double[] dArray;
        RealPolynomial realPolynomial = null;
        if (member instanceof RealPolynomial) {
            RealPolynomial realPolynomial2 = (RealPolynomial)member;
            int n = PolynomialMath.maxDegree(this, realPolynomial2);
            dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = this.getCoefficientAsDouble(n2) - realPolynomial2.getCoefficientAsDouble(n2);
                ++n2;
            }
        } else {
            throw new UnsupportedOperationException();
        }
        realPolynomial = new RealPolynomial(dArray);
        return realPolynomial;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("P(x) = ");
        if (this._c[this.degree() - 1] < 0.0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append(" ");
        }
        int n = this.degree();
        while (n > 1) {
            stringBuffer.append(Math.abs(this._c[n - 1])).append("x^").append(n - 1).append(this._c[n - 2] >= 0.0 ? " + " : " - ");
            --n;
        }
        stringBuffer.append(this._c[0]);
        return stringBuffer.toString();
    }
}

