/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Hour
extends TimePeriod {
    private static int FIRST_HOUR_IN_DAY = 0;
    private static int LAST_HOUR_IN_DAY = 23;
    protected Day day;
    protected int hour;

    public Hour() {
        this(new Date());
    }

    public Hour(int n, Day day) {
        this.hour = n;
        this.day = day;
    }

    public Hour(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Hour(Date date, TimeZone timeZone) {
        int n;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.hour = n = calendar.get(11);
        this.day = new Day(date, timeZone);
    }

    public int getHour() {
        return this.hour;
    }

    public Day getDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDayOfMonth() {
        return this.day.getDayOfMonth();
    }

    public TimePeriod previous() {
        Day day;
        Hour hour = this.hour != FIRST_HOUR_IN_DAY ? new Hour(this.hour - 1, this.day) : ((day = (Day)this.day.previous()) != null ? new Hour(LAST_HOUR_IN_DAY, day) : null);
        return hour;
    }

    public TimePeriod next() {
        Day day;
        Hour hour = this.hour != LAST_HOUR_IN_DAY ? new Hour(this.hour + 1, this.day) : ((day = (Day)this.day.next()) != null ? new Hour(FIRST_HOUR_IN_DAY, day) : null);
        return hour;
    }

    public boolean equals(Object object) {
        if (object instanceof Hour) {
            Hour hour = (Hour)object;
            return this.hour == hour.getHour() && this.day.equals(hour.getDay());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Hour) {
            Hour hour = (Hour)object;
            n = this.getDay().compareTo(hour.getDay());
            if (n == 0) {
                n = this.hour - hour.getHour();
            }
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getStart(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.set(n, n2, n3, this.hour, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEnd(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.set(n, n2, n3, this.hour, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Hour parseHour(String string) {
        Hour hour = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            String string3 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            int n = Integer.parseInt(string3 = string3.trim());
            if (n >= FIRST_HOUR_IN_DAY && n <= LAST_HOUR_IN_DAY) {
                hour = new Hour(n, day);
            }
        }
        return hour;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = TimeZone.getAvailableIDs();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        TimeZone timeZone = TimeZone.getTimeZone("Australia/Sydney");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(2002, 1, 21, 16, 0, 0);
        System.out.println("4pm on 21-Mar-2002 in Australia/Sydney: " + gregorianCalendar.getTime().getTime());
        Date date = new Date(1014307200000L);
        gregorianCalendar.setTime(date);
        Hour hour = new Hour(date);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(timeZone));
        System.out.println("End = " + hour.getEnd(timeZone));
        System.out.println("Offset = " + timeZone.getRawOffset());
    }
}

