/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.Hour;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Minute
extends TimePeriod {
    private static int FIRST_MINUTE_IN_HOUR = 0;
    private static int LAST_MINUTE_IN_HOUR = 59;
    private static long MILLISECONDS_PER_MINUTE = 60000L;
    protected Hour hour;
    int minute;

    public Minute() {
        this(new Date());
    }

    public Minute(int n, Hour hour) {
        this.minute = n;
        this.hour = hour;
    }

    public Minute(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Minute(Date date, TimeZone timeZone) {
        int n;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.minute = n = calendar.get(12);
        this.hour = new Hour(date, timeZone);
    }

    public Hour getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public TimePeriod previous() {
        Hour hour;
        Minute minute = this.minute != FIRST_MINUTE_IN_HOUR ? new Minute(this.minute - 1, this.hour) : ((hour = (Hour)this.hour.previous()) != null ? new Minute(LAST_MINUTE_IN_HOUR, hour) : null);
        return minute;
    }

    public TimePeriod next() {
        Hour hour;
        Minute minute = this.minute != LAST_MINUTE_IN_HOUR ? new Minute(this.minute + 1, this.hour) : ((hour = (Hour)this.hour.next()) != null ? new Minute(FIRST_MINUTE_IN_HOUR, hour) : null);
        return minute;
    }

    public boolean equals(Object object) {
        if (object instanceof Minute) {
            Minute minute = (Minute)object;
            return this.minute == minute.getMinute() && this.hour.equals(minute.getHour());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Minute) {
            Minute minute = (Minute)object;
            n = this.getHour().compareTo(minute.getHour());
            if (n == 0) {
                n = this.minute - minute.getMinute();
            }
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getStart(Calendar calendar) {
        int n = this.hour.day.getYear();
        int n2 = this.hour.day.getMonth() - 1;
        int n3 = this.hour.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour.getHour(), this.minute, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEnd(Calendar calendar) {
        int n = this.hour.day.getYear();
        int n2 = this.hour.day.getMonth() - 1;
        int n3 = this.hour.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour.getHour(), this.minute, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Minute parseMinute(String string) {
        Minute minute = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            String string3;
            int n;
            String string4 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            String string5 = (string4 = string4.trim()).substring(0, Math.min(2, string4.length()));
            int n2 = Integer.parseInt(string5);
            if (n2 >= 0 && n2 <= 23 && (n = Integer.parseInt(string3 = string4.substring(Math.min(string5.length() + 1, string4.length()), string4.length()))) >= 0 && n <= 59) {
                minute = new Minute(n, new Hour(n2, day));
            }
        }
        return minute;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = TimeZone.getAvailableIDs();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(2002, 2, 21, 16, 55, 0);
        System.out.println("4.55pm on 21-Mar-2002 in GMT: " + gregorianCalendar.getTime().getTime());
        Date date = new Date(1014307200000L);
        gregorianCalendar.setTime(date);
        Hour hour = new Hour(date);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(timeZone));
        System.out.println("End = " + hour.getEnd(timeZone));
        System.out.println("Offset = " + timeZone.getRawOffset());
    }
}

