/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Series;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.XYDataPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XYSeries
extends Series {
    protected List data = new ArrayList();

    public XYSeries(String string) {
        super(string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void add(XYDataPair xYDataPair) throws SeriesException {
        if (xYDataPair == null) {
            throw new IllegalArgumentException("XYSeries.add(...): null item not allowed.");
        }
        int n = Collections.binarySearch(this.data, xYDataPair);
        if (n >= 0) {
            throw new SeriesException("XYSeries.add(...): x-value already exists.");
        }
        this.data.add(-n - 1, xYDataPair);
        this.fireSeriesChanged();
    }

    public void add(double d, double d2) throws SeriesException {
        this.add(new Double(d), new Double(d2));
    }

    public void add(Number number, Number number2) throws SeriesException {
        XYDataPair xYDataPair = new XYDataPair(number, number2);
        this.add(xYDataPair);
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataPair getDataPair(int n) {
        return (XYDataPair)this.data.get(n);
    }

    public Number getXValue(int n) {
        return this.getDataPair(n).getX();
    }

    public Number getYValue(int n) {
        return this.getDataPair(n).getY();
    }

    public void update(int n, Number number) {
        XYDataPair xYDataPair = this.getDataPair(n);
        xYDataPair.setY(number);
        this.fireSeriesChanged();
    }
}

