/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.date;

import com.jrefinery.date.SerialDate;
import java.util.Calendar;
import java.util.Date;

public class SpreadsheetDate
extends SerialDate {
    protected int serial;
    protected int day;
    protected int month;
    protected int year;
    protected String description;

    public SpreadsheetDate(int n, int n2, int n3) {
        if (n3 < 1900 || n3 > 9999) {
            throw new IllegalArgumentException("SpreadsheetDate: Year must be in range 1900 to 9999.");
        }
        this.year = n3;
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("SpreadsheetDate: Invalid month.");
        }
        this.month = n2;
        if (n < 1 || n > SerialDate.lastDayOfMonth(n2, n3)) {
            throw new IllegalArgumentException("SpreadsheetDate: Invalid day.");
        }
        this.day = n;
        this.serial = this.calcSerial(n, n2, n3);
        this.description = null;
    }

    public SpreadsheetDate(int n) {
        if (n < SerialDate.SERIAL_LOWER_BOUND || n > SerialDate.SERIAL_UPPER_BOUND) {
            throw new IllegalArgumentException("SpreadsheetDate: Serial must be in range 2 to 2958465.");
        }
        this.serial = n;
        this.calcDayMonthYear();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int toSerial() {
        return this.serial;
    }

    public Date toDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYYYY(), this.getMonth() - 1, this.getDayOfMonth(), 0, 0, 0);
        return calendar.getTime();
    }

    public int getYYYY() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfWeek() {
        return (this.serial + 6) % 7 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof SerialDate) {
            SerialDate serialDate = (SerialDate)object;
            return serialDate.toSerial() == this.toSerial();
        }
        return false;
    }

    public int compare(SerialDate serialDate) {
        return this.serial - serialDate.toSerial();
    }

    public boolean isOn(SerialDate serialDate) {
        return this.serial == serialDate.toSerial();
    }

    public boolean isBefore(SerialDate serialDate) {
        return this.serial < serialDate.toSerial();
    }

    public boolean isOnOrBefore(SerialDate serialDate) {
        return this.serial <= serialDate.toSerial();
    }

    public boolean isAfter(SerialDate serialDate) {
        return this.serial > serialDate.toSerial();
    }

    public boolean isOnOrAfter(SerialDate serialDate) {
        return this.serial >= serialDate.toSerial();
    }

    public boolean isInRange(SerialDate serialDate, SerialDate serialDate2) {
        return false;
    }

    public boolean isInRange(SerialDate serialDate, SerialDate serialDate2, int n) {
        return false;
    }

    private int calcSerial(int n, int n2, int n3) {
        int n4 = (n3 - 1900) * 365 + SerialDate.leapYearCount(n3 - 1);
        int n5 = SerialDate.AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH[n2];
        if (n2 > 2 && SerialDate.isLeapYear(n3)) {
            ++n5;
        }
        int n6 = n;
        return n4 + n5 + n6 + 1;
    }

    private void calcDayMonthYear() {
        int n;
        int n2 = this.serial - SerialDate.SERIAL_LOWER_BOUND;
        int n3 = 1900 + n2 / 365;
        int n4 = SerialDate.leapYearCount(n3);
        int n5 = n2 - n4;
        int n6 = 1900 + n5 / 365;
        if (n6 == n3) {
            this.year = n6;
        } else {
            n = this.calcSerial(1, 1, n6);
            while (n <= this.serial) {
                n = this.calcSerial(1, 1, ++n6);
            }
            this.year = n6 - 1;
        }
        n = this.calcSerial(1, 1, this.year);
        int[] nArray = SerialDate.AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
        if (SerialDate.isLeapYear(this.year)) {
            nArray = SerialDate.LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
        }
        int n7 = 1;
        int n8 = n + nArray[n7] - 1;
        while (n8 < this.serial) {
            n8 = n + nArray[++n7] - 1;
        }
        this.month = n7 - 1;
        this.day = this.serial - n - nArray[this.month] + 1;
    }

    public static void main(String[] stringArray) {
        SerialDate serialDate = SerialDate.createInstance(1, 2, 2000);
        while (true) {
            System.out.println("Date = " + serialDate.toString());
            serialDate = SerialDate.addDays(1, serialDate);
        }
    }
}

