/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.regexp.Regexp;

public class ReplaceRegExp
extends Task {
    private File file = null;
    private String flags = "";
    private boolean byline = false;
    private Vector filesets = new Vector();
    private RegularExpression regex = null;
    private Substitution subs = null;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String encoding = null;

    public void setFile(File file) {
        this.file = file;
    }

    public void setMatch(String match) {
        if (this.regex != null) {
            throw new BuildException("Only one regular expression is allowed");
        }
        this.regex = new RegularExpression();
        this.regex.setPattern(match);
    }

    public void setReplace(String replace) {
        if (this.subs != null) {
            throw new BuildException("Only one substitution expression is allowed");
        }
        this.subs = new Substitution();
        this.subs.setExpression(replace);
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public void setByLine(String byline) {
        Boolean res = Boolean.valueOf(byline);
        if (res == null) {
            res = Boolean.FALSE;
        }
        this.byline = res;
    }

    public void setByLine(boolean byline) {
        this.byline = byline;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public RegularExpression createRegexp() {
        if (this.regex != null) {
            throw new BuildException("Only one regular expression is allowed.");
        }
        this.regex = new RegularExpression();
        return this.regex;
    }

    public Substitution createSubstitution() {
        if (this.subs != null) {
            throw new BuildException("Only one substitution expression is allowed");
        }
        this.subs = new Substitution();
        return this.subs;
    }

    protected String doReplace(RegularExpression r, Substitution s, String input, int options) {
        String res = input;
        Regexp regexp = r.getRegexp(this.getProject());
        if (regexp.matches(input, options)) {
            this.log("Found match; substituting", 4);
            res = regexp.substitute(input, s.getExpression(this.getProject()), options);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReplace(File f, int options) throws IOException {
        File temp = FILE_UTILS.createTempFile("replace", ".txt", null);
        temp.deleteOnExit();
        InputStreamReader r = null;
        OutputStreamWriter w = null;
        try {
            if (this.encoding == null) {
                r = new FileReader(f);
                w = new FileWriter(temp);
            } else {
                r = new InputStreamReader((InputStream)new FileInputStream(f), this.encoding);
                w = new OutputStreamWriter((OutputStream)new FileOutputStream(temp), this.encoding);
            }
            BufferedReader br = new BufferedReader(r);
            BufferedWriter bw = new BufferedWriter(w);
            PrintWriter pw = new PrintWriter(bw);
            boolean changes = false;
            this.log("Replacing pattern '" + this.regex.getPattern(this.getProject()) + "' with '" + this.subs.getExpression(this.getProject()) + "' in '" + f.getPath() + "'" + (this.byline ? " by line" : "") + (this.flags.length() > 0 ? " with flags: '" + this.flags + "'" : "") + ".", 3);
            if (this.byline) {
                int c;
                StringBuffer linebuf = new StringBuffer();
                String line = null;
                String res = null;
                boolean hasCR = false;
                do {
                    if ((c = br.read()) == 13) {
                        if (hasCR) {
                            line = linebuf.toString();
                            res = this.doReplace(this.regex, this.subs, line, options);
                            if (!res.equals(line)) {
                                changes = true;
                            }
                            pw.print(res);
                            pw.print('\r');
                            linebuf = new StringBuffer();
                            continue;
                        }
                        hasCR = true;
                        continue;
                    }
                    if (c == 10) {
                        line = linebuf.toString();
                        res = this.doReplace(this.regex, this.subs, line, options);
                        if (!res.equals(line)) {
                            changes = true;
                        }
                        pw.print(res);
                        if (hasCR) {
                            pw.print('\r');
                            hasCR = false;
                        }
                        pw.print('\n');
                        linebuf = new StringBuffer();
                        continue;
                    }
                    if (hasCR || c < 0) {
                        line = linebuf.toString();
                        res = this.doReplace(this.regex, this.subs, line, options);
                        if (!res.equals(line)) {
                            changes = true;
                        }
                        pw.print(res);
                        if (hasCR) {
                            pw.print('\r');
                            hasCR = false;
                        }
                        linebuf = new StringBuffer();
                    }
                    if (c < 0) continue;
                    linebuf.append((char)c);
                } while (c >= 0);
                pw.flush();
            } else {
                String res;
                String buf = FileUtils.readFully((Reader)br);
                if (buf == null) {
                    buf = "";
                }
                if (!(res = this.doReplace(this.regex, this.subs, buf, options)).equals(buf)) {
                    changes = true;
                }
                pw.print(res);
                pw.flush();
            }
            ((Reader)r).close();
            r = null;
            ((Writer)w).close();
            w = null;
            if (changes) {
                this.log("File has changed; saving the updated file", 3);
                try {
                    FILE_UTILS.rename(temp, f);
                    temp = null;
                }
                catch (IOException e) {
                    throw new BuildException("Couldn't rename temporary file " + temp, this.getLocation());
                }
            } else {
                this.log("No change made", 4);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            FileUtils.close(r);
            FileUtils.close(w);
            if (temp != null) {
                temp.delete();
            }
            throw throwable;
        }
        FileUtils.close((Reader)r);
        FileUtils.close((Writer)w);
        if (temp != null) {
            temp.delete();
        }
    }

    public void execute() throws BuildException {
        if (this.regex == null) {
            throw new BuildException("No expression to match.");
        }
        if (this.subs == null) {
            throw new BuildException("Nothing to replace expression with.");
        }
        if (this.file != null && this.filesets.size() > 0) {
            throw new BuildException("You cannot supply the 'file' attribute and filesets at the same time.");
        }
        int options = 0;
        if (this.flags.indexOf(103) != -1) {
            options |= 0x10;
        }
        if (this.flags.indexOf(105) != -1) {
            options |= 0x100;
        }
        if (this.flags.indexOf(109) != -1) {
            options |= 0x1000;
        }
        if (this.flags.indexOf(115) != -1) {
            options |= 0x10000;
        }
        if (this.file != null && this.file.exists()) {
            try {
                this.doReplace(this.file, options);
            }
            catch (IOException e) {
                this.log("An error occurred processing file: '" + this.file.getAbsolutePath() + "': " + e.toString(), 0);
            }
        } else if (this.file != null) {
            this.log("The following file is missing: '" + this.file.getAbsolutePath() + "'", 0);
        }
        int sz = this.filesets.size();
        for (int i = 0; i < sz; ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                File f = new File(fs.getDir(this.getProject()), files[j]);
                if (f.exists()) {
                    try {
                        this.doReplace(f, options);
                    }
                    catch (Exception e) {
                        this.log("An error occurred processing file: '" + f.getAbsolutePath() + "': " + e.toString(), 0);
                    }
                    continue;
                }
                this.log("The following file is missing: '" + f.getAbsolutePath() + "'", 0);
            }
        }
    }
}

