/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.util.gui.VRangeSlider;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.datanode.viewers.TreeviewLAF;
import uk.ac.starlink.treeview.CollapseArrayImpl;
import uk.ac.starlink.treeview.ImageViewer;

public class CollapseViewer
extends JPanel {
    private NDArray nda;
    private JComponent image;
    private OrderedNDShape shape;
    private long[] origin;
    private long[] dims;
    private int collAxis = -1;
    private long collOrigin;
    private long collDim;
    private JComboBox selecter;
    private VRangeSlider rangeSlider;
    private JLabel rangeLabel = new JLabel();

    public CollapseViewer(NDArray nda, FrameSet wcs) throws IOException {
        super(new BorderLayout());
        this.nda = nda;
        this.shape = nda.getShape();
        this.origin = this.shape.getOrigin();
        this.dims = this.shape.getDims();
        int ndim = this.shape.getNumDims();
        Box controlBox = new Box(1);
        String[] axisNames = new String[ndim];
        for (int i = 0; i < ndim; ++i) {
            axisNames[i] = "Axis " + i + ": " + this.shape.getOrigin()[i] + "+" + this.shape.getDims()[i];
        }
        this.selecter = new JComboBox<String>(axisNames);
        this.selecter.setSelectedIndex(ndim - 1);
        this.selecter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    CollapseViewer.this.updateDisplay();
                }
            }
        });
        Box selecterBox = new Box(0);
        selecterBox.add(new JLabel("Axis to collapse: "));
        selecterBox.add(this.selecter);
        selecterBox.add(Box.createGlue());
        TreeviewLAF.configureControl(selecterBox);
        this.rangeSlider = new VRangeSlider(null, 0.0, 1.0);
        this.rangeSlider.setPreferredSize(new Dimension(50, 38));
        this.rangeSlider.setDrawLabels(false);
        this.rangeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CollapseViewer.this.updateDisplay();
            }
        });
        Box rangeBox = new Box(0);
        rangeBox.add(new JLabel("Range to average over: "));
        rangeBox.add(this.rangeSlider);
        rangeBox.add(this.rangeLabel);
        controlBox.add(selecterBox);
        controlBox.add(rangeBox);
        if (controlBox.getComponentCount() > 0) {
            TreeviewLAF.configureControlPanel(controlBox);
            this.add((Component)controlBox, "North");
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        int ca = this.selecter.getSelectedIndex();
        if (ca != this.collAxis) {
            this.collAxis = ca;
            this.collDim = -1L;
            double lo = (double)this.origin[this.collAxis] - 0.5;
            double hi = lo + (double)this.dims[this.collAxis];
            this.rangeSlider.setBounds(lo, hi);
            this.rangeSlider.setValues(lo, hi);
        }
        double[] range = this.rangeSlider.getMinMaxValues();
        long co = Math.round(range[0] + 0.5);
        co = Math.max(co, this.origin[this.collAxis]);
        co = Math.min(co, this.origin[this.collAxis] + this.dims[this.collAxis] - 1L);
        long cd = Math.round(range[1] - range[0]);
        cd = Math.max(cd, 1L);
        cd = Math.min(cd, this.dims[this.collAxis] - (co - this.origin[this.collAxis]));
        this.rangeSlider.setValues(-0.5 + (double)co, -0.5 + (double)(co + cd));
        if (co != this.collOrigin || cd != this.collDim) {
            this.collOrigin = co;
            this.collDim = cd;
        }
        this.rangeLabel.setText("  " + this.collOrigin + "+" + this.collDim + "   ");
        CollapseArrayImpl aimpl = new CollapseArrayImpl(this.nda, this.collAxis, this.collOrigin, this.collDim);
        try {
            this.setArray((NDArray)new BridgeNDArray((ArrayImpl)aimpl), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setArray(NDArray nda, FrameSet wcs) throws IOException {
        if (this.image != null) {
            this.remove(this.image);
        }
        this.image = new ImageViewer(nda, wcs);
        this.add((Component)this.image, "Center");
    }
}

