/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.File;
import java.util.Iterator;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.FileDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.treeview.ApplicationDetailViewer;
import uk.ac.starlink.treeview.HTMLDocComponentMaker;

public class DemoDataNode
extends FileDataNode {
    public static final String DEMO_DIR_PROPERTY = "uk.ac.starlink.treeview.demodir";
    private String name = "Demonstration data";
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NdxDataNode;

    public DemoDataNode() throws NoSuchDataException {
        super(DemoDataNode.getDemoDir());
        this.setLabel(this.name);
        this.setCreator(new CreationState(null, null));
        this.setIconID((short)4);
    }

    public String getName() {
        return this.name;
    }

    public String getPathElement() {
        return "[DemoData]";
    }

    public String getPathSeparator() {
        return ":";
    }

    public Object getParentObject() {
        return null;
    }

    public String getNodeTLA() {
        return "DEM";
    }

    public String getNodeType() {
        return "Demonstration data";
    }

    public Iterator getChildIterator() {
        final Iterator it = super.getChildIterator();
        return new Iterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                DataNode node = (DataNode)it.next();
                if (node.getName().equals("ndx")) {
                    DataNodeFactory maker = new DataNodeFactory(node.getChildMaker());
                    maker.setPreferredClass(class$uk$ac$starlink$datanode$nodes$NdxDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NdxDataNode = DemoDataNode.class$("uk.ac.starlink.datanode.nodes.NdxDataNode")) : class$uk$ac$starlink$datanode$nodes$NdxDataNode);
                    node.setChildMaker(maker);
                }
                return node;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void configureDetail(DetailViewer dv) {
        super.configureDetail(dv);
        dv.addPane("Information", new HTMLDocComponentMaker("demo.html"));
        if (dv instanceof ApplicationDetailViewer) {
            ((ApplicationDetailViewer)dv).setSelectedIndex(1);
        }
    }

    public static File getDemoDir() throws NoSuchDataException {
        try {
            String demoloc = System.getProperty(DEMO_DIR_PROPERTY);
            if (demoloc == null || demoloc.trim().length() == 0) {
                throw new NoSuchDataException("No demo data available");
            }
            File demodir = new File(demoloc);
            if (!demodir.canRead()) {
                throw new NoSuchDataException("Demo data directory " + demodir + " is not readable");
            }
            return demodir;
        }
        catch (SecurityException e) {
            throw new NoSuchDataException(e.getMessage(), e);
        }
    }
}

