/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.ARYDataNode;
import uk.ac.starlink.datanode.nodes.CompressedDataNode;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.FITSDataNode;
import uk.ac.starlink.datanode.nodes.FileDataNode;
import uk.ac.starlink.datanode.nodes.FtpDirectoryDataNode;
import uk.ac.starlink.datanode.nodes.HDSDataNode;
import uk.ac.starlink.datanode.nodes.HDXDataNode;
import uk.ac.starlink.datanode.nodes.JDBCDataNode;
import uk.ac.starlink.datanode.nodes.NDArrayDataNode;
import uk.ac.starlink.datanode.nodes.NDFDataNode;
import uk.ac.starlink.datanode.nodes.NdxDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.nodes.PlainDataNode;
import uk.ac.starlink.datanode.nodes.StarTableDataNode;
import uk.ac.starlink.datanode.nodes.TarStreamDataNode;
import uk.ac.starlink.datanode.nodes.VOTableDataNode;
import uk.ac.starlink.datanode.nodes.WCSDataNode;
import uk.ac.starlink.datanode.nodes.XMLDataNode;
import uk.ac.starlink.datanode.nodes.ZipFileDataNode;
import uk.ac.starlink.datanode.nodes.ZipStreamDataNode;
import uk.ac.starlink.fits.FitsNdxHandler;
import uk.ac.starlink.hds.NDFNdxHandler;
import uk.ac.starlink.treeview.DemoDataNode;
import uk.ac.starlink.treeview.StaticTreeViewer;
import uk.ac.starlink.treeview.TreeWriter;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.URLUtils;

public class Driver {
    public static final String CMDNAME_PROPERTY = "uk.ac.starlink.treeview.cmdname";
    private static Logger logger = Logger.getLogger("uk.ac.starlink.treeview");

    public static void main(String[] args) {
        boolean textView = false;
        boolean textPath = false;
        int orient = 2;
        Loader.loadProperties();
        Loader.tweakGuiForMac();
        URLUtils.installCustomHandlers();
        Driver.guessProperties();
        Logger.getLogger("uk.ac.starlink").setLevel(Level.WARNING);
        String cmdName = System.getProperty(CMDNAME_PROPERTY);
        if (cmdName == null) {
            cmdName = "treeview";
        }
        boolean hasAST = NodeUtil.hasAST();
        boolean hasHDS = NodeUtil.hasHDS();
        HashMap<String, Class> nodeTypeFlags = new HashMap<String, Class>();
        if (hasHDS) {
            nodeTypeFlags.put("-hds", HDSDataNode.class);
        }
        nodeTypeFlags.put("-file", FileDataNode.class);
        nodeTypeFlags.put("-plain", PlainDataNode.class);
        nodeTypeFlags.put("-comp", CompressedDataNode.class);
        nodeTypeFlags.put("-jdbc", JDBCDataNode.class);
        nodeTypeFlags.put("-table", StarTableDataNode.class);
        nodeTypeFlags.put("-src", PlainDataNode.class);
        if (hasHDS) {
            nodeTypeFlags.put("-ary", ARYDataNode.class);
            nodeTypeFlags.put("-ndf", NDFDataNode.class);
        }
        if (hasAST) {
            nodeTypeFlags.put("-wcs", WCSDataNode.class);
        }
        nodeTypeFlags.put("-zip", ZipFileDataNode.class);
        nodeTypeFlags.put("-zips", ZipStreamDataNode.class);
        nodeTypeFlags.put("-tar", TarStreamDataNode.class);
        nodeTypeFlags.put("-fit", FITSDataNode.class);
        nodeTypeFlags.put("-xml", XMLDataNode.class);
        nodeTypeFlags.put("-hdx", HDXDataNode.class);
        nodeTypeFlags.put("-ndx", NdxDataNode.class);
        nodeTypeFlags.put("-vot", VOTableDataNode.class);
        nodeTypeFlags.put("-nda", NDArrayDataNode.class);
        nodeTypeFlags.put("-ftp", FtpDirectoryDataNode.class);
        String usageMsg = "Usage: " + cmdName + "\n         [-demo] [-text [-path]] [-strict] [-debug] " + "[-split(x|y|0)]" + "\n        ";
        Iterator flagIt = nodeTypeFlags.keySet().iterator();
        while (flagIt.hasNext()) {
            usageMsg = usageMsg + " [" + flagIt.next().toString() + "]";
        }
        usageMsg = usageMsg + "\n         [item ...]\n";
        System.setProperty("HdxDocumentFactory.load." + FitsNdxHandler.class.getName(), "true");
        if (hasHDS) {
            System.setProperty("HdxDocumentFactory.load." + NDFNdxHandler.class.getName(), "true");
        }
        final DataNodeFactory nodeFactory = new DataNodeFactory();
        final ArrayList<DataNode> topNodes = new ArrayList<DataNode>(args.length);
        for (int iarg = 0; iarg < args.length; ++iarg) {
            String arg = args[iarg];
            if (arg.charAt(0) == '-') {
                if (arg.equals("-text")) {
                    textView = true;
                    continue;
                }
                if (arg.equals("-path")) {
                    textPath = true;
                    continue;
                }
                if (arg.equals("-splitx")) {
                    orient = 2;
                    continue;
                }
                if (arg.equals("-splity")) {
                    orient = 1;
                    continue;
                }
                if (arg.equals("-split0")) {
                    orient = 0;
                    continue;
                }
                if (arg.equals("-strict")) {
                    List builders = nodeFactory.getBuilders();
                    nodeFactory.getBuilders().removeAll(builders);
                    continue;
                }
                if (arg.equals("-debug")) {
                    nodeFactory.setDebug(true);
                    continue;
                }
                if (arg.equals("-demo")) {
                    try {
                        topNodes.add(new DemoDataNode());
                        continue;
                    }
                    catch (NoSuchDataException e) {
                        Driver.exitWithError(e.getMessage() + "\n");
                        throw new Error();
                    }
                }
                if (nodeTypeFlags.containsKey(arg)) {
                    Class prefClass = (Class)nodeTypeFlags.get(arg);
                    nodeFactory.setPreferredClass(prefClass);
                    continue;
                }
                Driver.exitWithError(usageMsg);
                continue;
            }
            topNodes.add(Driver.makeDataNode(nodeFactory, arg));
        }
        if (topNodes.size() == 0) {
            String dfltarg = new File(".").getAbsolutePath();
            if (dfltarg.endsWith(File.separatorChar + ".")) {
                dfltarg = dfltarg.substring(0, dfltarg.length() - 1);
            }
            topNodes.add(Driver.makeDataNode(nodeFactory, dfltarg));
        }
        Iterator it = topNodes.iterator();
        while (it.hasNext()) {
            DataNode node = (DataNode)it.next();
            node.setChildMaker(nodeFactory);
        }
        DefaultDataNode root = new DefaultDataNode(){

            public boolean allowsChildren() {
                return true;
            }

            public Iterator getChildIterator() {
                return topNodes.iterator();
            }

            public DataNodeFactory getChildMaker() {
                return nodeFactory;
            }
        };
        if (textView) {
            NodeUtil.setGUI(false);
            Driver.viewAsText(root, textPath);
        } else {
            NodeUtil.setGUI(true);
            Driver.viewAsGUI(root, (short)orient);
        }
    }

    private static void viewAsGUI(final DataNode root, final short orient) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StaticTreeViewer tv = new StaticTreeViewer(root, "Starlink Treeview", orient);
                tv.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                tv.setVisible(true);
            }
        });
    }

    public static void viewAsText(DataNode root, boolean showPath) {
        TreeWriter tw = new TreeWriter(System.out, showPath);
        tw.write(root);
    }

    private static DataNode makeDataNode(DataNodeFactory nodeFactory, String nodename) {
        try {
            DataNode node = nodeFactory.makeDataNode(null, nodename);
            node.setLabel(nodename);
            return node;
        }
        catch (NoSuchDataException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("\nNo such object ").append('\"').append(nodename).append('\"');
            Driver.exitWithError(msg.toString());
            throw new AssertionError();
        }
    }

    private static void guessProperties() {
        Loader.loadProperties();
        Properties props = System.getProperties();
        String prefix = "uk.ac.starlink.treeview.";
        String sc = "" + File.separatorChar;
        String cmdnameProp = prefix + "cmdname";
        if (!props.containsKey(cmdnameProp)) {
            props.setProperty(cmdnameProp, "treeview");
        }
        try {
            File sdir = Loader.starjavaDirectory();
            if (sdir != null) {
                String stardir = sdir.toString() + sc;
                String demodirProp = prefix + "demodir";
                if (!props.containsKey(demodirProp)) {
                    props.setProperty(demodirProp, stardir + "etc" + sc + "treeview" + sc + "demo");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to locate Treeview etc. directory");
        }
    }

    private static void exitWithError(String msg) {
        System.err.println();
        StringTokenizer st = new StringTokenizer(msg, "\n");
        while (st.hasMoreTokens()) {
            System.err.println("   " + st.nextToken());
        }
        System.err.println();
        System.exit(1);
    }
}

