/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import uk.ac.starlink.datanode.nodes.IconFactory;

class HTMLProcessor {
    HTMLProcessor() {
    }

    public static void main(String[] args) throws IOException {
        int c;
        File infile = new File(args[0]);
        File outfile = new File(args[1]);
        if (outfile.isDirectory()) {
            outfile = new File(outfile, infile.getName());
        }
        StringBuffer inbuf = new StringBuffer((int)infile.length());
        BufferedReader inrdr = new BufferedReader(new FileReader(infile));
        while ((c = ((Reader)inrdr).read()) > -1) {
            inbuf.append((char)c);
        }
        ((Reader)inrdr).close();
        HashSet<String> symbols = new HashSet<String>();
        Matcher match = Pattern.compile("(\\ssrc=[\"']?)IconFactory\\.([A-Z0-9_]+)([\"']?)").matcher(inbuf);
        StringBuffer outbuf = new StringBuffer(inbuf.length());
        while (match.find()) {
            String symbol = match.group(2);
            Icon ic = HTMLProcessor.makeIcon(symbol);
            String dimspec = " width='" + ic.getIconWidth() + "'" + " height='" + ic.getIconHeight() + "'";
            String replace = dimspec + " $1" + HTMLProcessor.makeOutLocFromSymbol(symbol) + "$3";
            match.appendReplacement(outbuf, replace);
            symbols.add(symbol);
        }
        match.appendTail(outbuf);
        File outdir = outfile.getAbsoluteFile().getParentFile();
        outdir.mkdirs();
        BufferedWriter outwr = new BufferedWriter(new FileWriter(outfile));
        for (int i = 0; i < outbuf.length(); ++i) {
            ((Writer)outwr).write(outbuf.charAt(i));
        }
        ((Writer)outwr).close();
        Iterator it = symbols.iterator();
        while (it.hasNext()) {
            int b;
            String symbol = (String)it.next();
            InputStream istrm = HTMLProcessor.makeIconInputStream(symbol);
            File oicon = new File(outdir, HTMLProcessor.makeOutLocFromSymbol(symbol));
            File icondir = oicon.getParentFile();
            if (!icondir.exists()) {
                icondir.mkdirs();
            }
            BufferedOutputStream ostrm = new BufferedOutputStream(new FileOutputStream(oicon));
            while ((b = istrm.read()) > -1) {
                ((OutputStream)ostrm).write(b);
            }
            istrm.close();
            ((OutputStream)ostrm).close();
        }
    }

    private static String makeOutLocFromSymbol(String symbol) {
        return "icons/" + symbol + ".gif";
    }

    private static InputStream makeIconInputStream(String symbol) throws IOException {
        try {
            Field field = IconFactory.class.getField(symbol);
            short id = field.getShort(null);
            URL iconURL = IconFactory.getIconURL(id);
            return iconURL.openStream();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(symbol);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(symbol);
        }
        catch (Exception e) {
            throw new RuntimeException(symbol, e);
        }
    }

    private static Icon makeIcon(String symbol) {
        try {
            Field field = IconFactory.class.getField(symbol);
            short id = field.getShort(null);
            return IconFactory.getIcon(id);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(symbol);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(symbol);
        }
    }
}

