/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JComponent;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.viewers.StyledTextArea;
import uk.ac.starlink.treeview.ApplicationDetailViewer;
import uk.ac.starlink.treeview.HTMLDocComponentMaker;

class HelpDetailViewer
extends ApplicationDetailViewer {
    public static final String BUILD_PROPS = "uk/ac/starlink/treeview/text/build.properties";

    public HelpDetailViewer() {
        super("About");
        this.addIcon(IconFactory.getIcon((short)118));
        this.addSpace();
        this.addTitle("Starlink Treeview");
        this.addSpace();
        InputStream propstrm = this.getClass().getClassLoader().getResourceAsStream(BUILD_PROPS);
        if (propstrm != null) {
            Properties props = new Properties();
            try {
                props.load(propstrm);
                this.addSubHead("Version");
                this.addKeyedItem("Version ID", props.getProperty("version"));
                this.addKeyedItem("Build date", props.getProperty("date"));
                this.addKeyedItem("Built by", props.getProperty("built.by"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.addSubHead("Authors");
        this.addText("Mark Taylor");
        this.addSubHead("Optional components");
        this.addKeyedItem("JNIAST", NodeUtil.hasAST() ? "installed" : "not installed");
        this.addKeyedItem("JNIHDS", NodeUtil.hasHDS() ? "installed" : "not installed");
        this.addKeyedItem("JAI", NodeUtil.hasJAI() ? "installed" : "not installed");
        this.addSubHead("Java");
        this.addKeyedItem("JRE", System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        this.addKeyedItem("JVM", System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version"));
        this.addKeyedItem("Installation", System.getProperty("java.home"));
        this.addSubHead("Further information");
        this.addKeyedItem("WWW", "http://www.starlink.ac.uk/treeview/");
        this.addKeyedItem("Email", "m.b.taylor@bristol.ac.uk");
        this.addPane("Basic use", new HTMLDocComponentMaker("basic.html"));
        this.addPane("Buttons", new HTMLDocComponentMaker("buttons.html"));
        this.addPane("Node types", new NodeTypePane("Node types"));
        this.addPane("Invocation", new HTMLDocComponentMaker("invocation.html"));
        this.addPane("Alter-egos", new HTMLDocComponentMaker("popup.html"));
        this.setSelectedIndex(1);
    }

    private class NodeTypePane
    implements ComponentMaker {
        private String title;
        private StyledTextArea ta;

        public NodeTypePane(String title) {
            this.title = title;
        }

        public JComponent getComponent() {
            this.ta = new StyledTextArea();
            this.ta.addTitle("Node types");
            this.ta.addText("The following are the known nodes, represented by the icons shown:");
            this.ta.addSeparator();
            this.addKnownIcon((short)91, "Scalar item");
            this.addKnownIcon((short)92, "1-dimensional array");
            this.addKnownIcon((short)93, "2-dimensional array");
            this.addKnownIcon((short)94, "N-dimensional array (N>2)");
            this.ta.addSeparator();
            this.addKnownIcon((short)117, "Table structure");
            this.ta.addSeparator();
            this.addKnownIcon((short)106, "Directory");
            this.addKnownIcon((short)105, "Plain file");
            this.ta.addSeparator();
            this.addKnownIcon((short)135, "Unknown data source");
            this.addKnownIcon((short)134, "Compressed data source");
            this.ta.addSeparator();
            this.addKnownIcon((short)111, "FITS file");
            this.addKnownIcon((short)112, "Generic FITS HDU");
            this.ta.addSeparator();
            this.addKnownIcon((short)110, "AST WCS structure");
            this.addKnownIcon((short)113, "AST WCS coordinate Frame");
            this.addKnownIcon((short)114, "AST WCS Sky coordinate Frame");
            this.addKnownIcon((short)142, "AST WCS Spectral coordinate Frame");
            this.ta.addSeparator();
            this.addKnownIcon((short)104, "HDS data structure");
            this.addKnownIcon((short)107, "NDF data structure");
            this.addKnownIcon((short)115, "History component");
            this.ta.addSeparator();
            this.addKnownIcon((short)120, "Well-formed XML document");
            this.addKnownIcon((short)127, "XML document type declaration");
            this.addKnownIcon((short)121, "XML element");
            this.addKnownIcon((short)126, "XML text node");
            this.addKnownIcon((short)124, "XML CDATA node");
            this.addKnownIcon((short)122, "XML comment");
            this.addKnownIcon((short)123, "XML processing instruction");
            this.ta.addSeparator();
            this.addKnownIcon((short)131, "HDX container");
            this.addKnownIcon((short)130, "NDX structure");
            this.ta.addSeparator();
            this.addKnownIcon((short)140, "VOTable");
            this.addKnownIcon((short)141, "Component within VOTable");
            this.ta.addSeparator();
            this.addKnownIcon((short)108, "Zip/Jar archive");
            this.addKnownIcon((short)109, "Zip/Jar archive directory");
            this.ta.addSeparator();
            this.addKnownIcon((short)132, "Tar archive");
            this.addKnownIcon((short)133, "Tar archive directory");
            this.ta.addSeparator();
            this.addKnownIcon((short)143, "MySpace container");
            this.ta.addSeparator();
            this.addKnownIcon((short)119, "Error creating a node");
            return this.ta;
        }

        private void addKnownIcon(short iconID, String descrip) {
            this.ta.addSpace();
            this.ta.addIcon(IconFactory.getIcon(iconID));
            this.ta.addSpace();
            this.ta.addText(descrip);
        }
    }
}

