/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.treeview.ByteList;

public class HexDumper
extends JTable {
    public static final int BYTES_PER_ROW = 16;
    static /* synthetic */ Class class$uk$ac$starlink$treeview$HexDumper;

    public HexDumper(final RandomAccessFile raf) throws IOException {
        this(new ByteSource(){
            private int length;
            {
                this.length = (int)raf.length();
            }

            public int read(int pos) throws IOException {
                raf.seek(pos);
                return raf.readByte();
            }

            public int length() {
                return this.length;
            }

            public boolean isRandom() {
                return true;
            }
        });
    }

    public HexDumper(final InputStream strm, final long length) throws IOException {
        this(new ByteSource(){
            private int loc = 0;
            static final /* synthetic */ boolean $assertionsDisabled;

            public int read(int pos) throws IOException {
                while (pos > this.loc) {
                    int inc = (int)strm.skip(pos - this.loc);
                    if (inc == 0) {
                        strm.read();
                        ++inc;
                    }
                    this.loc += inc;
                }
                int val = strm.read();
                if (!$assertionsDisabled && this.loc != pos && val != -1) {
                    throw new AssertionError();
                }
                ++this.loc;
                return val;
            }

            public int length() {
                if (length > Integer.MAX_VALUE) {
                    System.err.println("truncating " + length + " to " + Integer.MAX_VALUE);
                    return Integer.MAX_VALUE;
                }
                return (int)length;
            }

            public boolean isRandom() {
                return false;
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$treeview$HexDumper == null ? (class$uk$ac$starlink$treeview$HexDumper = HexDumper.class$("uk.ac.starlink.treeview.HexDumper")) : class$uk$ac$starlink$treeview$HexDumper).desiredAssertionStatus();
            }
        });
    }

    public HexDumper(final ByteSource src) throws IOException {
        HexDumperTableModel model;
        if (src.length() >= 0) {
            final int leng = src.length();
            model = src.isRandom() ? new HexDumperTableModel(){

                public int getByteCount() {
                    return leng;
                }

                public byte getByteAt(int pos) throws IOException {
                    return (byte)src.read(pos);
                }
            } : new HexDumperTableModel(){
                private ByteList bytebag = new ByteList();

                public int getByteCount() {
                    return leng;
                }

                public byte getByteAt(int pos) throws IOException {
                    for (int i = this.bytebag.length(); i <= pos; ++i) {
                        this.bytebag.append((byte)src.read(i));
                    }
                    return this.bytebag.get(pos);
                }
            };
        } else {
            model = new HexDumperTableModel(){
                private int knownsize = 0;
                private final int overshoot = 4096;
                private final int nearEnd = 2048;
                private boolean foundEnd = false;
                private ByteList bytebag = new ByteList(4096);
                {
                    this.getByteAt(0);
                }

                public int getByteCount() {
                    return this.knownsize;
                }

                public byte getByteAt(int pos) throws IOException {
                    if (pos >= this.knownsize || this.knownsize - pos < this.knownsize / 4 && !this.foundEnd) {
                        int firstrow = this.knownsize / 16;
                        if (this.foundEnd) {
                            throw new IllegalStateException();
                        }
                        int limit = this.knownsize + 4096;
                        while (this.knownsize < limit) {
                            int b = src.read(this.knownsize);
                            if (b < 0) {
                                this.foundEnd = true;
                                break;
                            }
                            this.bytebag.append((byte)b);
                            ++this.knownsize;
                        }
                        int lastrow = this.knownsize / 16 - 1;
                        this.fireTableRowsInserted(firstrow, lastrow);
                    }
                    return this.bytebag.get(pos);
                }
            };
        }
        this.setModel(model);
        this.setAutoResizeMode(0);
        this.setShowGrid(false);
        this.setTableHeader(null);
        Font fixfont = new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize());
        this.setFont(fixfont);
        DefaultTableCellRenderer rend0 = new DefaultTableCellRenderer();
        rend0.setHorizontalAlignment(4);
        rend0.setBackground(UIManager.getColor("TableHeader.background"));
        DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
        rend.setHorizontalAlignment(0);
        DefaultTableCellRenderer rendc = new DefaultTableCellRenderer();
        rend.setHorizontalAlignment(0);
        Component renderedM = rend.getTableCellRendererComponent(this, "m", false, false, 1, 1);
        int charWidth = renderedM.getPreferredSize().width;
        TableColumnModel tcm = this.getColumnModel();
        TableColumn c0 = tcm.getColumn(0);
        c0.setCellRenderer(rend0);
        c0.setPreferredWidth(8 * charWidth);
        for (int i = 0; i < 16; ++i) {
            TableColumn col = tcm.getColumn(i + 1);
            col.setCellRenderer(rend);
            col.setPreferredWidth((int)(2.5 * (double)charWidth));
        }
        TableColumn blankcol = tcm.getColumn(17);
        blankcol.setCellRenderer(rend);
        blankcol.setPreferredWidth(1 * charWidth);
        TableColumn cc = tcm.getColumn(18);
        cc.setCellRenderer(rendc);
        cc.setPreferredWidth(17 * charWidth);
    }

    public static interface ByteSource {
        public int read(int var1) throws IOException;

        public int length();

        public boolean isRandom();
    }

    private static abstract class HexDumperTableModel
    extends AbstractTableModel {
        private HexDumperTableModel() {
        }

        public abstract int getByteCount();

        public abstract byte getByteAt(int var1) throws IOException;

        public int getColumnCount() {
            return 19;
        }

        public int getRowCount() {
            return (this.getByteCount() + 16 - 1) / 16;
        }

        public Object getValueAt(int row, int column) {
            try {
                if (column == 0) {
                    return Integer.toHexString(row * 16);
                }
                if (column > 0 && column <= 16) {
                    int pos = 16 * row + column - 1;
                    if (pos < this.getByteCount()) {
                        byte b = this.getByteAt(pos);
                        return Integer.toHexString(0x100 | b & 0xFF).substring(1);
                    }
                    return null;
                }
                if (column == 17) {
                    return null;
                }
                if (column == 18) {
                    StringBuffer sb = new StringBuffer(16);
                    int start = 16 * row;
                    int end = Math.min(start + 16, this.getByteCount());
                    for (int pos = start; pos < end; ++pos) {
                        byte b = this.getByteAt(pos);
                        if (b > 31 && b < 127) {
                            sb.append((char)b);
                            continue;
                        }
                        sb.append('\u00b7');
                    }
                    return sb.toString();
                }
                throw new AssertionError((Object)("Unexpected column " + column));
            }
            catch (IOException e) {
                return "ERROR";
            }
        }
    }
}

