/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Plot;
import uk.ac.starlink.datanode.viewers.TreeviewLAF;
import uk.ac.starlink.treeview.ImageViewPane;

class ImageViewer
extends JPanel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImageViewer(NDArray nda, FrameSet wcs) throws IOException {
        this(nda, wcs, true);
    }

    public ImageViewer(NDArray nda, FrameSet wcs, boolean async) throws IOException {
        super(new BorderLayout());
        final ImageViewPane view = new ImageViewPane(nda, wcs, async);
        this.add((Component)view, "Center");
        TreeviewLAF.configureMainPanel(view);
        Box controlBox = new Box(1);
        if (wcs != null) {
            int nfrm = wcs.getNframe();
            String[] frameNames = new String[nfrm + 1];
            frameNames[0] = "no grid";
            for (int i = 0; i < nfrm; ++i) {
                frameNames[i + 1] = i + 1 + ": " + wcs.getFrame(i + 1).getDomain();
            }
            final JComboBox<String> selecter = new JComboBox<String>(frameNames);
            final Plot plot = view.getPlot();
            if (!$assertionsDisabled && plot == null) {
                throw new AssertionError();
            }
            selecter.setSelectedIndex(plot.getCurrent() - 1);
            selecter.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        int currentFrame = selecter.getSelectedIndex();
                        if (currentFrame == 0) {
                            view.setDoPlot(false);
                        } else {
                            view.setDoPlot(true);
                            plot.setCurrent(currentFrame + 1);
                        }
                        view.rePlot();
                    }
                }
            });
            Box selecterBox = new Box(0);
            selecterBox.add(new JLabel("Coordinate grid: "));
            selecterBox.add(selecter);
            selecterBox.add(Box.createGlue());
            TreeviewLAF.configureControl(selecterBox);
            controlBox.add(selecterBox);
        }
        if (controlBox.getComponentCount() > 0) {
            TreeviewLAF.configureControlPanel(controlBox);
            this.add((Component)controlBox, "North");
        }
    }

    static {
        $assertionsDisabled = !ImageViewer.class.desiredAssertionStatus();
    }
}

