/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeBuilder;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.ErrorDataNode;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.tree.DataNodeJTree;
import uk.ac.starlink.datanode.tree.DataNodeTransferHandler;
import uk.ac.starlink.datanode.tree.DataNodeTreeModel;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.treeview.ApplicationDetailViewer;
import uk.ac.starlink.treeview.BasicAction;
import uk.ac.starlink.treeview.DemoDataNode;
import uk.ac.starlink.treeview.DuplicateDataNode;
import uk.ac.starlink.treeview.HelpDetailViewer;

public class StaticTreeViewer
extends JFrame {
    private TreeSelectionModel selectModel;
    private DetailPlacer detailPlacer;
    private DataNodeJTree jtree;
    private DataNodeTreeModel treeModel;
    private DataNode root;
    private DemoDataNode demoNode;
    private JFileChooser fileChooser;
    private JComponent helpPanel;
    private JViewport detailHolder;
    private JSplitPane splitter;
    private JLabel treeNodesLabel;
    private JLabel modelNodesLabel;
    private boolean showDetail = true;
    private double splitHloc;
    private double splitVloc;
    private DataNodeFactory nodeMaker = new DataNodeFactory();
    private Map detailMap = new WeakHashMap();
    private Action helpAction;
    private Action collapseAction;
    private Action expandAction;
    private Action recursiveCollapseAction;
    private Action recursiveExpandAction;
    private Action reloadAction;
    private Action deleteAction;
    private Action upAction;
    private Action copyTopAction;
    private Action stopAction;
    public static final short DETAIL_NONE = 0;
    public static final short DETAIL_BELOW = 1;
    public static final short DETAIL_BESIDE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StaticTreeViewer(DataNode root) {
        this(root, "Tree Display", 2);
    }

    /*
     * WARNING - void declaration
     */
    public StaticTreeViewer(DataNode root, String title, short initialLayout) {
        super(title);
        void var9_9;
        this.root = root;
        this.treeModel = new DataNodeTreeModel(root);
        this.jtree = new DataNodeJTree(this.treeModel);
        ((DataNodeTransferHandler)this.jtree.getTransferHandler()).setNodeMaker(this.nodeMaker);
        this.jtree.setScrollsOnExpand(false);
        this.selectModel = this.jtree.getSelectionModel();
        this.selectModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                StaticTreeViewer.this.updateDetail(StaticTreeViewer.this.getSelectedDataNode());
            }
        });
        Dimension treesize = new Dimension(480, 430);
        Dimension detailsize = new Dimension(520, 430);
        JScrollPane treePanel = new JScrollPane(this.jtree);
        treePanel.setPreferredSize(treesize);
        JPanel statter = new JPanel();
        this.treeNodesLabel = new JLabel(" Visible nodes: ");
        this.modelNodesLabel = new JLabel(" Total nodes: ");
        statter.setLayout(new GridLayout());
        statter.add(this.treeNodesLabel);
        statter.add(this.modelNodesLabel);
        this.getContentPane().add((Component)statter, "South");
        this.helpPanel = new HelpDetailViewer().getComponent();
        this.detailPlacer = new DetailPlacer();
        this.detailPlacer.start();
        JPanel dummyDetail = new JPanel();
        dummyDetail.setPreferredSize(detailsize);
        this.detailHolder = new JViewport();
        this.detailHolder.setView(dummyDetail);
        this.detailHolder.setPreferredSize(detailsize);
        this.splitter = new JSplitPane();
        this.splitter.setTopComponent(treePanel);
        switch (initialLayout) {
            case 2: {
                Dimension psize = new Dimension(treesize.width + detailsize.width, (treesize.height + detailsize.height) / 2);
                break;
            }
            case 1: {
                Dimension psize = new Dimension((treesize.width + detailsize.width) / 2, treesize.height + detailsize.height);
                break;
            }
            case 0: {
                Dimension psize = new Dimension(treesize.width, treesize.height);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid initialLayout value " + initialLayout));
            }
        }
        this.splitter.setPreferredSize((Dimension)var9_9);
        this.configureActions();
        this.getContentPane().add((Component)this.splitter, "Center");
        this.pack();
        this.configureSplitter(initialLayout);
        this.helpAction.actionPerformed(null);
        this.jtree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent evt) {
                StaticTreeViewer.this.showTreeCount();
            }

            public void treeCollapsed(TreeExpansionEvent evt) {
                StaticTreeViewer.this.showTreeCount();
            }
        });
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesInserted(TreeModelEvent evt) {
                StaticTreeViewer.this.showNodeCount();
                StaticTreeViewer.this.showTreeCount();
            }

            public void treeNodesRemoved(TreeModelEvent evt) {
                StaticTreeViewer.this.showNodeCount();
                StaticTreeViewer.this.showTreeCount();
            }

            public void treeStructureChanged(TreeModelEvent evt) {
                StaticTreeViewer.this.showNodeCount();
                StaticTreeViewer.this.showTreeCount();
            }

            public void treeNodesChanged(TreeModelEvent evt) {
                StaticTreeViewer.this.showNodeCount();
            }
        });
        this.jtree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                this.maybeShowPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                this.maybeShowPopup(evt);
            }

            private void maybeShowPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    int x = evt.getX();
                    int y = evt.getY();
                    TreePath path = StaticTreeViewer.this.jtree.getPathForLocation(x, y);
                    if (path != null) {
                        JPopupMenu popup = StaticTreeViewer.this.alterEgoPopup(path);
                        if (popup != null) {
                            popup.show(evt.getComponent(), x, y);
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }
            }
        });
        if (root.allowsChildren()) {
            int nnode = 0;
            Iterator it = root.getChildIterator();
            while (it.hasNext()) {
                DataNode child = (DataNode)it.next();
                if (nnode == 0 && !it.hasNext()) {
                    Object[] path = this.treeModel.getPathToRoot(child);
                    this.jtree.expandPathLater(new TreePath(path));
                }
                if (child instanceof DemoDataNode) {
                    this.demoNode = (DemoDataNode)child;
                }
                ++nnode;
            }
        }
    }

    private void configureActions() {
        int i;
        BasicAction exitAction = new BasicAction("Exit", IconFactory.getIcon((short)2), "Exit the viewer"){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        };
        this.collapseAction = new BasicAction("Collapse Selected", IconFactory.getIcon((short)24), "Close the selected node"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.jtree.collapsePath(StaticTreeViewer.this.jtree.getSelectionPath());
            }
        };
        this.expandAction = new BasicAction("Expand Selected", IconFactory.getIcon((short)23), "Open the selected node"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.jtree.expandPathLater(StaticTreeViewer.this.jtree.getSelectionPath());
            }
        };
        this.recursiveCollapseAction = new BasicAction("Recursive Collapse Selected", IconFactory.getIcon((short)22), "Recursively collapse the selected node"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.recursiveCollapse(StaticTreeViewer.this.getSelectedDataNode());
            }
        };
        this.recursiveExpandAction = new BasicAction("Recursive Expand Selected", IconFactory.getIcon((short)21), "Recursively expand the selected node"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.recursiveExpand(StaticTreeViewer.this.getSelectedDataNode());
            }
        };
        BasicAction collapseAllAction = new BasicAction("Recursive Collapse All", null, "Recursively collapse the entire tree"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.collapseAll();
            }
        };
        BasicAction expandAllAction = new BasicAction("Recursive Expand All", null, "Recursively expand the entire tree"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.recursiveExpand(StaticTreeViewer.this.root);
            }
        };
        class SplitPosAction
        extends BasicAction {
            short pos;

            SplitPosAction(String name, Icon icon, String desc, short pos) {
                super(name, icon, desc);
                this.pos = pos;
            }

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.configureSplitter(this.pos);
            }
        }
        SplitPosAction detailBelowAction = new SplitPosAction("Details Below", IconFactory.getIcon((short)12), "Display node details below the tree", 1);
        SplitPosAction detailBesideAction = new SplitPosAction("Details Beside", IconFactory.getIcon((short)13), "Display node details to right of the tree", 2);
        SplitPosAction detailNoneAction = new SplitPosAction("No Details", IconFactory.getIcon((short)11), "Do not display node details", 0);
        BasicAction newFileAction = new BasicAction("Open File", IconFactory.getIcon((short)5), "Add a new node to the tree from filesystem"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.chooseNewFile();
            }
        };
        BasicAction newNameAction = new BasicAction("Open Name", null, "Add a new node to the tree by name"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.chooseNewName();
            }
        };
        BasicAction demoAction = new BasicAction("Demo Data", IconFactory.getIcon((short)4), "Add demo data node at top of tree"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.addDemoData();
            }
        };
        try {
            DemoDataNode.getDemoDir();
        }
        catch (NoSuchDataException e) {
            demoAction.setEnabled(false);
        }
        this.helpAction = new BasicAction("Show Help", IconFactory.getIcon((short)3), "Show help text in details panel"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.displayHelpComponent(StaticTreeViewer.this.helpPanel);
            }
        };
        this.reloadAction = new BasicAction("Reload Node", IconFactory.getIcon((short)30), "Refresh node data"){

            public void actionPerformed(ActionEvent evt) {
                DataNode newdn;
                DataNode dn = StaticTreeViewer.this.getSelectedDataNode();
                CreationState creator = dn.getCreator();
                if (creator == null || creator.getObject() == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                try {
                    newdn = creator.getBuilder().buildNode(creator.getObject());
                    if (newdn == null) {
                        throw new NoSuchDataException("Data no longer available");
                    }
                    newdn.setLabel(dn.getLabel());
                    newdn.setCreator(creator);
                }
                catch (NoSuchDataException e) {
                    newdn = new ErrorDataNode(e);
                    newdn.setCreator(creator);
                }
                StaticTreeViewer.this.replaceNode(dn, newdn);
            }
        };
        this.deleteAction = new BasicAction("Delete Node", IconFactory.getIcon((short)31), "Delete top-level node from the tree"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.treeModel.removeNode(StaticTreeViewer.this.getSelectedDataNode());
            }
        };
        this.upAction = new BasicAction("Add Parent", IconFactory.getIcon((short)32), "Replace a top-level node by its parent"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.replaceWithParent(StaticTreeViewer.this.getSelectedDataNode());
            }
        };
        this.copyTopAction = new BasicAction("Copy To Root", IconFactory.getIcon((short)33), "Copy node into the top level"){

            public void actionPerformed(ActionEvent evt) {
                DuplicateDataNode newNode = new DuplicateDataNode(StaticTreeViewer.this.getSelectedDataNode());
                StaticTreeViewer.this.treeModel.appendNode(newNode, StaticTreeViewer.this.root);
            }
        };
        this.stopAction = new BasicAction("Stop expansion", IconFactory.getIcon((short)1), "Interrupt any node expansion happening"){

            public void actionPerformed(ActionEvent evt) {
                StaticTreeViewer.this.recursiveStopExpansion(StaticTreeViewer.this.root);
            }
        };
        Action[] connectActions = this.jtree.getConnectionActions(this.nodeMaker);
        this.selectModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                StaticTreeViewer.this.configActs();
            }
        });
        this.jtree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent evt) {
                StaticTreeViewer.this.configActs();
            }

            public void treeExpanded(TreeExpansionEvent evt) {
                StaticTreeViewer.this.configActs();
            }
        });
        this.configActs();
        JToolBar tools = new JToolBar();
        this.getContentPane().add((Component)tools, "North");
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        JMenu fileMenu = new JMenu("File");
        mb.add(fileMenu);
        fileMenu.add(newFileAction).setIcon(null);
        fileMenu.add(newNameAction).setIcon(null);
        for (i = 0; i < connectActions.length; ++i) {
            fileMenu.add(connectActions[i]).setIcon(null);
        }
        fileMenu.add(exitAction).setIcon(null);
        tools.add(exitAction);
        tools.add(newFileAction);
        for (i = 0; i < connectActions.length; ++i) {
            Action conact = connectActions[i];
            if (conact.getValue("SmallIcon") == null) continue;
            tools.add(conact);
        }
        tools.addSeparator();
        JMenu viewMenu = new JMenu("View");
        mb.add(viewMenu);
        this.addButtonGroup(tools, viewMenu, new Action[]{detailBesideAction, detailBelowAction, detailNoneAction});
        JMenu treeMenu = new JMenu("Tree");
        mb.add(treeMenu);
        treeMenu.add(this.reloadAction).setIcon(null);
        treeMenu.add(this.deleteAction).setIcon(null);
        treeMenu.add(this.upAction).setIcon(null);
        treeMenu.add(this.copyTopAction).setIcon(null);
        treeMenu.add(this.collapseAction).setIcon(null);
        treeMenu.add(this.expandAction).setIcon(null);
        treeMenu.add(this.recursiveCollapseAction).setIcon(null);
        treeMenu.add(this.recursiveExpandAction).setIcon(null);
        treeMenu.add(collapseAllAction).setIcon(null);
        treeMenu.add(expandAllAction).setIcon(null);
        tools.add(this.collapseAction);
        tools.add(this.expandAction);
        tools.add(this.recursiveCollapseAction);
        tools.add(this.recursiveExpandAction);
        tools.addSeparator();
        tools.add(this.upAction);
        tools.add(this.copyTopAction);
        tools.add(this.reloadAction);
        tools.add(this.deleteAction);
        JMenu helpMenu = new JMenu("Help");
        mb.add(Box.createHorizontalGlue());
        mb.add(helpMenu);
        helpMenu.add(this.helpAction).setIcon(null);
        helpMenu.add(demoAction).setIcon(null);
        tools.addSeparator();
        tools.add(demoAction);
        tools.add(this.helpAction);
        Image logoImage = ((ImageIcon)IconFactory.getIcon((short)405)).getImage().getScaledInstance(-1, 30, 4);
        tools.add(Box.createHorizontalGlue());
        tools.addSeparator();
        tools.add(new JLabel(new ImageIcon(logoImage)));
        tools.addSeparator();
    }

    private void configActs() {
        DataNode selNode = this.getSelectedDataNode();
        if (selNode != null) {
            TreePath tp = this.jtree.getSelectionPath();
            boolean isExpansible = !this.treeModel.isLeaf(selNode);
            CreationState creator = selNode.getCreator();
            boolean isReloadable = creator != null && creator.getObject() != null;
            this.recursiveExpandAction.setEnabled(isExpansible);
            this.recursiveCollapseAction.setEnabled(isExpansible);
            if (isExpansible) {
                boolean isExpanded = this.jtree.isExpanded(tp);
                this.expandAction.setEnabled(!isExpanded);
                this.collapseAction.setEnabled(isExpanded);
            } else {
                this.expandAction.setEnabled(false);
                this.collapseAction.setEnabled(false);
            }
            boolean inRoot = tp.getPathCount() == 2;
            this.reloadAction.setEnabled(isReloadable);
            this.deleteAction.setEnabled(inRoot);
            this.upAction.setEnabled(inRoot && selNode.getParentObject() != null);
            this.copyTopAction.setEnabled(!inRoot);
        } else {
            this.recursiveExpandAction.setEnabled(false);
            this.recursiveCollapseAction.setEnabled(false);
            this.expandAction.setEnabled(false);
            this.collapseAction.setEnabled(false);
            this.reloadAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.upAction.setEnabled(false);
            this.copyTopAction.setEnabled(false);
        }
    }

    private DataNode getSelectedDataNode() {
        return (DataNode)this.jtree.getLastSelectedPathComponent();
    }

    private void addButtonGroup(JToolBar bar, JMenu menu, Action[] acts) {
        ButtonGroup grp = new ButtonGroup();
        Insets margin = new Insets(0, 0, 0, 0);
        for (int i = 0; i < acts.length; ++i) {
            Action act = acts[i];
            JToggleButton tbutt = new JToggleButton(act);
            tbutt.setText(null);
            tbutt.setMargin(margin);
            bar.add(tbutt);
            JRadioButtonMenuItem mbutt = new JRadioButtonMenuItem(act);
            mbutt.setIcon(null);
            mbutt.setModel(tbutt.getModel());
            menu.add(mbutt);
            grp.add(tbutt);
            tbutt.setSelected(i == 0);
        }
        bar.addSeparator();
    }

    private void showTreeCount() {
        this.treeNodesLabel.setText(" Visible nodes: " + this.jtree.getRowCount());
    }

    private void showNodeCount() {
        int nnode = this.treeModel.getNodeCount() - 1;
        this.modelNodesLabel.setText(" Total nodes: " + nnode);
    }

    private void displayHelpComponent(JComponent comp) {
        if (this.jtree.getSelectionPath() != null) {
            this.jtree.clearSelection();
        }
        if (!this.showDetail) {
            this.configureSplitter((short)2);
        }
        this.setDetailPane(comp);
    }

    private void replaceWithParent(DataNode node) {
        DataNode parentNode;
        Object parentObj = node.getParentObject();
        if (!$assertionsDisabled && parentObj == null) {
            throw new AssertionError();
        }
        String path = NodeUtil.getNodePath(node);
        boolean error = false;
        try {
            parentNode = this.nodeMaker.makeDataNode(this.root, parentObj);
        }
        catch (NoSuchDataException e) {
            parentNode = this.nodeMaker.makeErrorDataNode(null, e);
            error = true;
        }
        String pname = node.getName();
        String psep = parentNode.getPathSeparator();
        if (path != null && pname != null && path.indexOf(pname) > 0) {
            path = path.substring(0, path.length() - pname.length());
            if (psep != null && path.indexOf(psep) > 0) {
                path = path.substring(0, path.length() - psep.length());
            }
            parentNode.setLabel(path);
        }
        this.replaceNode(node, parentNode);
    }

    private void recursiveCollapse(DataNode node) {
        this.refreshNode(node);
    }

    private void collapseAll() {
        int nChild = this.treeModel.getChildCount(this.root);
        for (int i = 0; i < nChild; ++i) {
            DataNode node = (DataNode)this.treeModel.getChild(this.root, i);
            this.refreshNode(node);
        }
    }

    private void recursiveExpand(DataNode dataNode) {
        this.jtree.recursiveExpand(dataNode);
    }

    private void recursiveStopExpansion(DataNode node) {
        this.treeModel.stopExpansion(node);
        DataNode[] children = this.treeModel.getCurrentChildren(node);
        for (int i = 0; i < children.length; ++i) {
            this.recursiveStopExpansion(children[i]);
        }
    }

    private void chooseNewFile() {
        int retval;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
            this.fileChooser.setApproveButtonText("Add Node");
            this.fileChooser.setFileSelectionMode(2);
        }
        if ((retval = this.fileChooser.showOpenDialog(this)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            DataNode node = this.nodeMaker.makeChildNode(null, file);
            node.setLabel(file.getAbsolutePath());
            this.appendNodeToRoot(node);
        }
    }

    private void chooseNewName() {
        String name = JOptionPane.showInputDialog(this, (Object)"Name of the new node");
        if (name == null || name.trim().length() == 0) {
            return;
        }
        DataNode dnode = this.nodeMaker.makeChildNode(null, name);
        dnode.setLabel(name);
        this.appendNodeToRoot(dnode);
    }

    private synchronized void addDemoData() {
        Object[] path;
        DataNode dnode = this.demoNode;
        if (dnode == null) {
            try {
                this.demoNode = dnode = new DemoDataNode();
            }
            catch (NoSuchDataException e) {
                dnode = this.nodeMaker.makeErrorDataNode(null, e);
            }
        }
        if ((path = this.treeModel.getPathToRoot(dnode)) == null) {
            this.treeModel.insertNode(dnode, this.root, 0);
            path = this.treeModel.getPathToRoot(dnode);
        }
        TreePath tpath = new TreePath(path);
        this.jtree.scrollPathToVisible(tpath);
        this.jtree.setSelectionPath(tpath);
    }

    private void appendNodeToRoot(DataNode node) {
        this.treeModel.appendNode(node, this.root);
        TreePath tpath = new TreePath(this.treeModel.getPathToRoot(node));
        this.jtree.scrollPathToVisible(tpath);
        this.jtree.setSelectionPath(tpath);
    }

    private void replaceNode(DataNode oldNode, DataNode newNode) {
        TreePath path = new TreePath(this.treeModel.getPathToRoot(oldNode));
        this.jtree.collapsePath(path);
        boolean isSelected = path.equals(this.jtree.getSelectionPath());
        this.treeModel.replaceNode(oldNode, newNode);
        if (isSelected) {
            TreePath newPath = path.getParentPath().pathByAddingChild(newNode);
            this.jtree.setSelectionPath(newPath);
        }
    }

    private void refreshNode(DataNode node) {
        TreePath path = new TreePath(this.treeModel.getPathToRoot(node));
        this.jtree.collapsePath(path);
        this.treeModel.refreshNode(node);
    }

    public void configureSplitter(short config) {
        Component bottom = this.splitter.getBottomComponent();
        if (bottom != null && bottom != this.detailHolder) {
            double initloc;
            this.splitHloc = initloc = 0.5;
            this.splitVloc = initloc;
            this.splitter.setDividerLocation(initloc);
            this.splitter.setLastDividerLocation(this.splitter.getDividerLocation());
        } else {
            if (bottom == null && config == 0 || bottom == this.detailHolder && (config == 2 && this.splitter.getOrientation() == 1 || config == 1 && this.splitter.getOrientation() == 0)) {
                return;
            }
            if (bottom == this.detailHolder && this.splitter.getDividerLocation() > 0) {
                if (this.splitter.getOrientation() == 1) {
                    this.splitHloc = (double)this.splitter.getDividerLocation() / this.splitter.getSize().getWidth();
                } else if (this.splitter.getOrientation() == 0) {
                    this.splitVloc = (double)this.splitter.getDividerLocation() / this.splitter.getSize().getHeight();
                }
            }
        }
        if (config == 2 || config == 1) {
            this.showDetail = true;
            this.splitter.setDividerSize(4);
            if (bottom != this.detailHolder) {
                this.splitter.setBottomComponent(this.detailHolder);
            }
            if (config == 2) {
                this.splitter.setLastDividerLocation((int)(this.splitHloc * this.splitter.getSize().getWidth()));
                this.splitter.setOrientation(1);
                this.splitter.setDividerLocation(this.splitHloc);
            } else {
                this.splitter.setLastDividerLocation((int)(this.splitVloc * this.splitter.getSize().getHeight()));
                this.splitter.setOrientation(0);
                this.splitter.setDividerLocation(this.splitVloc);
            }
        } else if (config == 0) {
            this.showDetail = false;
            if (bottom != null) {
                this.splitter.setLastDividerLocation(this.splitter.getDividerLocation());
                this.splitter.setBottomComponent(null);
                this.splitter.setDividerSize(0);
            }
        } else {
            throw new IllegalArgumentException("Unknown option");
        }
        this.updateDetail(this.getSelectedDataNode());
    }

    private JPopupMenu alterEgoPopup(TreePath tpath) {
        final DataNode dn = (DataNode)tpath.getLastPathComponent();
        final CreationState creator = dn.getCreator();
        JPopupMenu popper = new JPopupMenu();
        if (creator != null && creator.getObject() != null) {
            final DataNodeBuilder origbuilder = creator.getBuilder();
            final Object cobj = creator.getObject();
            Class<?> origclass = dn.getClass();
            AbstractAction reload = new AbstractAction("Reload", dn.getIcon()){

                public void actionPerformed(ActionEvent evt) {
                    DataNode newdn;
                    try {
                        newdn = origbuilder.buildNode(cobj);
                        if (newdn == null) {
                            throw new NoSuchDataException("Data no longer available");
                        }
                        newdn.setLabel(dn.getLabel());
                        newdn.setCreator(creator);
                    }
                    catch (NoSuchDataException e) {
                        newdn = new ErrorDataNode(e);
                        newdn.setCreator(creator);
                    }
                    StaticTreeViewer.this.replaceNode(dn, newdn);
                }
            };
            popper.add(reload);
            DataNodeFactory cfact = new DataNodeFactory();
            List builders = cfact.getBuilders();
            ArrayList<24> alteregos = new ArrayList<24>();
            HashSet nodetypes = new HashSet();
            nodetypes.add(dn.getClass());
            DataNode parent = creator.getParent();
            Iterator bit = builders.iterator();
            while (bit.hasNext()) {
                DataNode newdn;
                DataNode newdn1;
                DataNodeBuilder builder = (DataNodeBuilder)bit.next();
                if (!builder.suitable(cobj.getClass())) continue;
                try {
                    newdn1 = builder.buildNode(cobj);
                }
                catch (NoSuchDataException e) {
                    newdn1 = null;
                }
                if ((newdn = newdn1) == null || nodetypes.contains(newdn.getClass()) || newdn instanceof ErrorDataNode) continue;
                newdn.setLabel(dn.getLabel());
                CreationState creat = new CreationState(parent, cobj);
                creat.setFactory(cfact);
                creat.setBuilder(builder);
                newdn.setCreator(creat);
                String text = newdn.getNodeTLA() + ": " + newdn.toString();
                Icon icon = newdn.getIcon();
                AbstractAction act = new AbstractAction(text, icon){

                    public void actionPerformed(ActionEvent evt) {
                        StaticTreeViewer.this.replaceNode(dn, newdn);
                    }
                };
                alteregos.add(act);
                nodetypes.add(newdn.getClass());
            }
            if (alteregos.size() > 0) {
                popper.addSeparator();
                Iterator it = alteregos.iterator();
                while (it.hasNext()) {
                    popper.add((Action)it.next());
                }
            }
            return popper;
        }
        return null;
    }

    public Image getIconImage() {
        Icon treeicon = IconFactory.getIcon((short)401);
        if (treeicon instanceof ImageIcon) {
            return ((ImageIcon)treeicon).getImage();
        }
        return super.getIconImage();
    }

    private void updateDetail(DataNode dataNode) {
        if (!this.showDetail) {
            return;
        }
        if (dataNode == null) {
            this.setDetailPane(this.helpPanel);
        } else {
            this.detailPlacer.requestDetails(dataNode);
        }
    }

    private void setDetailPane(JComponent detail) {
        detail.setMinimumSize(new Dimension(100, 100));
        this.detailHolder.setView(detail);
    }

    private JComponent getDetailPane() {
        return (JComponent)this.detailHolder.getView();
    }

    private JComponent getDetail(DataNode node) {
        if (!this.detailMap.containsKey(node)) {
            this.detailMap.put(node, this.makeDetail(node));
        }
        return (JComponent)this.detailMap.get(node);
    }

    private JComponent makeDetail(DataNode node) {
        ApplicationDetailViewer dv = this.makeDetailViewer(node);
        dv.addSeparator();
        node.configureDetail(dv);
        CreationState creator = node.getCreator();
        if (creator != null) {
            DataNodeFactory factory;
            final String trace = creator.getFactoryTrace();
            if (trace != null) {
                dv.addPane("Construction trace", new ComponentMaker(){

                    public JComponent getComponent() {
                        return new TextViewer(new StringReader(trace));
                    }
                });
            }
            if ((factory = creator.getFactory()) != null && factory.getDebug()) {
                dv.addSubHead("Debug");
                dv.addKeyedItem("Node class", node.getClass().getName());
                dv.addKeyedItem("Parent node", creator.getParent());
                dv.addKeyedItem("Object", creator.getObject());
                dv.addKeyedItem("Object class", creator.getObject().getClass().getName());
                dv.addKeyedItem("Builder", creator.getBuilder());
            }
        }
        return dv.getComponent();
    }

    private ApplicationDetailViewer makeDetailViewer(DataNode node) {
        return new ApplicationDetailViewer(node);
    }

    static /* synthetic */ void access$2400(StaticTreeViewer x0, JComponent x1) {
        x0.setDetailPane(x1);
    }

    static {
        $assertionsDisabled = !StaticTreeViewer.class.desiredAssertionStatus();
    }

    private class DetailPlacer
    extends Thread {
        private DataNode requestNode;
        private DataNode workingNode;
        private DataNode completeNode;
        private JComponent completeDetail;

        private DetailPlacer() {
        }

        public synchronized void requestDetails(DataNode node) {
            this.requestNode = node;
            this.interrupt();
        }

        public void run() {
            while (true) {
                boolean done;
                if (done = this.requestNode == null ? true : this.requestNode == this.completeNode) {
                    try {
                        DetailPlacer.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.workingNode = this.requestNode;
                    this.completeDetail = StaticTreeViewer.this.getDetail(this.requestNode);
                    this.workingNode = null;
                    this.completeNode = this.requestNode;
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ DetailPlacer this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            StaticTreeViewer.access$2400(DetailPlacer.access$2300(this.this$1), DetailPlacer.access$2200(this.this$1));
                        }
                    });
                }
                DetailPlacer.interrupted();
            }
        }

        static /* synthetic */ JComponent access$2200(DetailPlacer x0) {
            return x0.completeDetail;
        }

        static /* synthetic */ StaticTreeViewer access$2300(DetailPlacer x0) {
            return x0.StaticTreeViewer.this;
        }
    }
}

