/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.IOException;
import javax.swing.JProgressBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.datanode.viewers.StyledTextArea;
import uk.ac.starlink.treeview.StatsValues;

public class StatsViewer
extends StyledTextArea
implements Runnable {
    private NDArray nda;

    public StatsViewer(NDArray nda) {
        this.nda = nda;
        this.addTitle("Array statistics");
        new Thread(this).start();
    }

    public void run() {
        this.fillInData();
    }

    public void fillInData() {
        try {
            ChunkStepper stepper;
            Type type = this.nda.getType();
            OrderedNDShape oshape = this.nda.getShape();
            long npix = oshape.getNumPixels();
            int chunksize = ChunkStepper.defaultChunkSize;
            int nchunk = (int)(npix / (long)chunksize);
            Document doc = this.getDocument();
            int prebar = doc.getLength();
            if (nchunk > 6) {
                final JProgressBar pbar = new JProgressBar(0, nchunk);
                stepper = new ChunkStepper(npix, chunksize){
                    int ichunk;
                    {
                        super(x0, x1);
                        this.ichunk = 0;
                    }

                    public void next() {
                        pbar.setValue(++this.ichunk);
                        super.next();
                    }
                };
                prebar = doc.getLength();
                this.addSubHead("Working...");
                this.addComponent(pbar);
                this.addSeparator();
            } else {
                stepper = new ChunkStepper(npix);
            }
            int postbar = doc.getLength();
            StatsValues stats = new StatsValues(this.nda, stepper);
            if (postbar - prebar > 0) {
                try {
                    doc.remove(prebar, postbar - prebar);
                }
                catch (BadLocationException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.addKeyedItem("Sum", (float)stats.total);
            this.addKeyedItem("Mean", (float)stats.mean);
            this.addKeyedItem("Standard deviation", (float)Math.sqrt(stats.variance));
            this.addSeparator();
            if (stats.minValue != null && stats.maxValue != null) {
                this.addKeyedItem("Minimum pixel value", stats.minValue);
                this.addKeyedItem("      at pixel", NDShape.toString((long[])stats.minPosition));
                this.addKeyedItem("Maximum pixel value", stats.maxValue);
                this.addKeyedItem("      at pixel", NDShape.toString((long[])stats.maxPosition));
                this.addSeparator();
            }
            long ngood = stats.numGood;
            long nbad = npix - ngood;
            this.addKeyedItem("Total number of pixels", npix);
            this.addKeyedItem("Number of good pixels", ngood);
            this.addKeyedItem("Number of bad pixels", nbad);
            this.addKeyedItem("Percentage of good pixels", (float)(100.0 * (double)ngood / (double)npix) + "%");
        }
        catch (IOException e) {
            this.logError(e);
        }
    }
}

