/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.PrintStream;
import java.util.Iterator;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NodeUtil;

public class TreeWriter {
    PrintStream stream;
    boolean showPath;

    public TreeWriter(PrintStream stream, boolean showPath) {
        this.stream = stream;
        this.showPath = showPath;
    }

    public TreeWriter() {
        this(System.out, false);
    }

    private void outLine(String line) {
        this.stream.println(line);
    }

    private String indent(int level, boolean hasChildren) {
        String result = "";
        for (int i = 0; i < level; ++i) {
            result = result + "  ";
        }
        result = result + (hasChildren ? "+ " : "- ");
        return result;
    }

    public void write(DataNode node) {
        this.processNode(0, node);
    }

    private void processNode(int level, DataNode node) {
        boolean hasChildren = false;
        Iterator cIt = null;
        if (node.allowsChildren()) {
            cIt = node.getChildIterator();
            hasChildren = cIt.hasNext();
        }
        if (level > 0) {
            String path;
            StringBuffer line = new StringBuffer().append(this.indent(level, hasChildren)).append('[').append((node.getNodeTLA() + "   ").substring(0, 3)).append("] ").append(node);
            if (this.showPath && (path = NodeUtil.getNodePath(node)) != null) {
                line.append("      ").append(path);
            }
            this.outLine(line.toString());
        }
        if (hasChildren) {
            while (cIt.hasNext()) {
                this.processNode(level + 1, (DataNode)cIt.next());
            }
        }
    }
}

