/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.DockBoundary;

class ChainingDockBoundary
extends DockBoundary {
    private boolean ourLayoutReflects = false;

    public ChainingDockBoundary(int edge) {
        super(edge);
        this.ourLayoutReflects = edge == 5 || edge == 3;
    }

    public ChainingDockBoundary(int edge, int spacing) {
        super(edge, spacing);
        this.ourLayoutReflects = edge == 5 || edge == 3;
    }

    public int getDockIndex(Point p) {
        JToolBar[] toolbars = this.getToolBars();
        int i = 0;
        while (i < toolbars.length) {
            if (toolbars[i].getBounds().contains(p)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public int getDockIndex(JToolBar toolbar) {
        return Arrays.asList(this.getToolBars()).indexOf(toolbar);
    }

    public int getRowIndex(Point p) {
        return 0;
    }

    public int getRowIndex(JToolBar toolbar) {
        if (Arrays.asList(this.getToolBars()).contains(toolbar)) {
            return 0;
        }
        return -1;
    }

    public void validate() {
        int spacing = this.getSpacing();
        int orientation = this.getOrientation();
        int length = 0;
        length = orientation == 0 ? this.width : this.height;
        JToolBar[] bars = this.getToolBars();
        int barDepth = this.getPreferredDepth();
        int barLength = 0;
        int totalBarLength = 0;
        int i = 0;
        while (i < bars.length) {
            JToolBar toolbar = bars[i];
            barLength = this.getPreferredToolBarLength(toolbar);
            if (totalBarLength != 0) {
                totalBarLength += spacing;
            }
            this.setToolBarBounds(toolbar, totalBarLength, 0, Math.min(barLength, length), barDepth);
            totalBarLength += barLength;
            ++i;
        }
        this.setDepth(barDepth);
    }

    private int getPreferredDepth() {
        int depth = 0;
        JToolBar[] toolbars = super.getToolBars();
        int i = 0;
        while (i < toolbars.length) {
            JToolBar toolbar = toolbars[i];
            Dimension d = toolbar.getPreferredSize();
            depth = this.getOrientation() == 0 ? Math.max(depth, d.height) : Math.max(depth, d.width);
            ++i;
        }
        return depth;
    }

    private void setToolBarBounds(JToolBar toolbar, int lengthOffset, int depthOffset, int length, int depth) {
        if (this.getOrientation() == 0) {
            toolbar.setBounds(this.x + lengthOffset, this.y + depthOffset, length, depth);
            if (this.ourLayoutReflects) {
                Rectangle r = toolbar.getBounds();
                this.mirrorBounds(r, this.y);
                toolbar.setBounds(r);
            }
        } else {
            toolbar.setBounds(this.x + depthOffset, this.y + lengthOffset, depth, length);
            if (this.ourLayoutReflects) {
                Rectangle r = toolbar.getBounds();
                this.mirrorBounds(r, this.x);
                toolbar.setBounds(r);
            }
        }
    }
}

