/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.ToolBarHandler;

public abstract class DockBoundary
extends Rectangle {
    private ArrayList ourToolBars = new ArrayList();
    private Rectangle ourDockableBoundary = null;
    private int ourDockableMargin = 10;
    private int ourDockEdge = 1;
    private int ourOrientation = 0;
    private int ourSpacing = 0;

    public DockBoundary(int edge) {
        super(0, 0, 0, 0);
        this.ourDockEdge = edge;
        this.ourDockableBoundary = new Rectangle(0, 0, this.ourDockableMargin, this.ourDockableMargin);
        this.ourOrientation = edge == 1 || edge == 5 ? 0 : 1;
    }

    public DockBoundary(int edge, int spacing) {
        this(edge);
        this.setSpacing(spacing);
    }

    public void setSpacing(int spacing) {
        this.ourSpacing = spacing >= 0 ? spacing : 0;
    }

    public int getSpacing() {
        return this.ourSpacing;
    }

    public int getOrientation() {
        return this.ourOrientation;
    }

    public int getEdge() {
        return this.ourDockEdge;
    }

    public boolean isDockablePoint(Point p) {
        return this.ourDockableBoundary.contains(p);
    }

    public boolean isDraggablePoint(Point p, JToolBar toolbar) {
        return true;
    }

    public abstract int getDockIndex(Point var1);

    public abstract int getDockIndex(JToolBar var1);

    public abstract int getRowIndex(Point var1);

    public abstract int getRowIndex(JToolBar var1);

    public void setPosition(int newX, int newY, int length) {
        super.setLocation(newX, newY);
        if (this.ourOrientation == 0) {
            this.width = length;
        } else {
            this.height = length;
        }
        this.setDepth(0);
        this.validate();
        if (this.ourDockEdge == 5) {
            int depth = Math.abs(this.height);
            this.setBounds(newX, newY - depth, this.width, depth);
        } else if (this.ourDockEdge == 3) {
            int depth = Math.abs(this.width);
            this.setBounds(newX - depth, newY, depth, this.height);
        }
        this.validateDockableBoundary();
    }

    public abstract void validate();

    public void revalidate() {
        this.validate();
        this.validateDockableBoundary();
    }

    public int getDepth() {
        if (this.ourOrientation == 0) {
            return this.height;
        }
        return this.width;
    }

    protected void setDepth(int depth) {
        if (this.ourOrientation == 0) {
            this.height = Math.abs(depth);
        } else {
            this.width = Math.abs(depth);
        }
    }

    public void addToolBar(JToolBar toolbar, int rowIndex, int index) {
        toolbar.setOrientation(this.ourOrientation);
        this.ourToolBars.add(toolbar);
        this.toolBarAdded(toolbar, rowIndex, index);
    }

    public void addToolBar(JToolBar toolbar, Point dropPoint) {
        this.addToolBar(toolbar, this.getRowIndex(dropPoint), this.getDockIndex(dropPoint));
    }

    protected void toolBarAdded(JToolBar toolbar, int rowIndex, int index) {
    }

    public void removeToolBar(JToolBar toolbar) {
        ((AbstractCollection)this.ourToolBars).remove(toolbar);
        this.toolBarRemoved(toolbar);
    }

    public void removeComponent(Component component) {
        if (component instanceof JToolBar) {
            this.removeToolBar((JToolBar)component);
        }
    }

    protected void toolBarRemoved(JToolBar toolbar) {
    }

    public JToolBar[] getToolBars() {
        JToolBar[] bars = new JToolBar[this.ourToolBars.size()];
        bars = this.ourToolBars.toArray(bars);
        return bars;
    }

    public boolean containsToolBar(JToolBar toolbar) {
        return this.ourToolBars.contains(toolbar);
    }

    void refreshHandlers() {
        String key = "ToolBarHandler";
        int i = 0;
        while (i < this.ourToolBars.size()) {
            JToolBar toolbar = (JToolBar)this.ourToolBars.get(i);
            Object prop = toolbar.getClientProperty(key);
            ToolBarHandler handler = (ToolBarHandler)prop;
            if (handler != null) {
                handler.setDockEdge(this.getEdge());
                handler.setDockIndex(this.getDockIndex(toolbar));
                handler.setRowIndex(this.getRowIndex(toolbar));
            }
            ++i;
        }
    }

    protected int getPreferredToolBarLength(JToolBar toolbar) {
        Dimension d = toolbar.getPreferredSize();
        if (this.ourOrientation == 0) {
            return d.width;
        }
        return d.height;
    }

    protected int getPreferredToolBarDepth(JToolBar toolbar) {
        Dimension d = toolbar.getPreferredSize();
        if (this.ourOrientation == 0) {
            return d.height;
        }
        return d.width;
    }

    protected void mirrorBounds(Rectangle r, int mirrorOffset) {
        int distanceFromMirror = 0;
        if (this.getOrientation() == 0) {
            int newY;
            distanceFromMirror = r.y - mirrorOffset;
            r.y = newY = r.y - 2 * distanceFromMirror - r.height;
        } else {
            int newX;
            distanceFromMirror = r.x - mirrorOffset;
            r.x = newX = r.x - 2 * distanceFromMirror - r.width;
        }
    }

    private void validateDockableBoundary() {
        this.ourDockableBoundary.setBounds(this);
        if (this.ourOrientation == 0) {
            this.ourDockableBoundary.height += this.ourDockableMargin;
        } else {
            this.ourDockableBoundary.width += this.ourDockableMargin;
        }
        if (this.ourDockEdge == 5) {
            this.ourDockableBoundary.y -= this.ourDockableMargin;
        } else if (this.ourDockEdge == 3) {
            this.ourDockableBoundary.x -= this.ourDockableMargin;
        }
    }
}

