/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.ChainingDockBoundary;
import org.tigris.toolbar.layouts.DockBoundary;
import org.tigris.toolbar.layouts.DockingConstraints;
import org.tigris.toolbar.layouts.StackingDockBoundary;
import org.tigris.toolbar.layouts.ToolBarHandler;
import org.tigris.toolbar.layouts.WrappingDockBoundary;

public class DockLayout
implements LayoutManager,
LayoutManager2 {
    private DockBoundary ourNorthBoundary = null;
    private DockBoundary ourSouthBoundary = null;
    private DockBoundary ourEastBoundary = null;
    private DockBoundary ourWestBoundary = null;
    private Component ourContent = null;
    private Container ourTargetContainer = null;
    private int ourVerticalSpacing = 0;
    private int ourHorizontalSpacing = 0;
    private boolean ourVersionIsCompatible = false;
    public static final int CHAINING_STYLE = -1;
    public static final int WRAPPING_STYLE = 0;
    public static final int STACKING_STYLE = 1;
    public static final int MAX = Integer.MAX_VALUE;
    public static final int NORTH = 1;
    public static final int SOUTH = 5;
    public static final int EAST = 3;
    public static final int WEST = 7;
    public static final int CENTER = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String north = "North";
    public static final String south = "South";
    public static final String east = "East";
    public static final String west = "West";
    public static final String center = "Center";

    public DockLayout(Container target) {
        this(target, 0);
    }

    public DockLayout(Container target, int style) {
        this.ourTargetContainer = target;
        String specVersion = System.getProperty("java.specification.version");
        try {
            float ver = Float.parseFloat(specVersion);
            if (ver > 1.2f) {
                this.ourVersionIsCompatible = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.installDockBoundary(this.createBoundary(style, 1, 2));
        this.installDockBoundary(this.createBoundary(style, 5, 2));
        this.installDockBoundary(this.createBoundary(style, 3, 2));
        this.installDockBoundary(this.createBoundary(style, 7, 2));
    }

    private DockBoundary createBoundary(int style, int edge, int spacing) {
        if (style == 1) {
            return new StackingDockBoundary(edge, spacing);
        }
        if (style == -1) {
            return new ChainingDockBoundary(edge, spacing);
        }
        return new WrappingDockBoundary(edge, spacing);
    }

    public void setHorizontalSpacing(int spacing) {
        this.ourHorizontalSpacing = spacing;
    }

    public void setVerticalSpacing(int spacing) {
        this.ourVerticalSpacing = spacing;
    }

    public void setToolBarSpacing(int spacing) {
        this.ourNorthBoundary.setSpacing(spacing);
        this.ourSouthBoundary.setSpacing(spacing);
        this.ourEastBoundary.setSpacing(spacing);
        this.ourWestBoundary.setSpacing(spacing);
    }

    public int getHorizontalSpacing() {
        return this.ourHorizontalSpacing;
    }

    public int getVerticalSpacing() {
        return this.ourVerticalSpacing;
    }

    public int getToolBarSpacing() {
        return this.ourNorthBoundary.getSpacing();
    }

    public void installDockBoundary(DockBoundary boundary) {
        if (boundary == null) {
            return;
        }
        if (!this.ourVersionIsCompatible && !(boundary instanceof ChainingDockBoundary)) {
            boundary = new ChainingDockBoundary(boundary.getEdge());
        }
        int edge = boundary.getEdge();
        DockBoundary db = this.getBoundary(edge);
        JToolBar[] toolbars = null;
        if (db != null) {
            toolbars = db.getToolBars();
        }
        if (toolbars != null) {
            int i = 0;
            while (i < toolbars.length) {
                boundary.addToolBar(toolbars[i], 0, Integer.MAX_VALUE);
                ++i;
            }
        }
        if (edge == 1) {
            this.ourNorthBoundary = boundary;
        } else if (edge == 5) {
            this.ourSouthBoundary = boundary;
        } else if (edge == 3) {
            this.ourEastBoundary = boundary;
        } else if (edge == 7) {
            this.ourWestBoundary = boundary;
        }
    }

    private DockBoundary getBoundary(int edge) {
        if (edge == 1) {
            return this.ourNorthBoundary;
        }
        if (edge == 5) {
            return this.ourSouthBoundary;
        }
        if (edge == 3) {
            return this.ourEastBoundary;
        }
        if (edge == 7) {
            return this.ourWestBoundary;
        }
        return null;
    }

    private DockBoundary getBoundary(String edge) {
        if (edge.equals(north)) {
            return this.ourNorthBoundary;
        }
        if (edge.equals(south)) {
            return this.ourSouthBoundary;
        }
        if (edge.equals(east)) {
            return this.ourEastBoundary;
        }
        if (edge.equals(west)) {
            return this.ourWestBoundary;
        }
        return null;
    }

    DockBoundary getBoundary(Point point) {
        if (this.ourNorthBoundary.contains(point)) {
            return this.ourNorthBoundary;
        }
        if (this.ourSouthBoundary.contains(point)) {
            return this.ourSouthBoundary;
        }
        if (this.ourWestBoundary.contains(point)) {
            return this.ourWestBoundary;
        }
        if (this.ourEastBoundary.contains(point)) {
            return this.ourEastBoundary;
        }
        return null;
    }

    DockBoundary getDockableBoundary(Point point) {
        if (this.ourNorthBoundary.isDockablePoint(point)) {
            return this.ourNorthBoundary;
        }
        if (this.ourSouthBoundary.isDockablePoint(point)) {
            return this.ourSouthBoundary;
        }
        if (this.ourWestBoundary.isDockablePoint(point)) {
            return this.ourWestBoundary;
        }
        if (this.ourEastBoundary.isDockablePoint(point)) {
            return this.ourEastBoundary;
        }
        return null;
    }

    Container getTargetContainer() {
        return this.ourTargetContainer;
    }

    private ToolBarHandler getHandler(JToolBar toolbar) {
        if (toolbar == null) {
            return null;
        }
        ToolBarHandler handler = this.extractHandler(toolbar);
        if (handler == null) {
            String key = "ToolBarHandler";
            handler = new ToolBarHandler(toolbar, this);
            toolbar.putClientProperty(key, handler);
        }
        return handler;
    }

    private ToolBarHandler extractHandler(JToolBar toolbar) {
        if (toolbar == null) {
            return null;
        }
        String key = "ToolBarHandler";
        Object prop = toolbar.getClientProperty(key);
        return (ToolBarHandler)prop;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        String constr = "";
        if (component instanceof JToolBar && constraints instanceof DockingConstraints) {
            JToolBar toolbar = (JToolBar)component;
            ToolBarHandler handler = this.getHandler(toolbar);
            DockingConstraints dc = (DockingConstraints)constraints;
            handler.setConstraints(dc);
            int i = handler.getDockEdge();
            if (i == 1) {
                constr = north;
            } else if (i == 5) {
                constr = south;
            } else if (i == 7) {
                constr = west;
            } else if (i == 3) {
                constr = east;
            }
        } else if (constraints != null && constraints instanceof String) {
            constr = constraints.toString();
        }
        this.addLayoutComponent(constr, component);
    }

    public void addLayoutComponent(String constraints, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component instanceof JToolBar) {
                JToolBar toolbar = (JToolBar)component;
                ToolBarHandler handler = this.getHandler(toolbar);
                DockBoundary boundary = null;
                if (constraints != null) {
                    boundary = this.getBoundary(constraints);
                }
                if (boundary == null) {
                    boundary = this.getBoundary(handler.getDockEdge());
                }
                boundary.addToolBar(toolbar, handler.getRowIndex(), handler.getDockIndex());
                boundary.refreshHandlers();
            } else {
                this.ourContent = component;
            }
        }
    }

    public void removeLayoutComponent(Component component) {
        this.ourNorthBoundary.removeComponent(component);
        this.ourSouthBoundary.removeComponent(component);
        this.ourEastBoundary.removeComponent(component);
        this.ourWestBoundary.removeComponent(component);
        if (component == this.ourContent) {
            this.ourContent = null;
        }
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container target) {
        this.ourTargetContainer = target;
        Object object = target.getTreeLock();
        synchronized (object) {
            int width = target.getWidth();
            int height = target.getHeight();
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = height - insets.bottom;
            int left = insets.left;
            int right = width - insets.right;
            this.ourNorthBoundary.setPosition(left, top, width);
            this.ourSouthBoundary.setPosition(left, bottom, width);
            int northHeight = this.ourNorthBoundary.getDepth();
            int southHeight = this.ourSouthBoundary.getDepth();
            if (northHeight > 0) {
                northHeight += this.ourVerticalSpacing;
            }
            if (southHeight > 0) {
                southHeight += this.ourVerticalSpacing;
            }
            height = bottom - top - northHeight - southHeight;
            this.ourWestBoundary.setPosition(left, top += northHeight, height);
            this.ourEastBoundary.setPosition(right, top, height);
            int eastWidth = this.ourEastBoundary.getDepth();
            int westWidth = this.ourWestBoundary.getDepth();
            if (eastWidth > 0) {
                eastWidth += this.ourHorizontalSpacing;
            }
            if (westWidth > 0) {
                westWidth += this.ourHorizontalSpacing;
            }
            width = right - left - eastWidth - westWidth;
            left += westWidth;
            if (this.ourContent != null) {
                this.ourContent.setBounds(left, top, width, height);
            }
        }
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension prefDim = null;
        prefDim = this.ourContent != null ? this.ourContent.getPreferredSize() : new Dimension(0, 0);
        int dim = this.ourNorthBoundary.getDepth();
        if (dim > 0 && prefDim.height > 0) {
            prefDim.height += this.ourVerticalSpacing;
        }
        prefDim.height += dim;
        dim = this.ourSouthBoundary.getDepth();
        if (dim > 0 && prefDim.height > 0) {
            prefDim.height += this.ourVerticalSpacing;
        }
        prefDim.height += dim;
        dim = this.ourWestBoundary.getDepth();
        if (dim > 0 && prefDim.width > 0) {
            prefDim.width += this.ourHorizontalSpacing;
        }
        prefDim.width += dim;
        dim = this.ourEastBoundary.getDepth();
        if (dim > 0 && prefDim.width > 0) {
            prefDim.width += this.ourHorizontalSpacing;
        }
        prefDim.width += dim;
        return prefDim;
    }

    public Dimension minimumLayoutSize(Container target) {
        return new Dimension(0, 0);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

