/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.util.URLUtils;

public class Stilts {
    private static ObjectFactory taskFactory_;
    private static ObjectFactory modeFactory_;
    public static final String VERSION_RESOURCE = "stilts.version";

    public static void main(String[] args) {
        Loader.loadProperties();
        URLUtils.installCustomHandlers();
        LineInvoker invoker = new LineInvoker("stilts", taskFactory_);
        int status = invoker.invoke(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public static ObjectFactory getModeFactory() {
        return modeFactory_;
    }

    public static ObjectFactory getTaskFactory() {
        return taskFactory_;
    }

    public static String getVersion() {
        return IOUtils.getResourceContents((Class)Stilts.class, (String)VERSION_RESOURCE);
    }

    private static void init() {
        taskFactory_ = new ObjectFactory(Task.class);
        String taskPkg = "uk.ac.starlink.ttools.task.";
        taskFactory_.register("calc", taskPkg + "Calc");
        taskFactory_.register("coneskymatch", taskPkg + "MultiCone");
        taskFactory_.register("funcs", taskPkg + "ShowFunctions");
        taskFactory_.register("regquery", taskPkg + "RegQuery");
        taskFactory_.register("plot2d", taskPkg + "TablePlot2D");
        taskFactory_.register("plot3d", taskPkg + "TablePlot3D");
        taskFactory_.register("plothist", taskPkg + "TableHistogram");
        taskFactory_.register("server", taskPkg + "StiltsServer");
        taskFactory_.register("sqlclient", taskPkg + "SqlClient");
        taskFactory_.register("sqlskymatch", taskPkg + "SqlCone");
        taskFactory_.register("sqlupdate", taskPkg + "SqlUpdate");
        taskFactory_.register("tcat", taskPkg + "TableCat");
        taskFactory_.register("tcatn", taskPkg + "TableCatN");
        taskFactory_.register("tcopy", taskPkg + "TableCopy");
        taskFactory_.register("tcube", taskPkg + "TableCube");
        taskFactory_.register("tjoin", taskPkg + "TableJoinN");
        taskFactory_.register("tmatch1", taskPkg + "TableMatch1");
        taskFactory_.register("tmatch2", taskPkg + "TableMatch2");
        taskFactory_.register("tmatchn", taskPkg + "TableMatchN");
        taskFactory_.register("tpipe", taskPkg + "TablePipe");
        taskFactory_.register("tskymatch2", taskPkg + "SkyMatch2");
        taskFactory_.register("votcopy", taskPkg + "VotCopy");
        taskFactory_.register("votlint", taskPkg + "VotLint");
        modeFactory_ = new ObjectFactory(ProcessingMode.class);
        String modePkg = "uk.ac.starlink.ttools.mode.";
        modeFactory_.register("out", modePkg + "CopyMode");
        modeFactory_.register("meta", modePkg + "MetadataMode");
        modeFactory_.register("stats", modePkg + "StatsMode");
        modeFactory_.register("count", modePkg + "CountMode");
        modeFactory_.register("cgi", modePkg + "CgiMode");
        modeFactory_.register("discard", modePkg + "NullMode");
        modeFactory_.register("topcat", modePkg + "TopcatMode");
        modeFactory_.register("plastic", modePkg + "PlasticMode");
        modeFactory_.register("tosql", modePkg + "JdbcMode");
    }

    static {
        Stilts.init();
    }
}

