/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.cone.ConeSearcher;

public abstract class ConeErrorPolicy {
    private final String name_;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.ttools.cone");
    public static final ConeErrorPolicy ABORT = new ConeErrorPolicy("abort"){

        public ConeSearcher adjustConeSearcher(ConeSearcher base) {
            return base;
        }
    };
    public static final ConeErrorPolicy IGNORE = new ConeErrorPolicy("ignore"){

        public ConeSearcher adjustConeSearcher(ConeSearcher base) {
            return new WrapperConeSearcher(this, base, "ignore"){
                private final /* synthetic */ 2 this$0;
                {
                    this.this$0 = this$0;
                    super(x0, x1);
                }

                public StarTable performSearch(double ra, double dec, double sr) throws IOException {
                    try {
                        return this.base_.performSearch(ra, dec, sr);
                    }
                    catch (IOException e) {
                        ConeErrorPolicy.access$100().info(ConeErrorPolicy.access$000(ra, dec, sr) + " failed: " + e);
                        return null;
                    }
                }
            };
        }
    };
    public static final ConeErrorPolicy RETRY = ConeErrorPolicy.createRetryPolicy("retry", -1);

    protected ConeErrorPolicy(String name) {
        this.name_ = name;
    }

    public String toString() {
        return this.name_;
    }

    public abstract ConeSearcher adjustConeSearcher(ConeSearcher var1);

    public static ConeErrorPolicy createRetryPolicy(String name, final int nTry) {
        return new ConeErrorPolicy(name){

            public ConeSearcher adjustConeSearcher(ConeSearcher base) {
                return new RetryConeSearcher(base, nTry);
            }
        };
    }

    public static ConeErrorPolicy addAdvice(ConeErrorPolicy policy, final String advice) {
        return new ConeErrorPolicy(policy.toString()){

            public ConeSearcher adjustConeSearcher(ConeSearcher base) {
                return new AdviceConeSearcher(base, advice);
            }
        };
    }

    private static String searchString(double ra, double dec, double sr) {
        return "search " + '(' + (float)ra + ", " + (float)dec + ')' + '+' + (float)sr;
    }

    private static class AdviceConeSearcher
    extends WrapperConeSearcher {
        private final String advice_;

        AdviceConeSearcher(ConeSearcher base, String advice) {
            super(base, "advice");
            this.advice_ = advice;
        }

        public StarTable performSearch(double ra, double dec, double sr) throws IOException {
            try {
                return this.base_.performSearch(ra, dec, sr);
            }
            catch (IOException e) {
                throw (IOException)new IOException(this.advice_).initCause(e);
            }
        }
    }

    private static class RetryConeSearcher
    extends WrapperConeSearcher {
        private final int nTry_;

        RetryConeSearcher(ConeSearcher base, int nTry) {
            super(base, "retry");
            this.nTry_ = nTry;
        }

        public StarTable performSearch(double ra, double dec, double sr) throws IOException {
            IOException lastError = null;
            for (int nFail = 0; this.nTry_ <= 0 || nFail < this.nTry_; ++nFail) {
                try {
                    return this.base_.performSearch(ra, dec, sr);
                }
                catch (IOException e) {
                    String count = Integer.toString(nFail + 1);
                    if (this.nTry_ > 0) {
                        count = count + "/" + this.nTry_;
                    }
                    logger.info(ConeErrorPolicy.searchString(ra, dec, sr) + " attempt " + count + " failed");
                    lastError = e;
                    continue;
                }
            }
            throw (IOException)new IOException(this.nTry_ + " attempts failed ").initCause(lastError);
        }
    }

    private static abstract class WrapperConeSearcher
    implements ConeSearcher {
        final ConeSearcher base_;
        final String descrip_;

        WrapperConeSearcher(ConeSearcher base, String descrip) {
            this.base_ = base;
            this.descrip_ = descrip;
        }

        public int getRaIndex(StarTable result) {
            return this.base_.getRaIndex(result);
        }

        public int getDecIndex(StarTable result) {
            return this.base_.getDecIndex(result);
        }

        public void close() {
            this.base_.close();
        }

        public String toString() {
            return this.descrip_ + "(" + this.base_.toString() + ")";
        }
    }
}

