/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.cone.ConeErrorPolicy;
import uk.ac.starlink.ttools.cone.ConeErrorPolicyParameter;
import uk.ac.starlink.ttools.cone.ConeMatcher;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coner;
import uk.ac.starlink.ttools.cone.JELQuerySequenceFactory;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.JoinFixActionParameter;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.TableProducer;

public abstract class SkyConeMatch2
extends SingleMapperTask {
    private final Coner coner_;
    private final Parameter raParam_;
    private final Parameter decParam_;
    private final Parameter srParam_;
    private final Parameter copycolsParam_;
    private final ChoiceParameter modeParam_;
    private final Parameter distcolParam_;
    private final BooleanParameter ostreamParam_;
    private final IntegerParameter parallelParam_;
    private final ConeErrorPolicyParameter erractParam_;
    private final JoinFixActionParameter fixcolsParam_;
    private final Parameter insuffixParam_;
    private final Parameter conesuffixParam_;

    public SkyConeMatch2(String purpose, Coner coner, boolean allowParallel) {
        super(purpose, new ChoiceMode(), true, true);
        String inSys;
        String sysParen;
        this.coner_ = coner;
        ArrayList<Object> paramList = new ArrayList<Object>();
        String system = coner.getSkySystem();
        if (system == null || system.length() == 0) {
            sysParen = "";
            inSys = "";
        } else {
            sysParen = " (" + system + ")";
            inSys = " in the " + system + " coordinate system";
        }
        this.raParam_ = new Parameter("ra");
        this.raParam_.setUsage("<expr>");
        this.raParam_.setPrompt("Right Ascension expression in degrees" + sysParen);
        this.raParam_.setDescription(new String[]{"<p>Expression which evaluates to the right ascension in degrees" + inSys, "for the request at each row of the input table.", "This will usually be the name or ID of a column in the", "input table, or a function involving one.", "</p>"});
        paramList.add(this.raParam_);
        this.decParam_ = new Parameter("dec");
        this.decParam_.setUsage("<expr>");
        this.decParam_.setPrompt("Declination expression in degrees" + sysParen);
        this.decParam_.setDescription(new String[]{"<p>Expression which evaluates to the declination in degrees" + inSys, "for the request at each row of the input table.", "This will usually be the name or ID of a column in the", "input table, or a function involving one.", "</p>"});
        paramList.add(this.decParam_);
        this.srParam_ = new Parameter("sr");
        this.srParam_.setUsage("<expr>");
        this.srParam_.setPrompt("Search radius in degrees");
        this.srParam_.setDescription(new String[]{"<p>Expression which evaluates to the search radius in degrees", "for the request at each row of the input table.", "This will often be a constant numerical value, but may be", "the name or ID of a column in the input table,", "or a function involving one.", "</p>"});
        paramList.add(this.srParam_);
        this.modeParam_ = new ChoiceParameter("find", (Object[])new String[]{"best", "all"});
        this.modeParam_.setDefault("all");
        this.modeParam_.setPrompt("Type of match to perform");
        this.modeParam_.setDescription(new String[]{"<p>Determines which matches are retained.", "If <code>best</code> is selected, then only the query table row", "which best matches the row from the input table will be output.", "If <code>all</code> is selected, then any rows in the query table", "which match the input table are output.", "</p>"});
        paramList.add(this.modeParam_);
        this.copycolsParam_ = new Parameter("copycols");
        this.copycolsParam_.setUsage("<colid-list>");
        this.copycolsParam_.setNullPermitted(true);
        this.copycolsParam_.setDefault("*");
        this.copycolsParam_.setPrompt("Columns to be copied from input table");
        this.copycolsParam_.setDescription(new String[]{"<p>List of columns from the input table which are to be copied", "to the output table.", "Each column identified here will be prepended to the", "columns of the combined output table,", "and its value for each row taken from the input table row", "which provided the parameters of the query which produced it.", "See <ref id='colid-list'/> for list syntax.", "The default setting is \"<code>*</code>\", which means that", "all columns from the input table are included in the output.", "</p>"});
        paramList.add(this.copycolsParam_);
        this.distcolParam_ = new Parameter("scorecol");
        this.distcolParam_.setNullPermitted(true);
        this.distcolParam_.setDefault("Separation");
        this.distcolParam_.setPrompt("Angular distance output column name");
        this.distcolParam_.setUsage("<col-name>");
        this.distcolParam_.setDescription(new String[]{"<p>Gives the name of a column in the output table to contain", "the distance between the requested central position and the", "actual position of the returned row.", "The distance returned is an angular distance in degrees.", "If a null value is chosen, no distance column will appear", "in the output table.", "</p>"});
        paramList.add(this.distcolParam_);
        this.parallelParam_ = new IntegerParameter("parallel");
        this.parallelParam_.setDefault("1");
        this.parallelParam_.setPrompt("Number of queries to make in parallel");
        this.parallelParam_.setUsage("<n>");
        this.parallelParam_.setMinimum(1);
        this.parallelParam_.setDescription(new String[]{"<p>Allows multiple cone searches to be performed concurrently.", "If set to the default value, 1, the cone query corresponding", "to the first row of the input table will be dispatched,", "when that is completed the query corresponding to the", "second row will be dispatched, and so on.", "If set to <code>&lt;n&gt;</code>, then queries will be overlapped", "in such a way that up to approximately <code>&lt;n&gt;</code>", "may be running at any one time.", "Whether this is a good idea, and what might be a sensible", "maximum value for <code>&lt;n&gt;</code>, depends on the", "characteristics of the service being queried.", "</p>"});
        if (allowParallel) {
            paramList.add(this.parallelParam_);
        }
        this.erractParam_ = new ConeErrorPolicyParameter("erract");
        paramList.add((Object)this.erractParam_);
        this.ostreamParam_ = new BooleanParameter("ostream");
        this.ostreamParam_.setDefault("false");
        this.ostreamParam_.setPrompt("Whether output will be strictly streamed");
        this.ostreamParam_.setDescription(new String[]{"<p>If set true, this will cause the operation to stream on", "output, so that the output table is built up as the results", "are obtained from the cone search service.", "The disadvantage of this is that some output modes and formats", "need multiple passes through the data to work, so depending", "on the output destination, the operation may fail if this is set.", "Use with care (or be prepared for the operation to fail).", "</p>"});
        paramList.add(this.ostreamParam_);
        this.fixcolsParam_ = new JoinFixActionParameter("fixcols");
        this.insuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffix0", "the input table", "_0");
        this.conesuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffix1", "the cone result table", "_1");
        paramList.add((Object)this.fixcolsParam_);
        paramList.add(this.insuffixParam_);
        paramList.add(this.conesuffixParam_);
        this.getParameterList().addAll(paramList);
        this.getParameterList().addAll(Arrays.asList(coner.getParameters()));
    }

    /*
     * WARNING - void declaration
     */
    protected TableProducer createProducer(Environment env) throws TaskException {
        void var10_11;
        boolean bestOnly;
        String copyColIdList = this.copycolsParam_.stringValue(env);
        String raString = this.raParam_.stringValue(env);
        String decString = this.decParam_.stringValue(env);
        String srString = this.srParam_.stringValue(env);
        boolean ostream = this.ostreamParam_.booleanValue(env);
        int parallelism = this.parallelParam_.intValue(env);
        ConeErrorPolicy erract = this.erractParam_.policyValue(env);
        if (erract == ConeErrorPolicy.ABORT) {
            String advice = "Cone search failed - try other values of " + this.erractParam_.getName() + " parameter?";
            erract = ConeErrorPolicy.addAdvice(erract, advice);
        }
        String distanceCol = this.distcolParam_.stringValue(env);
        String mode = this.modeParam_.stringValue(env);
        if (mode.toLowerCase().equals("best")) {
            bestOnly = true;
        } else if (mode.toLowerCase().equals("all")) {
            bestOnly = false;
        } else {
            throw new UsageException("Unknown value of " + this.modeParam_.getName() + "??");
        }
        TableProducer inProd = this.createInputProducer(env);
        ConeSearcher coneSearcher = erract.adjustConeSearcher(this.coner_.createSearcher(env, (boolean)var10_11));
        JoinFixAction inFixAct = this.fixcolsParam_.getJoinFixAction(env, this.insuffixParam_);
        JoinFixAction coneFixAct = this.fixcolsParam_.getJoinFixAction(env, this.conesuffixParam_);
        JELQuerySequenceFactory qsFact = new JELQuerySequenceFactory(raString, decString, srString);
        ConeMatcher coneMatcher = new ConeMatcher(coneSearcher, inProd, qsFact, (boolean)var10_11, parallelism, copyColIdList, distanceCol, inFixAct, coneFixAct);
        coneMatcher.setStreamOutput(ostream);
        return coneMatcher;
    }
}

